/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.squashtest.tm.domain.library.LibraryNode;

public final class LibraryUtils {
    private LibraryUtils() {
    }

    public static String generateUniqueName(List<String> copiesNames, String sourceName, String token, int maxNameSize) {
        SimpleTokenHelper helper = new SimpleTokenHelper(token);
        return LibraryUtils.generateUniqueName(copiesNames, sourceName, maxNameSize, helper);
    }

    private static String generateUniqueName(Collection<String> copiesNames, String sourceName, int maxNameSize, TokenHelper helper) {
        String baseName = sourceName;
        String tokenRegexp = helper.getTokenRegexp();
        int newCopyNumber = LibraryUtils.generateUniqueIndex(copiesNames, baseName, 0, tokenRegexp);
        String result = helper.buildResult(newCopyNumber, baseName);
        while (result.length() > maxNameSize) {
            int extraCharsNumber = result.length() - maxNameSize;
            baseName = LibraryUtils.substringBaseName(baseName, extraCharsNumber);
            newCopyNumber = LibraryUtils.generateUniqueIndex(copiesNames, baseName, newCopyNumber, tokenRegexp);
            result = helper.buildResult(newCopyNumber, baseName);
        }
        return result;
    }

    public static String generateUniqueCopyName(List<String> copiesNames, String sourceName, int maxNameSize, String suffix) {
        return LibraryUtils.generateUniqueName(copiesNames, sourceName, suffix, maxNameSize);
    }

    private static String substringBaseName(String baseName, int extraCharsNumber) {
        baseName = ((String)baseName).substring(0, ((String)baseName).length() - extraCharsNumber - 3) + "...";
        return baseName;
    }

    public static String generateNonClashingName(String source, Collection<String> siblings, int maxNameSize) {
        if (LibraryUtils.noNameClash(source, siblings)) {
            return source;
        }
        ParenthesisTokenHelper helper = new ParenthesisTokenHelper();
        return LibraryUtils.generateUniqueName(siblings, source, maxNameSize, helper);
    }

    public static void fixConflictNames(Collection<String> contentNames, LibraryNode node) {
        if (contentNames.isEmpty()) {
            return;
        }
        String reqName = node.getName();
        String newName = LibraryUtils.generateNonClashingName(reqName, contentNames, 255);
        if (!newName.equals(reqName)) {
            node.setName(newName);
        }
        contentNames.add(newName);
    }

    private static int generateUniqueIndex(Collection<String> siblings, String baseName, int minIndex, String tokenRegexp) {
        List<String> potentialClashes = LibraryUtils.filterPotentialClashes(baseName, siblings);
        Pattern p = Pattern.compile(Pattern.quote(baseName) + tokenRegexp);
        return LibraryUtils.computeNonClashingIndex(p, potentialClashes, minIndex);
    }

    private static int computeNonClashingIndex(Pattern indexLookupPattern, Collection<String> potentialClashes, int minCopyNumber) {
        int result;
        int maxIndex = 0;
        for (String sibling : potentialClashes) {
            Matcher m = indexLookupPattern.matcher(sibling);
            if (!m.find()) continue;
            int siblingIndex = Integer.parseInt(m.group(1));
            maxIndex = Math.max(maxIndex, siblingIndex);
        }
        if ((result = ++maxIndex) < minCopyNumber) {
            result = minCopyNumber;
        }
        return result;
    }

    private static List<String> filterPotentialClashes(String source, Collection<String> siblings) {
        ArrayList<String> potentialClashes = new ArrayList<String>(siblings.size());
        for (String sibling : siblings) {
            if (!sibling.startsWith(source)) continue;
            potentialClashes.add(sibling);
        }
        return potentialClashes;
    }

    private static boolean noNameClash(String name, Collection<String> siblings) {
        return siblings.isEmpty() || !siblings.contains(name);
    }

    private static class ParenthesisTokenHelper
    implements TokenHelper {
        private ParenthesisTokenHelper() {
        }

        @Override
        public String buildResult(int index, String baseName) {
            return baseName + " (" + index + ")";
        }

        @Override
        public String getTokenRegexp() {
            return " \\((\\d+)\\)";
        }
    }

    private static final class SimpleTokenHelper
    implements TokenHelper {
        private String token;

        private SimpleTokenHelper(String token) {
            this.token = token;
        }

        @Override
        public String buildResult(int index, String baseName) {
            return baseName + this.token + index;
        }

        @Override
        public String getTokenRegexp() {
            return this.token + "(\\d+)";
        }
    }

    private static interface TokenHelper {
        public String getTokenRegexp();

        public String buildResult(int var1, String var2);
    }
}

