/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution.automatedexecution;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.execution.automatedexecution.AutomatedExecutionFailureDetailService;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.FailureDetailDao;
import org.squashtest.tm.service.internal.repository.IssueDao;

@Service
@Transactional
public class AutomatedExecutionFailureDetailServiceImpl
implements AutomatedExecutionFailureDetailService {
    private final FailureDetailDao failureDetailDao;
    private final IssueDao issueDao;
    private final ExecutionDao executionDao;

    public AutomatedExecutionFailureDetailServiceImpl(FailureDetailDao failureDetailDao, IssueDao issueDao, ExecutionDao executionDao) {
        this.failureDetailDao = failureDetailDao;
        this.issueDao = issueDao;
        this.executionDao = executionDao;
    }

    @Override
    public void upsertFailureDetail(String failureDetailMessage, List<FailureDetail> existingFailureDetailList, AutomatedExecutionExtender extender, TestPlanItem testPlanItem) {
        FailureDetail matchingFailureDetail = existingFailureDetailList.stream().filter(fd -> fd.getMessage().equals(failureDetailMessage)).findFirst().orElse(null);
        if (matchingFailureDetail != null) {
            matchingFailureDetail.addExecutionExtender(extender);
            FailureDetail fd2 = (FailureDetail)this.failureDetailDao.save(matchingFailureDetail);
            this.addFailureDetailIssuesToNewExecution(fd2, extender.getExecution());
        } else {
            String userLogin = UserContextHolder.getUsername();
            FailureDetail failureDetail = new FailureDetail(failureDetailMessage, userLogin, new Date(), testPlanItem);
            failureDetail.addExecutionExtender(extender);
            this.failureDetailDao.save(failureDetail);
        }
    }

    private void addFailureDetailIssuesToNewExecution(FailureDetail failureDetail, Execution execution) {
        if (failureDetail.getIssueList().getAllIssues() == null | failureDetail.getIssueList().getAllIssues().isEmpty()) {
            return;
        }
        List<Issue> newExecIssues = failureDetail.getIssueList().getAllIssues().stream().map(fdIssue -> fdIssue.duplicateFailureDetailExecutionForExecution(execution)).toList();
        this.issueDao.saveAll(newExecIssues);
    }

    @Override
    public FailureDetail findFailureDetailById(Long failureDetailId) {
        return this.failureDetailDao.findById(failureDetailId).orElse(null);
    }

    @Override
    public List<Execution> findExecutionsByFailureDetailAndDateAfter(Long failureDetailId, Date createdOnDate) {
        return this.executionDao.findExecutionsByFailureDetailAndDateAfter(failureDetailId, createdOnDate);
    }

    @Override
    @Transactional
    public void resetExtenderFailureDetail(AutomatedExecutionExtender extender) {
        ArrayList<FailureDetail> failureDetailsToUpdate = new ArrayList<FailureDetail>();
        ArrayList<FailureDetail> orphanFailureDetails = new ArrayList<FailureDetail>();
        for (FailureDetail fd : extender.getFailureDetailList()) {
            fd.getAutomatedExecutions().remove(extender);
            if (fd.getAutomatedExecutions().isEmpty()) {
                orphanFailureDetails.add(fd);
                continue;
            }
            failureDetailsToUpdate.add(fd);
        }
        if (!failureDetailsToUpdate.isEmpty()) {
            this.failureDetailDao.saveAll(failureDetailsToUpdate);
        }
        if (!orphanFailureDetails.isEmpty()) {
            this.failureDetailDao.deleteAll(orphanFailureDetails);
        }
        extender.getFailureDetailList().clear();
    }
}

