/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.testautomation;

import java.util.Date;
import java.util.List;
import org.squashtest.tm.domain.testautomation.AnalysisStatus;

public record TestCandidateAnalysisDto(Long analysisId, List<String> projectNames, int nbTotalCandidates, int nbProcessedCandidates, AnalysisStatus status, String evaluatedBy, Date createdOn, Date terminatedOn) {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Long analysisId;
        private List<String> projectNames;
        private int nbTotalCandidates;
        private int nbProcessedCandidates;
        private AnalysisStatus status;
        private String evaluatedBy;
        private Date createdOn;
        private Date terminatedOn;

        private Builder() {
        }

        public Builder withAnalysisId(Long analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public Builder withProjectNames(List<String> projectNames) {
            this.projectNames = projectNames;
            return this;
        }

        public Builder withNbTotalCandidates(int nbTotalCandidates) {
            this.nbTotalCandidates = nbTotalCandidates;
            return this;
        }

        public Builder withNbProcessedCandidates(int nbProcessedCandidates) {
            this.nbProcessedCandidates = nbProcessedCandidates;
            return this;
        }

        public Builder withStatus(AnalysisStatus status) {
            this.status = status;
            return this;
        }

        public Builder withEvaluatedBy(String evaluatedBy) {
            this.evaluatedBy = evaluatedBy;
            return this;
        }

        public Builder withCreatedOn(Date createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public Builder withTerminatedOn(Date terminatedOn) {
            this.terminatedOn = terminatedOn;
            return this;
        }

        public TestCandidateAnalysisDto build() {
            return new TestCandidateAnalysisDto(this.analysisId, this.projectNames, this.nbTotalCandidates, this.nbProcessedCandidates, this.status, this.evaluatedBy, this.createdOn, this.terminatedOn);
        }
    }
}

