/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.pivotdefinition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractAuditablePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.LibraryPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotAttachmentEntity;

public class ProjectPivot
extends AbstractAuditablePivot
implements PivotAttachmentEntity {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="attachments")
    private List<AttachmentPivot> attachments = new ArrayList<AttachmentPivot>();
    @JsonProperty(value="bound_info_lists")
    private Map<InfoListProjectBindingType, String> boundInfoLists = new HashMap<InfoListProjectBindingType, String>();
    @JsonProperty(value="bound_custom_fields")
    private Map<String, List<BindableEntity>> boundCufs = new HashMap<String, List<BindableEntity>>();
    @JsonProperty(value="requirement_library")
    LibraryPivot requirementLibrary;
    @JsonProperty(value="test_case_library")
    LibraryPivot testCaseLibrary;
    @JsonProperty(value="campaign_library")
    LibraryPivot campaignLibrary;

    @Override
    public String getBasePivotId() {
        return "P";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<AttachmentPivot> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(List<AttachmentPivot> attachments) {
        this.attachments = attachments;
    }

    @Override
    public void addAttachment(AttachmentPivot attachment) {
        this.attachments.add(attachment);
    }

    public Map<InfoListProjectBindingType, String> getBoundInfoLists() {
        return this.boundInfoLists;
    }

    public void setBoundInfoLists(Map<InfoListProjectBindingType, String> boundInfoLists) {
        this.boundInfoLists = boundInfoLists;
    }

    public void addBoundInfoList(InfoListProjectBindingType infoList, Long infoListId) {
        this.boundInfoLists.put(infoList, "%s%s".formatted("IL", infoListId));
    }

    public Map<String, List<BindableEntity>> getBoundCufs() {
        return this.boundCufs;
    }

    public void setBoundCufs(Map<String, List<BindableEntity>> boundCufs) {
        this.boundCufs = boundCufs;
    }

    public void addBoundCuf(Long cufId, BindableEntity boundEntity) {
        String cufIdPivot = "%s%s".formatted("CUF", cufId);
        this.boundCufs.compute(cufIdPivot, (k, v) -> v == null ? new ArrayList() : v).add(boundEntity);
    }

    public LibraryPivot getRequirementLibrary() {
        return this.requirementLibrary;
    }

    public void setRequirementLibrary(LibraryPivot requirementLibrary) {
        this.requirementLibrary = requirementLibrary;
    }

    public LibraryPivot getTestCaseLibrary() {
        return this.testCaseLibrary;
    }

    public void setTestCaseLibrary(LibraryPivot testCaseLibrary) {
        this.testCaseLibrary = testCaseLibrary;
    }

    public LibraryPivot getCampaignLibrary() {
        return this.campaignLibrary;
    }

    public void setCampaignLibrary(LibraryPivot campaignLibrary) {
        this.campaignLibrary = campaignLibrary;
    }
}

