/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.project;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.AdministrableProject;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectimporter.PivotFormatImportStatus;
import org.squashtest.tm.domain.synchronisation.SynchronisationKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.project.ProjectDisplayService;
import org.squashtest.tm.service.display.scm.server.ScmServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.BindMilestoneToProjectDialogData;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.dto.PartyProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.PivotFormatImportDto;
import org.squashtest.tm.service.internal.display.dto.ProfileDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDataInfo;
import org.squashtest.tm.service.internal.display.dto.ProjectViewDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.ProjectGrid;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.display.AclDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AiServerDisplayDao;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.BugTrackerDisplayDao;
import org.squashtest.tm.service.internal.repository.display.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.display.InfoListDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ProfileDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ProjectDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestAutomationServerDisplayDao;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.GlobalProjectPivotImporterService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional
public class ProjectDisplayServiceImpl
implements ProjectDisplayService {
    private static final String SPACE_CHAR = " ";
    private static final String PARTY_NAME_LOGIN_START = " (";
    private static final String PARTY_NAME_LOGIN_END = ")";
    private final ProjectDisplayDao projectDisplayDao;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final DSLContext dsl;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ProjectDao projectDao;
    private final UserAccountService userAccountService;
    private final BugTrackerDisplayDao bugTrackerDisplayDao;
    private final GenericProjectFinder projectFinder;
    private final GenericProjectManagerService genericProjectManager;
    private final InfoListDisplayDao infoListDisplayDao;
    private final CustomFieldDao customFieldDao;
    private final ScmServerDisplayService scmServerDisplayService;
    private final TestAutomationServerDisplayDao testAutomationServerDisplayDao;
    private final AiServerDisplayDao aiServerDisplayDao;
    private final TestAutomationProjectManagerService testAutomationProjectManagerService;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final MilestoneBindingManagerService milestoneBindingManagerService;
    private final TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService;
    private final ProjectManagerService projectManager;
    private final AclDisplayDao aclDisplayDao;
    private final ProfileDisplayDao profileDisplayDao;
    private final UltimateLicenseAvailabilityService ultimateLicenseService;
    private final GlobalProjectPivotImporterService globalProjectPivotImporterService;

    @Inject
    ProjectDisplayServiceImpl(DSLContext dsl, PermissionEvaluationService permissionEvaluationService, ProjectDao projectDao, UserAccountService userAccountService, ProjectDisplayDao projectDisplayDao, AttachmentDisplayDao attachmentDisplayDao, BugTrackerDisplayDao bugTrackerDisplayDao, GenericProjectFinder projectFinder, GenericProjectManagerService genericProjectManager, InfoListDisplayDao infoListDisplayDao, CustomFieldDao customFieldDao, ScmServerDisplayService scmServerDisplayService, TestAutomationServerDisplayDao testAutomationServerDisplayDao, AiServerDisplayDao aiServerDisplayDao, MilestoneDisplayDao milestoneDisplayDao, MilestoneBindingManagerService milestoneBindingManagerService, TestAutomationProjectManagerService testAutomationProjectManagerService, TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService, ProjectManagerService projectManager, AclDisplayDao aclDisplayDao, ProfileDisplayDao profileDisplayDao, UltimateLicenseAvailabilityService ultimateLicenseService, GlobalProjectPivotImporterService globalProjectPivotImporterService) {
        this.dsl = dsl;
        this.permissionEvaluationService = permissionEvaluationService;
        this.projectDao = projectDao;
        this.userAccountService = userAccountService;
        this.projectDisplayDao = projectDisplayDao;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.bugTrackerDisplayDao = bugTrackerDisplayDao;
        this.projectFinder = projectFinder;
        this.genericProjectManager = genericProjectManager;
        this.infoListDisplayDao = infoListDisplayDao;
        this.customFieldDao = customFieldDao;
        this.scmServerDisplayService = scmServerDisplayService;
        this.testAutomationServerDisplayDao = testAutomationServerDisplayDao;
        this.aiServerDisplayDao = aiServerDisplayDao;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.milestoneBindingManagerService = milestoneBindingManagerService;
        this.testAutomationProjectManagerService = testAutomationProjectManagerService;
        this.templateConfigurablePluginBindingService = templateConfigurablePluginBindingService;
        this.projectManager = projectManager;
        this.aclDisplayDao = aclDisplayDao;
        this.profileDisplayDao = profileDisplayDao;
        this.ultimateLicenseService = ultimateLicenseService;
        this.globalProjectPivotImporterService = globalProjectPivotImporterService;
    }

    @Override
    public GridResponse findAll(GridRequest request) {
        List<Long> projectIds;
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            UserDto currentUser = this.userAccountService.findCurrentUserDto();
            List<Long> partyIds = currentUser.getPartyIds();
            this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin(partyIds);
            projectIds = this.projectDao.findAllManagedProjectIds(partyIds);
        } else {
            projectIds = this.projectDao.findAllProjectAndTemplateIds();
        }
        ProjectGrid projectGrid = new ProjectGrid(projectIds);
        return projectGrid.getRows(request, this.dsl);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<NamedReference> getTemplateNamedReferences() {
        return this.projectDisplayDao.findAllReferences();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    @CheckEntityExists(entityType=Project.class)
    public ProjectViewDto getProjectView(@Id long projectId) {
        AdministrableProject adminProject = this.projectFinder.findAdministrableProjectById(projectId);
        ProjectViewDto project = this.projectDisplayDao.getProjectOrTemplateById(projectId);
        project.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(project.getAttachmentListId()));
        project.setHasTemplateConfigurablePluginBinding(this.templateConfigurablePluginBindingService.isProjectConfigurationBoundToTemplate(projectId));
        if (project.isTemplate()) {
            boolean isLinkedToProjects = !this.projectDisplayDao.getProjectsLinkedToTemplate(projectId).isEmpty();
            project.setTemplateLinkedToProjects(isLinkedToProjects);
            project.setAllProjectBoundToTemplate(this.projectDisplayDao.findProjectsByTemplateId(projectId));
        }
        this.bugTrackerDisplayDao.appendBugTrackerBindings(Collections.singletonList(project));
        this.customFieldDao.appendCustomFieldBindings(Collections.singletonList(project));
        project.setPartyProjectPermissions(this.getPartyProjectPermissions(projectId));
        project.setPermissions(this.getProjectPermissions(projectId));
        project.setAvailableScmServers(this.scmServerDisplayService.getAllServersAndRepositories());
        project.setAvailableTestAutomationServers(this.testAutomationServerDisplayDao.findAll());
        project.setAvailableAiServers(this.aiServerDisplayDao.findAll());
        project.setBoundTestAutomationProjects(this.testAutomationProjectManagerService.findAllByTMProject(projectId));
        project.setAvailableBugtrackers(this.bugTrackerDisplayDao.findAllBugtrackerBindableToProject());
        project.setInfoLists(this.infoListDisplayDao.findAllWithItems());
        this.milestoneDisplayDao.appendBoundMilestoneInformation(Collections.singletonList(project));
        this.appendBugtrackerProjectNames(adminProject, project);
        this.appendAllowedStatuses(adminProject, project);
        project.setAllowTcModifDuringExec(adminProject.allowTcModifDuringExec());
        project.setExistingImports(this.getExistingImports(projectId));
        this.appendProfiles(project);
        return project;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Map<String, Boolean> getProjectStatusesInUse(long projectId) {
        HashMap<String, Boolean> statusesInUse = new HashMap<String, Boolean>();
        boolean settledIsUsed = this.genericProjectManager.projectUsesExecutionStatus(projectId, ExecutionStatus.valueOf((String)ExecutionStatus.SETTLED.toString()));
        boolean untestableIsUsed = this.genericProjectManager.projectUsesExecutionStatus(projectId, ExecutionStatus.valueOf((String)ExecutionStatus.UNTESTABLE.toString()));
        statusesInUse.put(ExecutionStatus.SETTLED.toString(), settledIsUsed);
        statusesInUse.put(ExecutionStatus.UNTESTABLE.toString(), untestableIsUsed);
        return statusesInUse;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public List<PartyProjectPermissionDto> getPartyProjectPermissions(Long projectId) {
        Field<String> partyName = this.getPartyNameField();
        Field isPartyActive = DSL.when((Condition)Tables.CORE_USER.LOGIN.isNull(), (Object)true).otherwise((Field)Tables.CORE_USER.ACTIVE);
        Field isPartyTeam = DSL.when((Condition)Tables.CORE_USER.LOGIN.isNull(), (Object)true).otherwise((Object)false);
        return this.dsl.select((SelectField)DSL.val((Long)projectId), partyName, (SelectField)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID, (SelectField)isPartyActive, (SelectField)Tables.ACL_GROUP.ID, (SelectField)Tables.ACL_GROUP.QUALIFIED_NAME, (SelectField)isPartyTeam).from((TableLike)Tables.ACL_GROUP).join((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_GROUP.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID)).join((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_OBJECT_IDENTITY.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID)).leftJoin((TableLike)Tables.CORE_USER).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).leftJoin((TableLike)Tables.CORE_TEAM).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_TEAM.PARTY_ID)).where(Tables.ACL_OBJECT_IDENTITY.IDENTITY.eq((Object)projectId)).and(Tables.ACL_CLASS.CLASSNAME.in((Object[])new String[]{"org.squashtest.tm.domain.project.Project", "org.squashtest.tm.domain.project.ProjectTemplate"})).fetchInto(PartyProjectPermissionDto.class);
    }

    private Map<String, Collection<String>> getProjectPermissions(Long projectId) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        Map<Long, Multimap<String, String>> permissionsMultimap = this.aclDisplayDao.findPermissionsForProject(Collections.singletonList(projectId), currentUser.getPartyIds());
        return permissionsMultimap.getOrDefault(projectId, (Multimap<String, String>)ArrayListMultimap.create()).asMap();
    }

    private Field<String> getPartyNameField() {
        return DSL.when((Condition)Tables.CORE_USER.LOGIN.isNull(), (Field)Tables.CORE_TEAM.NAME).otherwise(DSL.when((Condition)Tables.CORE_USER.FIRST_NAME.isNull().or(Tables.CORE_USER.FIRST_NAME.eq((Object)"")), (Field)DSL.concat((Field[])new Field[]{Tables.CORE_USER.LAST_NAME, DSL.val((String)PARTY_NAME_LOGIN_START), Tables.CORE_USER.LOGIN, DSL.val((String)PARTY_NAME_LOGIN_END)})).otherwise(DSL.concat((Field[])new Field[]{Tables.CORE_USER.FIRST_NAME, DSL.val((String)SPACE_CHAR), Tables.CORE_USER.LAST_NAME, DSL.val((String)PARTY_NAME_LOGIN_START), Tables.CORE_USER.LOGIN, DSL.val((String)PARTY_NAME_LOGIN_END)})));
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public BindMilestoneToProjectDialogData findAvailableMilestones(long projectId) {
        BindMilestoneToProjectDialogData dialogData = new BindMilestoneToProjectDialogData();
        dialogData.setGlobalMilestones(this.appendFilteredMilestonesListAccordingType(projectId, "global"));
        dialogData.setPersonalMilestones(this.appendFilteredMilestonesListAccordingType(projectId, "personal"));
        dialogData.setOtherMilestones(this.appendFilteredMilestonesListAccordingType(projectId, "other"));
        return dialogData;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ProjectDataInfo getProjectDataInfoOnAction(Long projectId, ProjectDataInfo.ProjectAction action) {
        List<String> nonEmptyWorkspaces = this.projectManager.getProjectData(projectId);
        boolean isDeletionAction = ProjectDataInfo.ProjectAction.DELETION.equals((Object)action);
        if (!nonEmptyWorkspaces.isEmpty()) {
            String i18nKeyMessage = this.getWithDataI18nKeyActionMessage(isDeletionAction);
            return new ProjectDataInfo(true, i18nKeyMessage, nonEmptyWorkspaces);
        }
        String i18nKeyMessage = this.getWithoutDataI18nKeyActionMessage(projectId, isDeletionAction);
        return new ProjectDataInfo(false, i18nKeyMessage);
    }

    @Override
    public boolean checkRemotePluginIsAvailableInProject(ProjectViewDto dto) {
        return dto.getAvailablePlugins().stream().anyMatch(projectPluginDto -> SynchronisationKind.AUTOM_JIRA.getName().equals(projectPluginDto.getId()));
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public List<String> fetchBugtrackerProjectNames(long projectId) {
        return this.projectDisplayDao.fetchBugtrackerProjectNames(projectId);
    }

    private String getWithDataI18nKeyActionMessage(boolean isDeletionAction) {
        if (isDeletionAction) {
            return "sqtm-core.administration-workspace.projects.dialog.message.cannot-delete-project-with-data";
        }
        return "sqtm-core.administration-workspace.projects.dialog.message.cannot-coerce-into-template";
    }

    private String getWithoutDataI18nKeyActionMessage(Long projectId, boolean isDeletionAction) {
        if (isDeletionAction) {
            if (this.haveExecutedTests(projectId)) {
                return "sqtm-core.administration-workspace.projects.dialog.message.delete-project-with-linked-jobs";
            }
            return "sqtm-core.administration-workspace.projects.dialog.message.delete-project";
        }
        return "sqtm-core.administration-workspace.projects.dialog.message.coerce-into-template";
    }

    private boolean haveExecutedTests(Long projectId) {
        Collection<Long> taProjectIds = this.testAutomationProjectManagerService.findAllIdsByTMProject(projectId);
        if (!taProjectIds.isEmpty()) {
            return this.testAutomationProjectManagerService.haveExecutedTests(taProjectIds);
        }
        return false;
    }

    private void appendBugtrackerProjectNames(AdministrableProject adminProject, ProjectViewDto project) {
        GenericProject genericProject = adminProject.getProject();
        if (genericProject.isBoundToBugtracker()) {
            project.setBugtrackerProjectNames(genericProject.getBugtrackerProjectNames());
        }
    }

    private void appendAllowedStatuses(AdministrableProject adminProject, ProjectViewDto project) {
        CampaignLibrary cl = adminProject.getCampaignLibrary();
        HashMap<String, Boolean> allowedStatuses = new HashMap<String, Boolean>();
        allowedStatuses.put(ExecutionStatus.SETTLED.toString(), cl.allowsStatus(ExecutionStatus.SETTLED));
        allowedStatuses.put(ExecutionStatus.UNTESTABLE.toString(), cl.allowsStatus(ExecutionStatus.UNTESTABLE));
        project.setAllowedStatuses(allowedStatuses);
    }

    private List<MilestoneDto> appendFilteredMilestonesListAccordingType(long projectId, String type) {
        List<Milestone> filteredMilestones = this.milestoneBindingManagerService.getAllBindableMilestoneForProject(projectId, type);
        ArrayList<MilestoneDto> filteredMilestonesDto = new ArrayList<MilestoneDto>();
        filteredMilestones.forEach(milestone -> {
            MilestoneDto milestoneDto = new MilestoneDto();
            milestoneDto.setId(milestone.getId());
            milestoneDto.setLabel(milestone.getLabel());
            milestoneDto.setDescription(milestone.getDescription());
            milestoneDto.setRange(milestone.getRange().name());
            milestoneDto.setEndDate(milestone.getEndDate());
            milestoneDto.setStatus(milestone.getStatus().name());
            milestoneDto.setOwnerFirstName(milestone.getOwner().getFirstName());
            milestoneDto.setOwnerLastName(milestone.getOwner().getLastName());
            milestoneDto.setOwnerLogin(milestone.getOwner().getLogin());
            filteredMilestonesDto.add(milestoneDto);
        });
        return filteredMilestonesDto;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public List<PivotFormatImportDto> getExistingImports(long projectId) {
        List<PivotFormatImportDto> pivotFormatImportDtos = this.projectDisplayDao.getExistingImports(projectId);
        this.appendImportLogFilePath(pivotFormatImportDtos);
        return pivotFormatImportDtos;
    }

    private void appendImportLogFilePath(List<PivotFormatImportDto> pivotFormatImportDtos) {
        pivotFormatImportDtos.forEach(pivotFormatImportDto -> {
            boolean hasWarningStatus = PivotFormatImportStatus.WARNING.equals((Object)pivotFormatImportDto.getStatus());
            String importLogFilePath = hasWarningStatus ? this.globalProjectPivotImporterService.getImportWarningLogFilePath(pivotFormatImportDto.getId(), pivotFormatImportDto.getType()) : this.globalProjectPivotImporterService.getImportErrorLogFilePath(pivotFormatImportDto.getId(), pivotFormatImportDto.getType());
            File file = new File(importLogFilePath);
            if (file.exists()) {
                pivotFormatImportDto.setImportLogFilePath(importLogFilePath);
            }
        });
    }

    private void appendProfiles(ProjectViewDto project) {
        boolean isUltimateAvailable = this.ultimateLicenseService.isAvailable();
        List<ProfileDto> profiles = this.profileDisplayDao.findAll().stream().filter(profile -> isUltimateAvailable || profile.isSystem()).filter(ProfileDto::isActive).toList();
        project.setAvailableProfiles(profiles);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public boolean checkIfProjectBugtrackerHasKnownIssues(long projectId, long bugtrackerId) {
        return this.projectDisplayDao.findHasKnownIssuesByProjectIdAndBugtrackerId(projectId, bugtrackerId);
    }
}

