/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractJdbcDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcIterationDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcSprintDeletionHandler;

public class JdbcCampaignDeletionHandler
extends AbstractJdbcDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcCampaignDeletionHandler.class);
    private final Set<Long> folderIds;
    private final Set<Long> campaignIds;
    private final Set<Long> sprintIds;
    private final Set<Long> sprintGroupIds;
    private final Set<Long> allNodeIds;
    private final JdbcIterationDeletionHandler iterationDeletionHandler;
    private final JdbcSprintDeletionHandler sprintDeletionHandler;

    public JdbcCampaignDeletionHandler(Collection<Long> folderIds, Collection<Long> campaignIds, Collection<Long> sprintGroupIds, Collection<Long> sprintIds, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, JdbcIterationDeletionHandler iterationDeletionHandler, JdbcSprintDeletionHandler sprintDeletionHandler, String operationId) {
        super(dslContext, attachmentRepository, reorderHelper, operationId, entityManager);
        this.iterationDeletionHandler = Objects.requireNonNull(iterationDeletionHandler);
        this.sprintDeletionHandler = Objects.requireNonNull(sprintDeletionHandler);
        this.folderIds = new HashSet<Long>(Objects.requireNonNull(folderIds));
        this.campaignIds = new HashSet<Long>(Objects.requireNonNull(campaignIds));
        this.sprintGroupIds = new HashSet<Long>(Objects.requireNonNull(sprintGroupIds));
        this.sprintIds = new HashSet<Long>(Objects.requireNonNull(sprintIds));
        this.allNodeIds = new HashSet<Long>(folderIds);
        this.allNodeIds.addAll(campaignIds);
        this.allNodeIds.addAll(sprintGroupIds);
        this.allNodeIds.addAll(sprintIds);
    }

    private Condition inFolderIds() {
        return Tables.CAMPAIGN_FOLDER.CLN_ID.in(this.folderIds);
    }

    private Condition inCampaignIds() {
        return Tables.CAMPAIGN.CLN_ID.in(this.campaignIds);
    }

    private Condition inMilestoneCampaignIds() {
        return Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.in(this.campaignIds);
    }

    private Condition inSprintGroupIds() {
        return Tables.SPRINT_GROUP.CLN_ID.in(this.sprintGroupIds);
    }

    private Condition inSprintIds() {
        return Tables.SPRINT.CLN_ID.in(this.sprintIds);
    }

    private Condition inAllNodeIds() {
        return Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(this.allNodeIds);
    }

    public OperationReport delete() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.deleteLinkedIterations();
        this.deleteSprints();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.performDeleteOperations();
        this.cleanWorkingTable();
        this.logEndProcess();
        return this.makeOperationReport();
    }

    private void performDeleteOperations() {
        this.deleteCampaignTestPlanItems();
        this.deleteRelationships();
        this.deleteRootRelationships();
        this.deleteCampaignMilestones();
        this.deleteNodes();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
    }

    private void deleteCampaignTestPlanItems() {
        this.workingTables.delete(Tables.CAMPAIGN.CLN_ID, Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID);
        this.logDelete((Table<?>)Tables.CAMPAIGN_TEST_PLAN_ITEM);
    }

    private void deleteCampaignMilestones() {
        this.workingTables.delete(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID, Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID);
        this.logDelete((Table<?>)Tables.MILESTONE_CAMPAIGN);
    }

    private void deleteNodes() {
        this.workingTables.delete(Tables.CAMPAIGN_FOLDER.CLN_ID, Tables.CAMPAIGN_FOLDER.CLN_ID);
        this.workingTables.delete(Tables.CAMPAIGN.CLN_ID, Tables.CAMPAIGN.CLN_ID);
        this.workingTables.delete(Tables.SPRINT_GROUP.CLN_ID, Tables.SPRINT_GROUP.CLN_ID);
        this.workingTables.delete(Tables.SPRINT.CLN_ID, Tables.SPRINT.CLN_ID);
        this.workingTables.delete(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID);
        this.logDelete((Table<?>)Tables.CAMPAIGN_LIBRARY_NODE);
    }

    private void deleteRootRelationships() {
        Set<Long> parentIds = this.findParentLibraries();
        this.workingTables.delete(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID);
        this.reorderHelper.reorder((Collection<Long>)parentIds, Tables.CAMPAIGN_LIBRARY_CONTENT);
        this.logDelete((Table<?>)Tables.CAMPAIGN_LIBRARY_CONTENT);
    }

    private Set<Long> findParentLibraries() {
        return this.dslContext.select((SelectField)Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_CONTENT).where(Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID.in(this.allNodeIds)).fetchSet((Field)Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID);
    }

    private void deleteRelationships() {
        Set<Long> parentIds = this.findParents();
        this.workingTables.delete(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CLN_RELATIONSHIP.ANCESTOR_ID);
        this.workingTables.delete(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CLN_RELATIONSHIP.DESCENDANT_ID);
        this.reorderHelper.reorder((Collection<Long>)parentIds, Tables.CLN_RELATIONSHIP);
        this.logDelete((Table<?>)Tables.CLN_RELATIONSHIP);
    }

    private Set<Long> findParents() {
        return this.dslContext.select((SelectField)Tables.CLN_RELATIONSHIP.ANCESTOR_ID).from((TableLike)Tables.CLN_RELATIONSHIP).where(Tables.CLN_RELATIONSHIP.DESCENDANT_ID.in(this.workingTables.selectIds(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID))).and(Tables.CLN_RELATIONSHIP.ANCESTOR_ID.notIn(this.allNodeIds)).fetchSet((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID);
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.addCampaignMilestones();
        this.addCampaignFolders();
        this.addCampaigns();
        this.addSprintGroups();
        this.addSprints();
        this.addCampaignLibraryNodes();
        this.addCustomFieldValues();
        this.addAttachmentList();
    }

    private void addCustomFieldValues() {
        this.workingTables.addEntity(Tables.CUSTOM_FIELD_VALUE.CFV_ID, () -> this.makeSelectCustomFieldValues(Tables.CAMPAIGN_FOLDER.CLN_ID, BindableEntity.CAMPAIGN_FOLDER).union(this.makeSelectCustomFieldValues(Tables.CAMPAIGN.CLN_ID, BindableEntity.CAMPAIGN)));
    }

    private void deleteLinkedIterations() {
        this.iterationDeletionHandler.deleteIterations();
    }

    private void deleteSprints() {
        this.sprintDeletionHandler.deleteSprints();
    }

    private void addCampaignMilestones() {
        this.workingTables.addEntity(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID, () -> this.makeSelectClause(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID).from((TableLike)Tables.MILESTONE_CAMPAIGN).where(this.inMilestoneCampaignIds()));
    }

    private void addCampaignFolders() {
        this.workingTables.addEntity(Tables.CAMPAIGN_FOLDER.CLN_ID, () -> this.makeSelectClause(Tables.CAMPAIGN_FOLDER.CLN_ID).from((TableLike)Tables.CAMPAIGN_FOLDER).where(this.inFolderIds()));
    }

    private void addCampaigns() {
        this.workingTables.addEntity(Tables.CAMPAIGN.CLN_ID, () -> this.makeSelectClause(Tables.CAMPAIGN.CLN_ID).from((TableLike)Tables.CAMPAIGN).where(this.inCampaignIds()));
    }

    private void addSprintGroups() {
        this.workingTables.addEntity(Tables.SPRINT_GROUP.CLN_ID, () -> this.makeSelectClause(Tables.SPRINT_GROUP.CLN_ID).from((TableLike)Tables.SPRINT_GROUP).where(this.inSprintGroupIds()));
    }

    private void addSprints() {
        this.workingTables.addEntity(Tables.SPRINT.CLN_ID, () -> this.makeSelectClause(Tables.SPRINT.CLN_ID).from((TableLike)Tables.SPRINT).where(this.inSprintIds()));
    }

    private void addCampaignLibraryNodes() {
        this.workingTables.addEntity(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, () -> this.makeSelectClause(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).where(this.inAllNodeIds()));
    }

    private void addAttachmentList() {
        this.workingTables.addEntity(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, () -> this.makeSelectAttachmentList(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID));
    }

    private OperationReport makeOperationReport() {
        OperationReport report = new OperationReport();
        report.addRemoved(this.folderIds, "folder");
        report.addRemoved(this.campaignIds, "campaign");
        return report;
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init deletion process of campaign folder %s, campaign %s. Operation:  %s", this.folderIds, this.campaignIds, this.operationId), new Object[0]);
    }

    private void logEndProcess() {
        LOGGER.info(String.format("End deletion process of campaign folder %s, campaign %s. Time elapsed %s", this.folderIds, this.campaignIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

