/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.project.ProjectVisitor;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;
import org.squashtest.tm.exception.library.CannotDeleteProjectException;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.actionword.ActionWordArranger;
import org.squashtest.tm.service.internal.actionword.ProjectLinkedToActionWordDeletionValidator;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.project.ProjectDeletionHandler;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.internal.repository.ActionWordLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectFilterDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.internal.requirement.RequirementNodeDeletionHandler;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeDeletionHandler;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.security.ObjectIdentityService;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;
import org.squashtest.tm.service.tf.AutomationRequestModificationService;

@Component(value="squashtest.tm.service.deletion.ProjectDeletionHandler")
public class ProjectDeletionHandlerImpl
implements ProjectDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectDeletionHandlerImpl.class);
    @Inject
    private ProjectDao projectDao;
    @Inject
    private GenericProjectDao genericProjectDao;
    @Inject
    private CampaignNodeDeletionHandler campaignDeletionHandler;
    @Inject
    private TestCaseNodeDeletionHandler testCaseDeletionHandker;
    @Inject
    private RequirementNodeDeletionHandler requirementDeletionHandler;
    @Inject
    private AutomationRequestModificationService autorequestModificationService;
    @Inject
    private ObjectIdentityService objectIdentityService;
    @Inject
    private ProjectsPermissionManagementService projectPermissionManagementService;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CustomReportLibraryNodeDao crlnDao;
    @Inject
    private ActionWordLibraryNodeDao awlnDao;
    @Autowired
    private ProjectLinkedToActionWordDeletionValidator projectLinkedToActionWordDeletionValidator;
    @Inject
    private CustomReportLibraryNodeService crlnService;
    @Inject
    private CustomFieldBindingModificationService bindingService;
    @Inject
    private MilestoneBindingManagerService milestoneBindingManager;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private ProjectFilterDao projectFilterDao;
    @Inject
    private TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService;
    @Inject
    private ActionWordArranger actionWordArranger;
    @Inject
    private StoredCredentialsManager storedCredentialsManager;
    @Inject
    private EnvironmentVariableBindingService environmentVariableBindingService;
    @Inject
    private GridConfigurationService gridConfigurationService;

    @Override
    public void deleteProject(long projectId) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        if (ProjectHelper.isTemplate(project)) {
            this.projectDao.unbindAllFromTemplate(project.getId());
        }
        this.actionWordArranger.arrangeActionWordsBeforeProjectDeleting(projectId);
        this.milestoneBindingManager.unbindAllMilestonesFromProject(project);
        this.bindingService.removeCustomFieldBindings(projectId);
        this.environmentVariableBindingService.unbindAllByEntityIdAndType(projectId, EVBindableEntity.PROJECT);
        this.gridConfigurationService.deleteColumnConfigForProject(projectId);
        this.doDeleteProject(projectId);
    }

    @Override
    public void checkProjectContainsOnlyFolders(long projectId) {
        List<String> nonEmptyWorkspaces = this.projectDao.nonEmptyWorkspacesInProject(projectId);
        long nonActionWordFolder = this.projectDao.countNonFolderInActionWord(projectId);
        if (!this.projectLinkedToActionWordDeletionValidator.isDeletable(nonActionWordFolder)) {
            nonEmptyWorkspaces.add("sqtm-core.action-word-workspace.label.short");
        }
        if (!nonEmptyWorkspaces.isEmpty()) {
            throw new CannotDeleteProjectException("non-folders are found in the project", nonEmptyWorkspaces);
        }
    }

    @Override
    public void checkProjectContainsOnlyFolders(Project project) {
        this.checkProjectContainsOnlyFolders(project.getId());
    }

    private void doDeleteProject(long projectId) {
        LOGGER.debug("The project #{} is being deleted", new Object[]{projectId});
        this.deleteAllLibrariesContent(projectId);
        GenericProject project = this.loadProjectForDeletion(projectId);
        project.accept(new ProjectVisitor(){

            public void visit(ProjectTemplate projectTemplate) {
            }

            public void visit(Project project) {
                ProjectDeletionHandlerImpl.this.removeProjectFromFilters(project);
            }
        });
        CustomReportLibrary customReportLibrary = project.getCustomReportLibrary();
        this.deleteCustomReportLibrary(customReportLibrary);
        ActionWordLibrary actionWordLibrary = project.getActionWordLibrary();
        this.deleteActionWordLibraryNode(actionWordLibrary);
        this.deleteProjectCredentials(project);
        this.removeRemoteSynchronisation(projectId);
        this.removeACLsForProjectAndLibraries(project);
        this.deleteTemplateConfigurableProjectBindings(project);
        this.genericProjectDao.delete(project);
    }

    private GenericProject loadProjectForDeletion(long projectId) {
        return new EntityGraphQueryBuilder<GenericProject>(this.em, GenericProject.class, "SELECT p FROM GenericProject p WHERE p.id = :projectId").addAttributeNodes("customReportLibrary", "automationRequestLibrary", "actionWordLibrary", "requirementLibrary", "campaignLibrary", "testCaseLibrary", "bugtrackerProjects", "testAutomationProjects", "attachmentList").addSubGraph("attachmentList", "attachments").addSubGraph("customReportLibrary", "attachmentList").addSubgraphToSubgraph("customReportLibrary", "attachmentList", "attachments").addSubGraph("actionWordLibrary", "attachmentList").addSubgraphToSubgraph("actionWordLibrary", "attachmentList", "attachments").addSubGraph("requirementLibrary", "attachmentList", "enabledPlugins").addSubgraphToSubgraph("requirementLibrary", "attachmentList", "attachments").addSubGraph("campaignLibrary", "attachmentList", "enabledPlugins").addSubgraphToSubgraph("campaignLibrary", "attachmentList", "attachments").addSubGraph("testCaseLibrary", "attachmentList", "enabledPlugins").addSubgraphToSubgraph("testCaseLibrary", "attachmentList", "attachments").addSubGraph("automationRequestLibrary", "attachmentList").addSubgraphToSubgraph("automationRequestLibrary", "attachmentList", "attachments").execute(Collections.singletonMap("projectId", projectId));
    }

    private void deleteTemplateConfigurableProjectBindings(GenericProject project) {
        this.templateConfigurablePluginBindingService.removeAllForGenericProject(project.getId());
    }

    @Override
    public void deleteAllLibrariesContent(Long projectId) {
        List<Long> testCaseLibraryNodeIds = this.projectDao.findTestCaseLibraryNodesIds(projectId);
        this.deleteLibraryContent(testCaseLibraryNodeIds, this.testCaseDeletionHandker);
        List<Long> requirementLibraryNodeIds = this.projectDao.findRequirementLibraryNodesIds(projectId);
        this.deleteLibraryContent(requirementLibraryNodeIds, this.requirementDeletionHandler);
        this.deleteCustomReportLibraryContent(projectId);
        List<Long> campaignLibraryNodeIds = this.projectDao.findCampaignLibraryNodesIds(projectId);
        this.deleteLibraryContent(campaignLibraryNodeIds, this.campaignDeletionHandler);
        this.autorequestModificationService.deleteRequestByProjectId(projectId);
    }

    private void deleteCustomReportLibraryContent(Long projectId) {
        List descendantIds = this.crlnDao.findAllNodeIdsForLibraryEntity(projectId);
        this.crlnService.delete(descendantIds);
    }

    private void deleteCustomReportLibrary(CustomReportLibrary customReportLibrary) {
        if (this.crlnDao.countNodeFromEntity((CustomReportTreeEntity)customReportLibrary).equals(1L)) {
            this.deleteCustomReportLibraryNode(customReportLibrary);
        }
    }

    private void deleteCustomReportLibraryNode(CustomReportLibrary customReportLibrary) {
        CustomReportLibraryNode node = this.crlnDao.findNodeFromEntity((CustomReportTreeEntity)customReportLibrary);
        node.setLibrary(null);
        node.setEntity(null);
        this.em.remove((Object)node);
        this.em.flush();
    }

    private void deleteActionWordLibraryNode(ActionWordLibrary actionWordLibrary) {
        ActionWordLibraryNode node = this.awlnDao.findNodeFromEntity((ActionWordTreeEntity)actionWordLibrary);
        node.setLibrary(null);
        node.setEntity(null);
        this.em.remove((Object)node);
        this.em.flush();
    }

    private void deleteProjectCredentials(GenericProject project) {
        this.storedCredentialsManager.deleteAllProjectCredentials(project.getId());
    }

    private void removeACLsForProjectAndLibraries(GenericProject project) {
        long rlId = project.getRequirementLibrary().getId();
        long tclId = project.getTestCaseLibrary().getId();
        long clId = project.getCampaignLibrary().getId();
        long crlId = project.getCustomReportLibrary().getId();
        long awlId = project.getActionWordLibrary().getId();
        long arlId = project.getAutomationRequestLibrary().getId();
        this.projectPermissionManagementService.removeAllPermissionsFromObject(RequirementLibrary.class, rlId);
        this.projectPermissionManagementService.removeAllPermissionsFromObject(TestCaseLibrary.class, tclId);
        this.projectPermissionManagementService.removeAllPermissionsFromObject(CampaignLibrary.class, clId);
        this.projectPermissionManagementService.removeAllPermissionsFromObject(CustomReportLibrary.class, crlId);
        this.projectPermissionManagementService.removeAllPermissionsFromObject(ActionWordLibrary.class, awlId);
        this.projectPermissionManagementService.removeAllPermissionsFromObject(AutomationRequestLibrary.class, arlId);
        this.objectIdentityService.removeObjectIdentity(rlId, RequirementLibrary.class);
        this.objectIdentityService.removeObjectIdentity(tclId, TestCaseLibrary.class);
        this.objectIdentityService.removeObjectIdentity(clId, CampaignLibrary.class);
        this.objectIdentityService.removeObjectIdentity(crlId, CustomReportLibrary.class);
        this.objectIdentityService.removeObjectIdentity(awlId, ActionWordLibrary.class);
        this.objectIdentityService.removeObjectIdentity(arlId, AutomationRequestLibrary.class);
        project.accept(new ProjectVisitor(){

            public void visit(ProjectTemplate projectTemplate) {
                ProjectDeletionHandlerImpl.this.projectPermissionManagementService.removeAllPermissionsFromObject(ProjectTemplate.class, projectTemplate.getId());
                ProjectDeletionHandlerImpl.this.objectIdentityService.removeObjectIdentity(projectTemplate.getId(), ProjectTemplate.class);
            }

            public void visit(Project project) {
                ProjectDeletionHandlerImpl.this.projectPermissionManagementService.removeAllPermissionsFromObject(Project.class, project.getId());
                ProjectDeletionHandlerImpl.this.objectIdentityService.removeObjectIdentity(project.getId(), Project.class);
            }
        });
    }

    private void removeRemoteSynchronisation(Long projectId) {
        List<RemoteSynchronisation> listRemoteSync = this.remoteSynchronisationDao.findByProjectId(projectId);
        this.remoteSynchronisationDao.deleteAll(listRemoteSync);
    }

    @Override
    public void removeProjectFromFilters(Project project) {
        List<ProjectFilter> projectFilters = this.projectFilterDao.findByProjectsId(project.getId());
        for (ProjectFilter projectFilter : projectFilters) {
            projectFilter.removeProject(project);
        }
    }

    @Override
    public void checkProjectHasActivePlugin(Project project) {
        this.checkProjectHasActivePlugin(project.getId());
    }

    @Override
    public void checkProjectHasActivePlugin(long projectId) {
        Long numberActivePlugin = this.projectDao.countActivePluginInProject(projectId);
        if (numberActivePlugin > 0L) {
            throw new CannotDeleteProjectException("Active plugins exist in the project");
        }
    }

    private void deleteLibraryContent(List<Long> libraryNodeIds, NodeDeletionHandler<?, ?> deletionHandler) {
        if (!libraryNodeIds.isEmpty()) {
            deletionHandler.deleteNodes(libraryNodeIds);
        }
    }
}

