/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.UUID;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.JdbcTestCaseNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;

@Component
public class JdbcTestCaseNodeDeletionHandlerFactory {
    private final DSLContext dslContext;
    private final AttachmentRepository attachmentRepository;
    private final JdbcBatchReorderHelper reorderHelper;
    private final EntityManager entityManager;

    public JdbcTestCaseNodeDeletionHandlerFactory(DSLContext dslContext, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, EntityManager entityManager) {
        this.dslContext = dslContext;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.entityManager = entityManager;
    }

    public JdbcTestCaseNodeDeletionHandler build(Collection<Long> nodeIds) {
        String operationId = UUID.randomUUID().toString();
        return new JdbcTestCaseNodeDeletionHandler(nodeIds, this.dslContext, this.entityManager, this.attachmentRepository, this.reorderHelper, operationId);
    }
}

