/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import jakarta.inject.Inject;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.map.MultiValueMap;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Milestone;
import org.squashtest.tm.jooq.domain.tables.records.CallTestStepRecord;
import org.squashtest.tm.jooq.domain.tables.records.CoreUserRecord;
import org.squashtest.tm.jooq.domain.tables.records.DatasetRecord;
import org.squashtest.tm.jooq.domain.tables.records.ExecutionExecutionStepsRecord;
import org.squashtest.tm.jooq.domain.tables.records.ExecutionIssuesClosureRecord;
import org.squashtest.tm.jooq.domain.tables.records.ExecutionRecord;
import org.squashtest.tm.jooq.domain.tables.records.ExecutionStepRecord;
import org.squashtest.tm.jooq.domain.tables.records.InfoListItemRecord;
import org.squashtest.tm.jooq.domain.tables.records.IssueRecord;
import org.squashtest.tm.jooq.domain.tables.records.IterationRecord;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.jooq.domain.tables.records.RequirementVersionCoverageRecord;
import org.squashtest.tm.jooq.domain.tables.records.TestCaseLibraryNodeRecord;
import org.squashtest.tm.jooq.domain.tables.records.TestCaseRecord;
import org.squashtest.tm.jooq.domain.tables.records.TestCaseStepsRecord;
import org.squashtest.tm.jooq.domain.tables.records.TestPlanItemRecord;
import org.squashtest.tm.jooq.domain.tables.records.TestSuiteRecord;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.campaign.export.WritableCampaignCSVModel;
import org.squashtest.tm.service.internal.dto.CampaignDto;
import org.squashtest.tm.service.internal.dto.CustomFieldDto;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.ExecutionDto;
import org.squashtest.tm.service.internal.dto.ITPIDto;
import org.squashtest.tm.service.internal.dto.IterationDto;
import org.squashtest.tm.service.internal.dto.TestCaseDto;

public abstract class AbstractCampaignExportCSVModel
implements WritableCampaignCSVModel {
    static final TableField<IterationRecord, Long> ITERATION_ID = Tables.ITERATION.ITERATION_ID;
    static final TableField<IterationRecord, String> ITERATION_NAME = Tables.ITERATION.NAME;
    static final TableField<IterationRecord, Timestamp> ITERATION_SCHEDULED_END_DATE = Tables.ITERATION.SCHEDULED_END_DATE;
    static final TableField<IterationRecord, Timestamp> ITERATION_SCHEDULED_START_DATE = Tables.ITERATION.SCHEDULED_START_DATE;
    static final TableField<IterationRecord, Timestamp> ITERATION_ACTUAL_END_DATE = Tables.ITERATION.ACTUAL_END_DATE;
    static final TableField<IterationRecord, Timestamp> ITERATION_ACTUAL_START_DATE = Tables.ITERATION.ACTUAL_START_DATE;
    static final TableField<TestPlanItemRecord, Long> ITPI_ID = Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID;
    static final TableField<TestPlanItemRecord, String> ITPI_STATUS = Tables.TEST_PLAN_ITEM.EXECUTION_STATUS;
    static final TableField<CoreUserRecord, String> USER_LOGIN = Tables.CORE_USER.LOGIN;
    static final TableField<TestPlanItemRecord, Timestamp> ITPI_LAST_EXECUTED_ON = Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON;
    static final TableField<DatasetRecord, String> DATASET_NAME = Tables.DATASET.NAME;
    static final TableField<TestCaseRecord, Long> TC_ID = Tables.TEST_CASE.TCLN_ID;
    static final TableField<TestCaseRecord, String> TC_IMPORTANCE = Tables.TEST_CASE.IMPORTANCE;
    static final TableField<TestCaseRecord, String> TC_REFERENCE = Tables.TEST_CASE.REFERENCE;
    static final TableField<InfoListItemRecord, String> TC_TYPE = Tables.INFO_LIST_ITEM.as((String)"info_list_1").CODE;
    static final TableField<InfoListItemRecord, String> TC_NATURE = Tables.INFO_LIST_ITEM.as((String)"info_list_2").CODE;
    static final TableField<TestCaseRecord, String> TC_STATUS = Tables.TEST_CASE.TC_STATUS;
    static final TableField<TestCaseRecord, String> TC_PREREQUISITE = Tables.TEST_CASE.PREREQUISITE;
    static final TableField<TestCaseLibraryNodeRecord, String> TC_DESCRIPTION = Tables.TEST_CASE_LIBRARY_NODE.DESCRIPTION;
    static final TableField<RequirementVersionCoverageRecord, Long> TC_REQUIREMENT_VERIFIED = Tables.REQUIREMENT_VERSION_COVERAGE.as((String)"tc_rvc").REQUIREMENT_VERSION_COVERAGE_ID;
    static final TableField<TestCaseLibraryNodeRecord, String> TC_NAME = Tables.TEST_CASE_LIBRARY_NODE.NAME;
    static final TableField<ProjectRecord, Long> PROJECT_ID = Tables.PROJECT.PROJECT_ID;
    static final TableField<ProjectRecord, String> PROJECT_NAME = Tables.PROJECT.NAME;
    static final TableField<ExecutionIssuesClosureRecord, Long> ITPI_ISSUE = Tables.EXECUTION_ISSUES_CLOSURE.as((String)"exec_issue").ISSUE_ID;
    static final TableField<TestSuiteRecord, String> TSu_NAME = Tables.TEST_SUITE.NAME;
    static final Milestone TC_MILESTONE = Tables.MILESTONE.as("tc_milestone");
    static final Milestone IT_MILESTONE = Tables.MILESTONE.as("it_milestone");
    static final TableField<ExecutionRecord, Long> EXECUTION_ID = Tables.EXECUTION.EXECUTION_ID;
    static final TableField<ExecutionRecord, String> EXECUTION_MODE = Tables.EXECUTION.EXECUTION_MODE;
    static final TableField<ExecutionRecord, String> EXECUTION_STATUS = Tables.EXECUTION.EXECUTION_STATUS;
    static final TableField<ExecutionStepRecord, Long> EXECUTION_STEP_ID = Tables.EXECUTION_STEP.EXECUTION_STEP_ID;
    static final TableField<ExecutionStepRecord, String> EXECUTION_STEP_STATUS = Tables.EXECUTION_STEP.EXECUTION_STATUS;
    static final TableField<ExecutionStepRecord, String> ES_LAST_EXECUTED_BY = Tables.EXECUTION_STEP.LAST_EXECUTED_BY;
    static final TableField<ExecutionStepRecord, Timestamp> ES_LAST_EXECUTED_ON = Tables.EXECUTION_STEP.LAST_EXECUTED_ON;
    static final TableField<ExecutionStepRecord, String> ES_COMMENT = Tables.EXECUTION_STEP.COMMENT;
    static final TableField<ExecutionExecutionStepsRecord, Integer> ES_ORDER = Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER;
    static final TableField<ExecutionStepRecord, Long> ES_TS_ID = Tables.EXECUTION_STEP.TEST_STEP_ID;
    static final TableField<RequirementVersionCoverageRecord, Long> ES_REQUIREMENT_VERIFIED = Tables.REQUIREMENT_VERSION_COVERAGE.as((String)"es_rvc").REQUIREMENT_VERSION_COVERAGE_ID;
    static final TableField<TestCaseStepsRecord, Integer> TS_ORDER = Tables.TEST_CASE_STEPS.STEP_ORDER;
    static final TableField<TestCaseStepsRecord, Long> TS_ID = Tables.TEST_CASE_STEPS.STEP_ID;
    static final TableField<CallTestStepRecord, Long> CTS_CALLED_TS = Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID;
    static final TableField<RequirementVersionCoverageRecord, Long> TS_REQUIREMENT_VERIFIED = Tables.REQUIREMENT_VERSION_COVERAGE.as((String)"ts_rvc").REQUIREMENT_VERSION_COVERAGE_ID;
    static final TableField<IssueRecord, Long> ES_ISSUE = Tables.ISSUE.as((String)"es_issue").ISSUE_ID;
    static final String TAG_LABELS = "tag_labels";
    static final int SQL_MAX_PARAMETERS_FOR_IN_CLAUSE = 65535;
    @Inject
    private FeatureManager featureManager;
    @Inject
    protected DSLContext dsl;
    char separator = (char)59;
    int nbColumns;
    boolean milestonesEnabled;
    Campaign campaign;
    CampaignDto campaignDto;
    List<CustomFieldDto> campCUFModel = new ArrayList<CustomFieldDto>();
    SortedSet<CustomFieldDto> iterCUFModel = new TreeSet<CustomFieldDto>(Comparator.comparing(CustomFieldDto::getId));
    SortedSet<CustomFieldDto> tcCUFModel = new TreeSet<CustomFieldDto>(Comparator.comparing(CustomFieldDto::getId));
    SortedSet<CustomFieldDto> execCUFModel = new TreeSet<CustomFieldDto>(Comparator.comparing(CustomFieldDto::getId));
    SortedSet<CustomFieldDto> esCUFModel = new TreeSet<CustomFieldDto>(Comparator.comparing(CustomFieldDto::getId));
    Map<Long, CustomFieldValueDto> campCUFValues = new HashMap<Long, CustomFieldValueDto>();
    MultiValueMap iterCUFValues = new MultiValueMap();
    MultiValueMap tcCUFValues = new MultiValueMap();
    MultiValueMap execCUFValues = new MultiValueMap();
    MultiValueMap esCUFValues = new MultiValueMap();

    @Override
    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    @Override
    public void init() {
        this.campaignDto = this.createCampaignDto(this.campaign);
        this.initIterationsAndCustomFields();
        this.milestonesEnabled = this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
    }

    private CampaignDto createCampaignDto(Campaign campaign) {
        return new CampaignDto(campaign.getId(), campaign.getScheduledStartDate(), campaign.getScheduledEndDate(), campaign.getActualStartDate(), campaign.getActualEndDate());
    }

    abstract void initIterationsAndCustomFields();

    abstract Iterator<Record> getIterationJooqQueryIterator();

    void populateCUFModelAndCufValues(String entityType, Collection<CustomFieldDto> cufModel, MultiValueMap cufValues, Collection<Long> entityIdList) {
        Field tagLabels = this.dsl.select((SelectField)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(" | ")).from((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).where(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).asField(TAG_LABELS);
        if (entityIdList.size() >= 65535) {
            int partitionNumber = entityIdList.size() / 65535 + 1;
            int partitionSize = IntMath.divide((int)entityIdList.size(), (int)partitionNumber, (RoundingMode)RoundingMode.UP);
            List partitions = Lists.partition(entityIdList.stream().toList(), (int)partitionSize);
            partitions.forEach(partition -> this.populateCUF(entityType, cufModel, cufValues, (Collection<Long>)partition, (Field<String>)tagLabels));
        } else {
            this.populateCUF(entityType, cufModel, cufValues, entityIdList, (Field<String>)tagLabels);
        }
    }

    private void populateCUF(String entityType, Collection<CustomFieldDto> cufModel, MultiValueMap cufValues, Collection<Long> entityIdList, Field<String> tagLabels) {
        this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.CFV_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.CF_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.VALUE, (SelectField)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE, tagLabels, (SelectField)Tables.CUSTOM_FIELD.CODE, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE).from((TableLike)Tables.CUSTOM_FIELD_VALUE).innerJoin((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFB_ID)).innerJoin((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(entityIdList).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)entityType))).fetch().forEach(r -> {
            CustomFieldDto newCFDto = new CustomFieldDto((Long)r.get((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID), (String)r.get((Field)Tables.CUSTOM_FIELD.CODE), (String)r.get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE));
            cufModel.add(newCFDto);
            CustomFieldValueDto newCFVDto = this.createCUFValueDto((Record)r);
            cufValues.put(r.get((Field)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID), (Object)newCFVDto);
        });
    }

    void populateCampCUFModelAndCampCUFValues() {
        Field tagLabels = this.dsl.select((SelectField)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(" | ")).from((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).where(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).asField(TAG_LABELS);
        this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.CFV_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID, (SelectField)Tables.CUSTOM_FIELD_BINDING.CF_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.VALUE, (SelectField)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE, (SelectField)tagLabels, (SelectField)Tables.CUSTOM_FIELD.CODE, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE).from((TableLike)Tables.CUSTOM_FIELD_VALUE).innerJoin((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFB_ID)).innerJoin((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Object)this.campaign.getId()).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)"CAMPAIGN"))).fetch().forEach(r -> {
            CustomFieldDto newCFDto = new CustomFieldDto((Long)r.get((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID), (String)r.get((Field)Tables.CUSTOM_FIELD.CODE), (String)r.get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE));
            this.campCUFModel.add(newCFDto);
            CustomFieldValueDto newCFVDto = this.createCUFValueDto((Record)r);
            this.campCUFValues.put((Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID), newCFVDto);
        });
    }

    private CustomFieldValueDto createCUFValueDto(Record r) {
        Field tagLabels = this.dsl.select((SelectField)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(" | ")).from((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).where(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).asField(TAG_LABELS);
        CustomFieldValueDto newCFVDto = r.get((Field)Tables.CUSTOM_FIELD_VALUE.VALUE) != null ? new CustomFieldValueDto((Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID), this.adaptHtmlImageAttribute((String)r.get((Field)Tables.CUSTOM_FIELD_VALUE.VALUE))) : (r.get((Field)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE) != null ? new CustomFieldValueDto((Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID), this.adaptHtmlImageAttribute((String)r.get((Field)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE))) : (r.get(tagLabels) != null ? new CustomFieldValueDto((Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID), this.adaptHtmlImageAttribute((String)r.get(tagLabels))) : new CustomFieldValueDto((Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID), (Long)r.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID))));
        return newCFVDto;
    }

    private String adaptHtmlImageAttribute(String value) {
        Elements elements;
        boolean isHtml;
        Document document = Jsoup.parse((String)value);
        boolean bl = isHtml = !document.text().equals(value);
        if (isHtml && !(elements = document.select("img")).isEmpty()) {
            elements.forEach(element -> {
                String imageSrc = element.attr("src");
                if (!imageSrc.contains("data:image")) {
                    element.attr("alt", imageSrc);
                }
            });
            return document.body().html();
        }
        return value;
    }

    void populateTestCase(Record r, TestCaseDto currentTestCase) {
        if (r.get((Field)AbstractCampaignExportCSVModel.TC_MILESTONE.LABEL) != null) {
            currentTestCase.addMilestone((String)r.get((Field)AbstractCampaignExportCSVModel.TC_MILESTONE.LABEL));
        }
        if (r.get(TC_REQUIREMENT_VERIFIED) != null) {
            currentTestCase.addRequirement((Long)r.get(TC_REQUIREMENT_VERIFIED));
        }
    }

    ITPIDto createNewItpiDto(Record r) {
        ITPIDto newItpi = new ITPIDto((Long)r.get(ITPI_ID), (String)r.get(ITPI_STATUS.as("ITPI_EXECUTION_STATUS")), (String)r.get(USER_LOGIN), (Date)r.get(ITPI_LAST_EXECUTED_ON));
        this.populateItpi(r, newItpi);
        if (r.get(DATASET_NAME) != null) {
            newItpi.setDataset((String)r.get(DATASET_NAME));
        }
        return newItpi;
    }

    protected abstract void populateItpi(Record var1, ITPIDto var2);

    protected IterationDto populateIterationInCampaignDto(Record r, IterationDto currentIteration) {
        if (this.campaignDto.getIteration((Long)r.get(ITERATION_ID)) == null) {
            this.campaignDto.addIteration(new IterationDto((Long)r.get(ITERATION_ID), (String)r.get(ITERATION_NAME.as("ITERATION_NAME")), (Date)r.get(ITERATION_SCHEDULED_START_DATE), (Date)r.get(ITERATION_SCHEDULED_END_DATE), (Date)r.get(ITERATION_ACTUAL_START_DATE), (Date)r.get(ITERATION_ACTUAL_END_DATE)));
            currentIteration = this.campaignDto.getIteration((Long)r.get(ITERATION_ID));
        }
        return currentIteration;
    }

    protected static void populateIterationMilestoneForCampaignDto(Record r, IterationDto currentIteration) {
        if (r.get((Field)AbstractCampaignExportCSVModel.IT_MILESTONE.LABEL) != null) {
            currentIteration.addMilestone((String)r.get((Field)AbstractCampaignExportCSVModel.IT_MILESTONE.LABEL));
        }
    }

    protected static void addIssueForExecution(Record r, ExecutionDto currentExecution) {
        if (r.get(ITPI_ISSUE) != null) {
            currentExecution.addIssue((Long)r.get(ITPI_ISSUE));
        }
    }
}

