/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.testplan.TestPlanItem;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.audit.AuditModificationService;
import org.squashtest.tm.service.campaign.CreatedTestPlanItems;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.execution.ExecutionDeletionService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.internal.campaign.CampaignNodeDeletionHandler;
import org.squashtest.tm.service.internal.campaign.IterationTestPlanManagerServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.dto.ExecutionSummaryDto;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.TestPlanItemDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeWalker;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service(value="squashtest.tm.service.IterationTestPlanManagerService")
@Transactional
public class IterationTestPlanManagerServiceImpl
implements IterationTestPlanManagerService {
    private static final String LINK_ITERATION_OR_ROLE_ADMIN = "hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')";
    private static final String ITERATION_ID = "iterationId";
    @Inject
    private IterationDao iterationDao;
    @Inject
    private TestPlanItemDao testPlanItemDao;
    @Inject
    private UserDao userDao;
    @Inject
    private CampaignNodeDeletionHandler deletionHandler;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
    private TestCaseLibraryNodeDao testCaseLibraryNodeDao;
    @Inject
    private TestCaseLoader testCaseLoader;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private CustomTestSuiteModificationService customTestSuiteModificationService;
    @Inject
    private AuditModificationService auditModificationService;
    @Inject
    private ExecutionModificationService executionModService;
    @Inject
    private ExecutionDeletionService executionDeletionService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public CreatedTestPlanItems addTestCasesToIteration(List<Long> objectsIds, @Id long iterationId) {
        return this.addTestCasesToIterationUnsecured(objectsIds, iterationId);
    }

    @Override
    public CreatedTestPlanItems addTestCasesToIterationUnsecured(List<Long> objectsIds, @Id long iterationId) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List<TestPlanItem> items = this.addTestPlanItemsToIteration(objectsIds, iteration);
        return new CreatedTestPlanItems(items);
    }

    @Override
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    public void copyTestPlanItems(List<Long> iterationTestPlanIds, @Id long iterationId) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List<TestPlanItem> items = this.findTestPlanItems(iterationTestPlanIds);
        iteration.getTestPlan().copyItems(items);
    }

    @Override
    public List<TestPlanItem> addTestPlanItemsToIteration(List<Long> testNodesIds, Iteration iteration) {
        List<TestCase> testCases = this.getTestCases(testNodesIds);
        List testPlan = iteration.getTestPlan().createAndAddTestPlanItems(testCases);
        this.auditModificationService.updateAuditable((AuditableMixin)iteration);
        return testPlan;
    }

    private List<TestCase> getTestCases(List<Long> testNodesIds) {
        List<TestCase> testCases = this.retrieveAllTestCases(testNodesIds);
        Optional<Milestone> activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        activeMilestone.ifPresent(milestone -> CollectionUtils.filter((Collection)testCases, tc -> ((TestCase)tc).getMilestones().contains(milestone)));
        return testCases;
    }

    private List<TestCase> retrieveAllTestCases(List<Long> nodeIds) {
        Map<Long, List<Long>> nodeIdsByParent = this.testCaseLibraryNodeDao.findContentIdsByNodeIds(nodeIds);
        Set<Long> parents = nodeIdsByParent.keySet();
        List children = nodeIdsByParent.values().stream().flatMap(Collection::stream).filter(id -> !parents.contains(id)).collect(Collectors.toList());
        List<Long> testCaseSources = nodeIds.stream().filter(id -> !parents.contains(id)).toList();
        children.addAll(testCaseSources);
        Object testCases = this.testCaseLoader.load(children, EnumSet.of(TestCaseLoader.Options.FETCH_DATASETS));
        return new TestCaseNodeWalker(nodeIdsByParent, (List<TestCase>)testCases).sort(nodeIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class)
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void changeTestPlanPosition(@Id long iterationId, int newPosition, List<Long> itemIds) {
        Iteration iteration = (Iteration)this.iterationDao.findById(iterationId);
        List<Long> list = itemIds;
        TestPlanItemDao testPlanItemDao = this.testPlanItemDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testPlanItemDao, list);
        Object[] objectArray = new Object[]{this, testPlanItemDao, list, joinPoint};
        IterationTestPlanManagerServiceImpl$AjcClosure1 iterationTestPlanManagerServiceImpl$AjcClosure1 = new IterationTestPlanManagerServiceImpl$AjcClosure1(objectArray);
        List items = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(iterationTestPlanManagerServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        iteration.getTestPlan().moveItems(items, newPosition);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration', 'LINK') or hasRole('ROLE_ADMIN')")
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public boolean removeTestPlansFromIteration(List<Long> testPlanItemsIds, @Id long iterationId) {
        return this.deletionHandler.removeTestPlanItemsFromIteration(testPlanItemsIds, iterationId);
    }

    @Override
    @PreventConcurrent(entityType=Iteration.class, paramName="iterationId")
    @CheckBlockingMilestone(entityType=Iteration.class)
    public void removeExecutionsFromTestPlanItem(List<Long> executionIds, @Id Long iterationId) {
        this.executionDeletionService.deleteExecutions(executionIds);
    }

    @Override
    public Map<Long, List<ExecutionSummaryDto>> getLastExecutionStatuses(Collection<Long> itemId) {
        return this.executionModService.findIterationTestPlanItemLastExecStatuses(itemId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#itemTestPlanId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem', 'READ')  or hasRole('ROLE_ADMIN')")
    public TestPlanItem findTestPlanItem(long itemTestPlanId) {
        return this.testPlanItemDao.findByIdWithTestCase(itemTestPlanId);
    }

    @Override
    public List<TestPlanItem> forceExecutionStatus(List<Long> testPlanIds, String statusName) {
        this.permissionEvaluationService.checkPermission(testPlanIds, Permissions.WRITE.name(), TestPlanItem.class.getName());
        List testPlanItems = this.testPlanItemDao.findAllById(testPlanIds);
        ExecutionStatus status = ExecutionStatus.valueOf((String)statusName);
        String login = UserContextHolder.getUsername();
        User user = this.userDao.findUserByLogin(login);
        HashSet<TestSuite> testSuitesToUpdate = new HashSet<TestSuite>();
        for (TestPlanItem item : testPlanItems) {
            item.applyFastPass(status, user);
            testSuitesToUpdate.addAll(item.getTestSuites());
        }
        this.customTestSuiteModificationService.updateExecutionStatus(testSuitesToUpdate);
        return testPlanItems;
    }

    @Override
    public List<TestPlanItem> findTestPlanItems(List<Long> ids) {
        return this.testPlanItemDao.findAllById(ids);
    }

    static {
        IterationTestPlanManagerServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findAllByIdIn_aroundBody0(IterationTestPlanManagerServiceImpl iterationTestPlanManagerServiceImpl, TestPlanItemDao testPlanItemDao, Collection collection, JoinPoint joinPoint) {
        return testPlanItemDao.findAllByIdIn(collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IterationTestPlanManagerServiceImpl.java", IterationTestPlanManagerServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findAllByIdIn", "org.squashtest.tm.service.internal.repository.TestPlanItemDao", "java.util.Collection", "ids", "", "java.util.List"), 194);
    }
}

