/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementVersionImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.tree.ImportedRequirementNode;
import org.squashtest.tm.service.internal.library.LibraryUtils;

public final class RequirementImportDto {
    private final Requirement root;
    private final List<RequirementVersionImportDto> generatedVersions = new ArrayList<RequirementVersionImportDto>();

    private RequirementImportDto(Requirement root) {
        this.root = root;
    }

    public static RequirementImportDto fromRequirementNode(ImportedRequirementNode requirementNode, Map<RequirementTarget, List<RequirementVersionImportDto>> versionsByRequirementTarget, Project project) {
        List<RequirementVersionImportDto> requirementVersions = versionsByRequirementTarget.getOrDefault(requirementNode.getTarget(), List.of(requirementNode.toRequirementVersionImportDto(project)));
        RequirementImportDto root = RequirementImportDto.initializeRoot(requirementVersions, project);
        if (requirementNode.getTarget().isSynchronized()) {
            root.getRequirement().setMode(ManagementMode.SYNCHRONIZED);
        }
        RequirementImportDto.addChildren(requirementNode, versionsByRequirementTarget, root, root.getRequirement());
        return root;
    }

    private static RequirementImportDto initializeRoot(List<RequirementVersionImportDto> versions, Project project) {
        if (versions == null || versions.isEmpty()) {
            throw new IllegalArgumentException("versions cannot be null or empty");
        }
        RequirementVersionImportDto currentVersionDto = versions.getFirst();
        RequirementVersion currentVersion = currentVersionDto.requirementVersion();
        currentVersion.updateStatusWithoutCheck(currentVersionDto.finalStatus());
        HighLevelRequirement createdRequirement = currentVersionDto.isHighLevelRequirement() ? new HighLevelRequirement(currentVersion) : new Requirement(currentVersion);
        createdRequirement.notifyAssociatedWithProject(project);
        RequirementImportDto root = new RequirementImportDto((Requirement)createdRequirement);
        root.addGeneratedVersion(currentVersionDto);
        RequirementImportDto.createRequirementVersions(root, versions, (Requirement)createdRequirement);
        return root;
    }

    private static void createRequirementVersions(RequirementImportDto root, List<RequirementVersionImportDto> versions, Requirement createdRequirement) {
        versions.stream().skip(1L).forEach(versionDto -> {
            RequirementVersion version = versionDto.requirementVersion();
            createdRequirement.addExistingRequirementVersion(version);
            version.updateStatusWithoutCheck(versionDto.finalStatus());
            root.addGeneratedVersion((RequirementVersionImportDto)versionDto);
        });
    }

    private static void addChild(ImportedRequirementNode current, Requirement parent, List<String> parentContentNames, Map<RequirementTarget, List<RequirementVersionImportDto>> versionsByRequirementTarget, RequirementImportDto root) {
        List<RequirementVersionImportDto> versions = versionsByRequirementTarget.getOrDefault(current.getTarget(), List.of(current.toRequirementVersionImportDto(parent.getProject())));
        Requirement subRequirement = RequirementImportDto.createRequirement(versions, root);
        LibraryUtils.fixConflictNames(parentContentNames, (LibraryNode)subRequirement);
        parent.addContent(subRequirement);
        RequirementImportDto.addChildren(current, versionsByRequirementTarget, root, subRequirement);
    }

    private static void addChildren(ImportedRequirementNode current, Map<RequirementTarget, List<RequirementVersionImportDto>> versionsByRequirementTarget, RequirementImportDto root, Requirement currentRequirement) {
        if (current.getContents().isEmpty()) {
            return;
        }
        ArrayList<String> contentNames = new ArrayList<String>(currentRequirement.getContentNames());
        for (ImportedRequirementNode child : current.getContents()) {
            if (!child.isImportable()) continue;
            RequirementImportDto.addChild(child, currentRequirement, contentNames, versionsByRequirementTarget, root);
        }
    }

    private static Requirement createRequirement(List<RequirementVersionImportDto> versions, RequirementImportDto root) {
        if (versions == null || versions.isEmpty()) {
            throw new IllegalArgumentException("versions cannot be null or empty");
        }
        RequirementVersionImportDto currentVersionDto = versions.getFirst();
        RequirementVersion currentVersion = currentVersionDto.requirementVersion();
        currentVersion.updateStatusWithoutCheck(currentVersionDto.finalStatus());
        Requirement createdRequirement = new Requirement(currentVersion);
        root.addGeneratedVersion(currentVersionDto);
        RequirementImportDto.createRequirementVersions(root, versions, createdRequirement);
        return createdRequirement;
    }

    public Requirement getRequirement() {
        return this.root;
    }

    public List<RequirementVersionImportDto> getGeneratedVersions() {
        return this.generatedVersions;
    }

    private void addGeneratedVersion(RequirementVersionImportDto versionDto) {
        this.generatedVersions.add(versionDto);
    }
}

