/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementLibraryNodeVisitor;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.infolist.InfoListItemFinderService;
import org.squashtest.tm.service.internal.batchimport.AbstractEntityFacilitySupport;
import org.squashtest.tm.service.internal.batchimport.Batch;
import org.squashtest.tm.service.internal.batchimport.Batches;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.FacilityImplHelper;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.ValidationFacility;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageInstruction;
import org.squashtest.tm.service.internal.batchimport.column.testcase.CoverageTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.LinkedLowLevelRequirementInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementLinkInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.LinkedLowLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementLinkTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.RequirementImportService;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.CoverageImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.ExistLinkImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.LinkImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementFolderImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementVersionImportDto;
import org.squashtest.tm.service.internal.batchimport.requirement.tree.ImportedRequirementNode;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateRequirementLibraryNodeDao;
import org.squashtest.tm.service.requirement.HighLevelRequirementConversionService;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;

@Component
@Scope(value="prototype")
public class RequirementFacility
extends AbstractEntityFacilitySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FacilityImpl.class);
    private final HibernateRequirementLibraryNodeDao rlnDao;
    private final InfoListItemFinderService listItemFinderService;
    private final RequirementVersionManagerService requirementVersionManagerService;
    private final RequirementLibraryNavigationService reqLibNavigationService;
    private final LinkedRequirementVersionManagerService reqlinkService;
    private final HighLevelRequirementConversionService highLevelRequirementConversionService;
    private final RequirementImportService requirementImportService;
    private final FacilityImplHelper helper = new FacilityImplHelper(this);

    RequirementFacility(HibernateRequirementLibraryNodeDao rlnDao, InfoListItemFinderService listItemFinderService, RequirementVersionManagerService requirementVersionManagerService, RequirementLibraryNavigationService reqLibNavigationService, LinkedRequirementVersionManagerService reqlinkService, HighLevelRequirementConversionService highLevelRequirementConversionService, RequirementImportService requirementImportService) {
        this.rlnDao = rlnDao;
        this.listItemFinderService = listItemFinderService;
        this.requirementVersionManagerService = requirementVersionManagerService;
        this.reqLibNavigationService = reqLibNavigationService;
        this.reqlinkService = reqlinkService;
        this.highLevelRequirementConversionService = highLevelRequirementConversionService;
        this.requirementImportService = requirementImportService;
    }

    public void createRequirementVersions(List<RequirementVersionInstruction> requirementsCreation, List<RequirementVersionInstruction> versionsAddition, Project project) {
        this.createRequirements(requirementsCreation, project);
        this.addNewVersions(versionsAddition, project);
    }

    private void addNewVersions(List<RequirementVersionInstruction> instructions, Project project) {
        if (instructions.isEmpty()) {
            return;
        }
        Batches<RequirementVersionImportDto> batches = new Batches<RequirementVersionImportDto>();
        for (RequirementVersionInstruction requirementVersionInstruction : instructions) {
            Long reqId = this.model.getRequirementId((RequirementVersionTarget)requirementVersionInstruction.getTarget());
            batches.addBatch(reqId, this.asRequirementVersionDto(requirementVersionInstruction));
        }
        for (List list : batches.partition(30)) {
            List<Long> requirementIds = list.stream().map(Batch::getTargetId).toList();
            this.requirementImportService.addVersions(requirementIds, project, list);
        }
        instructions.forEach(this::validatingRequirementVersionCreation);
    }

    private void createRequirements(List<RequirementVersionInstruction> instructions, Project project) {
        if (instructions.isEmpty()) {
            return;
        }
        Map<ImportedRequirementNode, Set<ImportedRequirementNode>> missingNodes = this.model.getMissingNodes();
        if (missingNodes.isEmpty()) {
            return;
        }
        Map<RequirementTarget, List<RequirementVersionImportDto>> requirementTargetVersions = instructions.stream().collect(Collectors.groupingBy(i -> ((RequirementVersionTarget)i.getTarget()).getRequirement(), Collectors.mapping(this::asRequirementVersionDto, Collectors.collectingAndThen(Collectors.toList(), list -> {
            list.sort(Comparator.comparing(RequirementVersionImportDto::getVersion));
            this.filterMilestones((List<RequirementVersionImportDto>)list);
            return list;
        }))));
        this.createRequirements(missingNodes, requirementTargetVersions, project);
        this.createFolders(missingNodes, requirementTargetVersions, project);
        instructions.forEach(this::validatingRequirementVersionCreation);
    }

    private void validatingRequirementVersionCreation(RequirementVersionInstruction instruction) {
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        RequirementVersion version = instruction.getRequirementVersion();
        RequirementTarget requirementTarget = target.getRequirement();
        if (requirementTarget.getId() == null) {
            this.model.setExists(requirementTarget, version.getRequirement().getId());
        }
        this.model.setExists(target, version.getId());
    }

    private void filterMilestones(List<RequirementVersionImportDto> list) {
        HashSet<Long> milestoneIds = new HashSet<Long>();
        for (RequirementVersionImportDto dto : list) {
            Iterator<Long> iterator = dto.milestoneIds().iterator();
            while (iterator.hasNext()) {
                Long milestone = iterator.next();
                if (milestoneIds.contains(milestone)) {
                    iterator.remove();
                    continue;
                }
                milestoneIds.add(milestone);
            }
        }
    }

    private void createFolders(Map<ImportedRequirementNode, Set<ImportedRequirementNode>> missingNodes, Map<RequirementTarget, List<RequirementVersionImportDto>> versionDtoByRequirementTarget, Project project) {
        Batch<RequirementFolderImportDto> libraryChild = new Batch<RequirementFolderImportDto>(project.getRequirementLibrary().getId());
        Batches<RequirementFolderImportDto> folderChild = new Batches<RequirementFolderImportDto>();
        missingNodes.forEach((parentNode, childrenNode) -> {
            for (ImportedRequirementNode node : childrenNode) {
                if (node.isInstanceOfRequirement()) continue;
                RequirementFolderImportDto folderDto = RequirementFolderImportDto.fromRequirementNode(node, versionDtoByRequirementTarget, project);
                Long parentId = parentNode.getId();
                if (parentNode.isLibrary()) {
                    libraryChild.addEntity(folderDto);
                    continue;
                }
                if (!parentNode.isRequirementFolder()) continue;
                folderChild.addBatch(parentId, folderDto);
            }
        });
        this.createLibraryFolders(libraryChild, project);
        this.createSubFolders(folderChild, project);
    }

    private void createSubFolders(Batches<RequirementFolderImportDto> batches, Project project) {
        if (batches.isEmpty()) {
            return;
        }
        this.fixBatchFoldersConflictNames(batches);
        for (List<Batch<RequirementFolderImportDto>> batchList : batches.partition(30)) {
            List<Long> folderIds = batchList.stream().map(Batch::getTargetId).toList();
            this.requirementImportService.addFoldersToFolders(folderIds, project, batchList);
        }
    }

    private void createLibraryFolders(Batch<RequirementFolderImportDto> batch, Project project) {
        if (batch.isEmpty()) {
            return;
        }
        List<RequirementFolderImportDto> folderDtoList = batch.getEntities();
        Long libraryId = batch.getTargetId();
        List<String> contentNames = this.reqLibNavigationService.findContentNamesByLibraryId(libraryId);
        RequirementFacility.fixFolderConflictNames(contentNames, folderDtoList);
        this.requirementImportService.addFoldersToLibrary(libraryId, project, batch.getEntities());
    }

    private void createRequirements(Map<ImportedRequirementNode, Set<ImportedRequirementNode>> missingNodes, Map<RequirementTarget, List<RequirementVersionImportDto>> requirementTargetVersions, Project project) {
        Batch<RequirementImportDto> libraryChild = new Batch<RequirementImportDto>(project.getRequirementLibrary().getId());
        Batches<RequirementImportDto> folderChild = new Batches<RequirementImportDto>();
        Batches<RequirementImportDto> requirementChild = new Batches<RequirementImportDto>();
        missingNodes.forEach((parentNode, childrenNode) -> {
            for (ImportedRequirementNode node : childrenNode) {
                if (!node.isInstanceOfRequirement() || !node.isImportable()) continue;
                RequirementImportDto requirementDto = RequirementImportDto.fromRequirementNode(node, requirementTargetVersions, project);
                Long parentId = parentNode.getId();
                if (parentNode.isLibrary()) {
                    libraryChild.addEntity(requirementDto);
                    continue;
                }
                if (parentNode.isRequirementFolder()) {
                    folderChild.addBatch(parentId, requirementDto);
                    continue;
                }
                if (!parentNode.isInstanceOfRequirement()) continue;
                requirementChild.addBatch(parentId, requirementDto);
            }
        });
        this.createLibraryRequirements(project, libraryChild);
        this.createFolderRequirements(project, folderChild);
        this.createSubRequirements(project, requirementChild);
    }

    private void createSubRequirements(Project project, Batches<RequirementImportDto> batches) {
        if (batches.isEmpty()) {
            return;
        }
        this.fixBatchConflictNames(batches);
        for (List<Batch<RequirementImportDto>> batchList : batches.partition(30)) {
            List<Long> requirementIds = batchList.stream().map(Batch::getTargetId).toList();
            this.requirementImportService.addRequirementsToRequirements(requirementIds, project, batchList);
        }
    }

    private void createFolderRequirements(Project project, Batches<RequirementImportDto> batches) {
        if (batches.isEmpty()) {
            return;
        }
        this.fixBatchConflictNames(batches);
        for (List<Batch<RequirementImportDto>> batchList : batches.partition(30)) {
            List<Long> folderIds = batchList.stream().map(Batch::getTargetId).toList();
            this.requirementImportService.addRequirementsToFolders(folderIds, project, batchList);
        }
    }

    private void createLibraryRequirements(Project project, Batch<RequirementImportDto> batch) {
        if (batch.isEmpty()) {
            return;
        }
        List<RequirementImportDto> requirementDtoList = batch.getEntities();
        Long libraryId = batch.getTargetId();
        List<String> contentNames = this.reqLibNavigationService.findContentNamesByLibraryId(libraryId);
        RequirementFacility.fixConflictNames(contentNames, requirementDtoList);
        this.requirementImportService.addRequirementsToLibrary(libraryId, project, batch.getEntities());
    }

    private void fixBatchConflictNames(Batches<RequirementImportDto> batches) {
        Map<Long, List<String>> folderContentNames = this.reqLibNavigationService.findContentNamesByNodeIds(batches.getTargetIds());
        folderContentNames.forEach((folderId, contentNames) -> {
            List<RequirementImportDto> importDtoList = batches.getEntitiesByTargetId((Long)folderId);
            RequirementFacility.fixConflictNames(contentNames, importDtoList);
        });
    }

    private static void fixConflictNames(Collection<String> contentNames, List<RequirementImportDto> requirementsDto) {
        if (requirementsDto == null || requirementsDto.isEmpty()) {
            return;
        }
        requirementsDto.forEach(dto -> LibraryUtils.fixConflictNames(contentNames, (LibraryNode)dto.getRequirement()));
    }

    private void fixBatchFoldersConflictNames(Batches<RequirementFolderImportDto> batches) {
        Map<Long, List<String>> folderContentNames = this.reqLibNavigationService.findContentNamesByNodeIds(batches.getTargetIds());
        folderContentNames.forEach((folderId, contentNames) -> {
            List<RequirementFolderImportDto> foldersDto = batches.getEntitiesByTargetId((Long)folderId);
            RequirementFacility.fixFolderConflictNames(contentNames, foldersDto);
        });
    }

    private static void fixFolderConflictNames(Collection<String> contentNames, List<RequirementFolderImportDto> foldersDto) {
        if (foldersDto == null || foldersDto.isEmpty()) {
            return;
        }
        foldersDto.forEach(dto -> LibraryUtils.fixConflictNames(contentNames, (LibraryNode)dto.getFolder()));
    }

    private RequirementVersionImportDto asRequirementVersionDto(RequirementVersionInstruction instruction) {
        RequirementVersion requirementVersion = instruction.getRequirementVersion();
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        requirementVersion.setVersionNumber(target.getVersion().intValue());
        Map<String, String> cufValues = instruction.getCustomFields();
        this.helper.fillNullWithDefaults(requirementVersion);
        this.helper.truncate(requirementVersion, cufValues);
        Map<Long, RawValue> acceptableCufs = this.toAcceptableCufs(instruction.getCustomFields());
        List<Long> milestoneIds = this.boundMilestonesIds(instruction);
        return new RequirementVersionImportDto(requirementVersion, acceptableCufs, milestoneIds, target.getRequirement().isHighLevel(), target.getRequirement().isSynchronized(), target.getImportedRequirementStatus());
    }

    private void bindRequirementVersionToMilestones(RequirementVersion requirementVersionPersisted, List<Long> boundMilestonesIds) {
        List allVersion = requirementVersionPersisted.getRequirement().getRequirementVersions();
        HashSet milestoneBinded = new HashSet();
        HashSet<Long> milestoneBindedId = new HashSet<Long>();
        HashSet<Long> checkedMilestones = new HashSet<Long>();
        for (RequirementVersion requirementVersion : allVersion) {
            milestoneBinded.addAll(requirementVersion.getMilestones());
        }
        for (Milestone milestone : milestoneBinded) {
            milestoneBindedId.add(milestone.getId());
        }
        for (Long id : boundMilestonesIds) {
            if (milestoneBindedId.contains(id)) continue;
            checkedMilestones.add(id);
        }
        if (!checkedMilestones.isEmpty()) {
            requirementVersionPersisted.getMilestones().clear();
            this.requirementVersionManagerService.bindMilestones(requirementVersionPersisted.getId(), checkedMilestones);
        }
    }

    private void doUpdateRequirementCoreAttributes(RequirementVersion reqVersion, RequirementVersion orig, boolean isForSynchronisation) {
        this.doUpdateRequirementReference(reqVersion, orig, isForSynchronisation);
        this.doUpdateRequirementDescription(reqVersion, orig, isForSynchronisation);
        this.doUpdateRequirementCriticality(reqVersion, orig, isForSynchronisation);
        this.doUpdateRequirementCategory(reqVersion, orig, isForSynchronisation);
    }

    private void doUpdateStatus(RequirementStatus newStatus, RequirementVersion orig, boolean isForSynchronisation) {
        if (newStatus == null || newStatus == orig.getStatus()) {
            return;
        }
        if (isForSynchronisation || orig.getStatus().isRequirementModifiable()) {
            orig.updateStatusWithoutCheck(newStatus);
        }
    }

    private void doUpdateRequirementReference(RequirementVersion reqVersion, RequirementVersion orig, boolean isForSynchronisation) {
        String newReference = reqVersion.getReference();
        if (!StringUtils.isBlank((CharSequence)newReference) && !newReference.equals(orig.getReference())) {
            if (isForSynchronisation) {
                this.requirementVersionManagerService.changeReferenceForSynchronisation(orig.getId(), newReference);
            } else {
                this.requirementVersionManagerService.changeReference(orig.getId(), newReference);
            }
        }
    }

    private void doUpdateRequirementDescription(RequirementVersion reqVersion, RequirementVersion orig, boolean isForSynchronisation) {
        String newDescription = reqVersion.getDescription();
        if (!StringUtils.isBlank((CharSequence)newDescription) && !newDescription.equals(orig.getDescription())) {
            if (isForSynchronisation) {
                this.requirementVersionManagerService.changeDescriptionForSynchronisation(orig.getId(), newDescription);
            } else {
                this.requirementVersionManagerService.changeDescription(orig.getId(), newDescription);
            }
        }
    }

    private void doUpdateRequirementCriticality(RequirementVersion reqVersion, RequirementVersion orig, boolean isForSynchronisation) {
        RequirementCriticality newCriticality = reqVersion.getCriticality();
        if (newCriticality != null && newCriticality != orig.getCriticality()) {
            if (isForSynchronisation) {
                this.requirementVersionManagerService.changeCriticalityForSynchronisation(orig.getId(), newCriticality);
            } else {
                this.requirementVersionManagerService.changeCriticality(orig.getId(), newCriticality);
            }
        }
    }

    private void doUpdateRequirementCategory(RequirementVersion reqVersion, RequirementVersion orig, boolean isForSynchronisation) {
        Long idOrig = orig.getId();
        InfoListItem oldCategory = orig.getCategory();
        InfoListItem newCategory = reqVersion.getCategory();
        if (newCategory != null && !oldCategory.references((Object)newCategory)) {
            if (isForSynchronisation) {
                this.requirementVersionManagerService.changeCategoryForSynchronisation(idOrig, newCategory.getCode());
            } else {
                this.requirementVersionManagerService.changeCategory((long)idOrig, newCategory.getCode());
            }
        }
    }

    private void doUpdateRequirementModificationMetadata(AuditableMixin requirementVersion, AuditableMixin persistedVersion) {
        persistedVersion.setLastModifiedBy(requirementVersion.getCreatedBy());
        persistedVersion.setLastModifiedOn(requirementVersion.getCreatedOn());
    }

    public void updateRequirementVersions(List<RequirementVersionInstruction> instructions, Project project) {
        LOGGER.info("Updating Requirement Versions on project '{}'", new Object[]{project.getName()});
        instructions.forEach(this::updateRequirementVersionRoutine);
    }

    private void updateRequirementVersionRoutine(RequirementVersionInstruction instruction) {
        RequirementVersion reqVersion = instruction.getRequirementVersion();
        Map<String, String> cufValues = instruction.getCustomFields();
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        this.updateRequirementVersionRoutine(instruction, target, reqVersion, cufValues, target.getRequirement().isSynchronized());
    }

    private void updateRequirementVersionRoutine(RequirementVersionInstruction instruction, RequirementVersionTarget target, RequirementVersion reqVersion, Map<String, String> cufValues, boolean isForSynchronisation) {
        this.helper.fillNullWithDefaults(reqVersion);
        if (isForSynchronisation) {
            this.helper.truncateWithoutCheckingStatus(reqVersion, cufValues);
            this.fixCategoryWithoutCheckingStatus(target, reqVersion);
            this.finalizeRequirementVersionRoutine(instruction, target, cufValues, isForSynchronisation);
        } else if (target.getImportedRequirementStatus().isRequirementModifiable() || !target.getImportedRequirementStatus().isRequirementModifiable() && reqVersion.getStatus().isRequirementModifiable()) {
            this.helper.truncate(reqVersion, cufValues);
            this.fixCategory(target, reqVersion);
            this.finalizeRequirementVersionRoutine(instruction, target, cufValues, isForSynchronisation);
        } else {
            Requirement req = this.reqLibNavigationService.findRequirement(target.getRequirement().getId());
            this.doUpdateRequirementNature(req, target.getRequirement());
            instruction.setRequirementVersion(req.findRequirementVersion(target.getVersion().intValue()));
        }
    }

    private void finalizeRequirementVersionRoutine(RequirementVersionInstruction instruction, RequirementVersionTarget target, Map<String, String> cufValues, boolean isForSynchronisation) {
        RequirementVersion newVersion = this.doUpdateRequirementVersion(instruction, cufValues, isForSynchronisation);
        instruction.setRequirementVersion(newVersion);
        this.model.bindMilestonesToRequirementVersion(target, (List<String>)instruction.getMilestones());
        LOGGER.debug("Excel import : Updated Requirement Version \t'" + String.valueOf(target) + "'", new Object[0]);
    }

    public LogTrain deleteRequirementLink(RequirementLinkInstruction instr) {
        LogTrain train = this.validator.deleteRequirementLink(instr);
        if (!train.hasCriticalErrors()) {
            long sourceId = this.findVersionIdByTarget(((RequirementLinkTarget)instr.getTarget()).getSourceVersion());
            long destId = this.findVersionIdByTarget(((RequirementLinkTarget)instr.getTarget()).getDestVersion());
            this.reqlinkService.removeLinkedRequirementVersionsFromRequirementVersion(sourceId, List.of(Long.valueOf(destId)));
        }
        return train;
    }

    private long findVersionIdByTarget(RequirementVersionTarget versTarget) {
        Long reqId = this.model.getRequirementId(versTarget);
        return this.requirementVersionManagerService.findReqVersionIdByRequirementAndVersionNumber(reqId, versTarget.getVersion());
    }

    private void fixCategory(RequirementVersionTarget target, RequirementVersion requirementVersion) {
        this.fixCategory(target, requirementVersion, true);
    }

    private void fixCategoryWithoutCheckingStatus(RequirementVersionTarget target, RequirementVersion requirementVersion) {
        this.fixCategory(target, requirementVersion, false);
    }

    private void fixCategory(RequirementVersionTarget target, RequirementVersion requirementVersion, boolean shouldCheckStatus) {
        ProjectTargetStatus projectStatus = this.model.getProjectStatus(target.getProject());
        InfoListItem category = requirementVersion.getCategory();
        if (category == null || !this.listItemFinderService.isCategoryConsistent(projectStatus.getId(), category.getCode())) {
            InfoListItem defaultRequirementCategory = this.listItemFinderService.findDefaultRequirementCategory(projectStatus.getId());
            if (shouldCheckStatus) {
                requirementVersion.setCategory(defaultRequirementCategory);
            } else {
                requirementVersion.updateCategoryWithoutCheckingStatus(defaultRequirementCategory);
            }
        }
    }

    private RequirementVersion doUpdateRequirementVersion(RequirementVersionInstruction instruction, Map<String, String> cufValues, boolean isForSynchronisation) {
        RequirementVersionTarget target = (RequirementVersionTarget)instruction.getTarget();
        RequirementVersion reqVersion = instruction.getRequirementVersion();
        Requirement req = this.reqLibNavigationService.findRequirement(target.getRequirement().getId());
        RequirementVersion orig = req.findRequirementVersion(target.getVersion().intValue());
        this.doUpdateRequirementCoreAttributes(reqVersion, orig, isForSynchronisation);
        if (CollectionUtils.isEmpty((Collection)instruction.getMilestones())) {
            orig.getMilestones().clear();
        } else {
            this.updateRequirementVersionToMilestones(target.isRejectedMilestone(), orig, this.boundMilestonesIds(instruction));
        }
        this.doUpdateCustomFields(cufValues, (BoundEntity)orig);
        this.doUpdateRequirementModificationMetadata((AuditableMixin)reqVersion, (AuditableMixin)orig);
        this.moveRequirement(target.getRequirement(), req);
        this.doUpdateRequirementNature(req, target.getRequirement());
        if (isForSynchronisation || orig.getStatus().isRequirementModifiable()) {
            this.doUpdateStatus(target.getImportedRequirementStatus(), orig, isForSynchronisation);
            this.renameRequirementVersion(((RequirementVersionTarget)instruction.getTarget()).getUnconsistentName(), orig, reqVersion);
        }
        return orig;
    }

    private void renameRequirementVersion(String unconsistentName, RequirementVersion orig, RequirementVersion reqVersion) {
        if (unconsistentName != null && !unconsistentName.isBlank()) {
            String newName = PathUtils.unescapePathPartSlashes((String)unconsistentName);
            orig.setName(newName);
        } else if (!orig.getName().equals(reqVersion.getName())) {
            orig.setName(reqVersion.getName());
        }
    }

    private void updateRequirementVersionToMilestones(boolean corruptedMilestones, RequirementVersion requirementVersionPersisted, List<Long> boundMilestonesIds) {
        if (!corruptedMilestones) {
            this.bindRequirementVersionToMilestones(requirementVersionPersisted, boundMilestonesIds);
        }
    }

    private void moveRequirement(RequirementTarget target, Requirement req) {
        final Integer newPosition = target.getOrder();
        if (newPosition == null || newPosition <= 0) {
            return;
        }
        final Long[] sourceIds = new Long[]{req.getId()};
        final ClipboardPayload clipboardPayload = ClipboardPayload.withWhiteListIgnored(Collections.singletonList(req.getId()));
        if (target.isRootRequirement()) {
            this.reqLibNavigationService.moveNodesToLibrary(req.getLibrary().getId(), sourceIds, newPosition, clipboardPayload);
        } else {
            List<Long> ids = this.rlnDao.getParentsIds(req.getId());
            Long firstParentId = ids.get(ids.size() - 2);
            RequirementLibraryNode parent = this.reqLibNavigationService.findRequirementLibraryNodeById(firstParentId);
            final Long parentId = parent.getId();
            parent.accept(new RequirementLibraryNodeVisitor(){

                public void visit(Requirement requirement) {
                    RequirementFacility.this.reqLibNavigationService.moveNodesToRequirement(parentId, sourceIds, newPosition, clipboardPayload);
                }

                public void visit(RequirementFolder folder) {
                    RequirementFacility.this.reqLibNavigationService.moveNodesToFolder(parentId, sourceIds, newPosition, clipboardPayload);
                }
            });
        }
    }

    private void doUpdateRequirementNature(Requirement req, RequirementTarget target) {
        if (!req.isHighLevel() && target.isHighLevel()) {
            this.highLevelRequirementConversionService.convertIntoHighLevelRequirement(req.getId());
        } else if (req.isHighLevel() && !target.isHighLevel()) {
            this.highLevelRequirementConversionService.convertIntoStandardRequirement(req.getId());
        }
    }

    public LogTrain deleteRequirementVersion(RequirementVersionInstruction instr) {
        throw new NotImplementedException("implement me - must return a Failure : Not implemented in the log train instead of throwing this exception");
    }

    public void setValidator(ValidationFacility validationFacility) {
        this.validator = validationFacility;
    }

    public void createCoverages(List<CoverageInstruction> instructions) {
        Batches batches = new Batches();
        instructions.stream().collect(Collectors.toMap(i -> List.of(i.getTestCaseId(), i.getRequirementId()), i -> i, (i1, i2) -> ((CoverageTarget)i1.getTarget()).getReqVersion() > ((CoverageTarget)i2.getTarget()).getReqVersion() ? i1 : i2)).values().forEach(instruction -> {
            Long versionId = this.model.getRequirementVersionId(((CoverageTarget)instruction.getTarget()).getRequirementVersion());
            Long testCaseId = this.model.getTestCaseId(((CoverageTarget)instruction.getTarget()).getTestCase());
            CoverageImportDto dto = new CoverageImportDto(versionId, instruction.getCoverage(), instruction.getExistingCoverageId());
            batches.addBatch(testCaseId, dto);
        });
        for (List<Batch<CoverageImportDto>> list : batches.partition(10)) {
            List<Long> testCaseIds = list.stream().map(Batch::getTargetId).toList();
            this.requirementImportService.createCoverages(testCaseIds, list);
        }
    }

    public void createOrUpdateLinks(List<RequirementLinkInstruction> instructions) {
        Batches<LinkImportDto> createInstructions = new Batches<LinkImportDto>();
        ArrayList<ExistLinkImportDto> updateInstructions = new ArrayList<ExistLinkImportDto>();
        for (RequirementLinkInstruction requirementLinkInstruction : instructions) {
            RequirementLinkTarget target = (RequirementLinkTarget)requirementLinkInstruction.getTarget();
            if (requirementLinkInstruction.linkExists()) {
                ExistLinkImportDto dto = new ExistLinkImportDto(target.getExistingOutboundLinkId(), target.getExistingInboundLinkId(), requirementLinkInstruction.getRelationRole());
                updateInstructions.add(dto);
                continue;
            }
            Long sourceId = target.getSourceVersion().getId();
            LinkImportDto dto = new LinkImportDto(sourceId, target.getDestVersion().getId(), requirementLinkInstruction.getRelationRole());
            createInstructions.addBatch(sourceId, dto);
        }
        for (List list : createInstructions.partition(10)) {
            this.requirementImportService.createLinks(list);
        }
        for (List list : Lists.partition(updateInstructions, (int)10)) {
            this.requirementImportService.updateLinks(list);
        }
    }

    public void createOrUpdateLinkedLowLevelRequirements(List<LinkedLowLevelRequirementInstruction> instructions) {
        Batches<Long> batches = new Batches<Long>();
        for (LinkedLowLevelRequirementInstruction linkedLowLevelRequirementInstruction : instructions) {
            LinkedLowLevelRequirementTarget target = (LinkedLowLevelRequirementTarget)linkedLowLevelRequirementInstruction.getTarget();
            Long highLevelReqId = target.getHighLevelRequirementTarget().getId();
            Long standardReqId = target.getStandardRequirementTarget().getId();
            batches.addBatch(highLevelReqId, standardReqId);
        }
        for (List list : batches.partition(10)) {
            List<Long> highLevelReqIds = list.stream().map(Batch::getTargetId).toList();
            this.requirementImportService.linkToHighLevelRequirements(highLevelReqIds, list);
        }
    }
}

