/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTagHolder;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomationEnvironmentTag;
import org.squashtest.tm.service.internal.repository.CustomGenericProjectDao;

public class GenericProjectDaoImpl
implements CustomGenericProjectDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dslContext;

    @Override
    public ProjectTemplate coerceProjectIntoTemplate(long projectId) {
        int changedRows = this.em.createNativeQuery("update PROJECT set PROJECT_TYPE = 'T',  TEMPLATE_ID = null where PROJECT_ID = :id").setParameter("id", (Object)projectId).executeUpdate();
        if (changedRows != 1) {
            throw new PersistenceException("Expected 1 changed row but got " + changedRows + " instead");
        }
        this.em.clear();
        return (ProjectTemplate)this.em.find(ProjectTemplate.class, (Object)projectId);
    }

    @Override
    public boolean isProjectTemplate(long projectId) {
        Query query = this.em.createNamedQuery("GenericProject.findProjectTypeOf");
        query.setParameter("projectId", (Object)projectId);
        Class type = (Class)query.getSingleResult();
        return type.equals(ProjectTemplate.class);
    }

    @Override
    public boolean isBoundToATemplate(long genericProjectId) {
        TypedQuery query = this.em.createNamedQuery("GenericProject.findBoundTemplateId", Long.class);
        query.setParameter("projectId", (Object)genericProjectId);
        List templateIdss = query.getResultList();
        return !templateIdss.isEmpty();
    }

    @Override
    public boolean oneIsBoundToABoundProject(Collection<Long> bindingIds) {
        TypedQuery query = this.em.createNamedQuery("GenericProject.findBoundTemplateIdsFromBindingIds", Long.class);
        query.setParameter("bindingIds", bindingIds);
        List templateIds = query.getResultList();
        return !templateIds.isEmpty();
    }

    @Override
    public GenericProject getProjectWithBugtrackerProjects(long projectId) {
        return (GenericProject)this.em.createQuery("select p from GenericProject p left join fetch p.bugtrackerProjects bp where p.id = :projectId group by p, bp, bp.project", GenericProject.class).setParameter("projectId", (Object)projectId).getSingleResult();
    }

    @Override
    public List<String> getEnvironmentTags(long genericProjectId) {
        return this.dslContext.select((SelectField)AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.VALUE).from((TableLike)AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG).where(AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.ENTITY_TYPE.eq((Object)AutomationEnvironmentTagHolder.PROJECT.name()).and(AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.ENTITY_ID.eq((Object)genericProjectId))).fetchInto(String.class);
    }

    @Override
    public boolean isInheritsEnvironmentTags(long genericProjectId) {
        return this.dslContext.select((SelectField)Tables.PROJECT.INHERITS_ENVIRONMENT_TAGS).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)genericProjectId)).fetchOptional().map(inheritsEnvironmentTags -> (Boolean)inheritsEnvironmentTags.into(Boolean.class)).orElse(false);
    }
}

