/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class SprintCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    private static final String IS_SYNCHRONIZED = "IS_SYNCHRONIZED";
    private static final String HAS_OUT_OF_PERIMETER_OR_DELETED_REMOTE_REQ = "HAS_OUT_OF_PERIMETER_OR_DELETED_REMOTE_REQ";
    private static final String IS_DELETED_SPRINT = "IS_DELETED_SPRINT";

    public SprintCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.SPRINT;
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> sprints = this.collectSprints(ids);
        this.appendHasOutOfPerimeterOrDeletedRemoteReq(sprints);
        return sprints;
    }

    private Map<Long, DataRow> collectSprints(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.NAME.as("NAME"), (SelectField)Tables.SPRINT.REFERENCE, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)DSL.field((Condition)Tables.SPRINT.REMOTE_SYNCHRONISATION_ID.isNotNull()).as(IS_SYNCHRONIZED), (SelectField)Tables.REMOTE_SYNCHRONISATION.LAST_SYNC_STATUS, (SelectField)Tables.SPRINT.REMOTE_SYNCHRONISATION_ID, (SelectField)Tables.SPRINT.STATUS, (SelectField)Tables.SPRINT.REMOTE_STATE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).innerJoin((TableLike)Tables.SPRINT).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT.CLN_ID)).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.SPRINT.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.in(ids)).groupBy(new GroupField[]{Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.NAME, Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID, Tables.SPRINT.CLN_ID, Tables.REMOTE_SYNCHRONISATION.LAST_SYNC_STATUS, Tables.SPRINT.REMOTE_SYNCHRONISATION_ID, Tables.SPRINT.REFERENCE}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.SPRINT, (Long)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState(DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            if (!Strings.isNullOrEmpty((String)((String)tuple.get((Field)Tables.SPRINT.REFERENCE, String.class)))) {
                dataRow.getData().replace("NAME", (String)tuple.get((Field)Tables.SPRINT.REFERENCE) + " - " + (String)tuple.get((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME));
            }
            return dataRow;
        }));
    }

    private void appendHasOutOfPerimeterOrDeletedRemoteReq(Map<Long, DataRow> sprints) {
        sprints.forEach((aLong, dataRow) -> {
            long sprintId;
            boolean hasOutOfPerimeterOrDeletedRemoteReq = false;
            boolean sprintIsDeleted = false;
            boolean sprintIsSynchronized = (Boolean)dataRow.getData().get(IS_SYNCHRONIZED);
            if (sprintIsSynchronized && !(sprintIsDeleted = this.checkIfSprintIsDeleted(sprintId = Long.parseLong(dataRow.getId().replace(NodeType.SPRINT.getTypeName() + "-", ""))))) {
                List<Long> folderAndSubFolders = this.findSynchronizedFolderAndSubFolders(sprintId);
                List<Long> sprintReqVersionInFoldersAndSubFolders = this.findSynchronizedSprintReqVersionsInsideFolders(folderAndSubFolders);
                hasOutOfPerimeterOrDeletedRemoteReq = this.checkIfSprintsHaveOutOfPerimeterOrDeletedRemoteReq(sprintReqVersionInFoldersAndSubFolders);
            }
            dataRow.addData(IS_DELETED_SPRINT, sprintIsDeleted);
            dataRow.addData(HAS_OUT_OF_PERIMETER_OR_DELETED_REMOTE_REQ, hasOutOfPerimeterOrDeletedRemoteReq);
        });
    }

    private boolean checkIfSprintIsDeleted(Long sprintId) {
        Integer count = (Integer)this.dsl.select((SelectField)DSL.count((Field)Tables.SPRINT.REMOTE_STATE)).from((TableLike)Tables.SPRINT).where(Tables.SPRINT.CLN_ID.eq((Object)sprintId)).and(Tables.SPRINT.REMOTE_STATE.eq((Object)String.valueOf(SprintStatus.DELETED))).fetchOneInto(Integer.TYPE);
        return count > 0;
    }

    private List<Long> findSynchronizedFolderAndSubFolders(long rootFolderId) {
        return this.findSynchronizedSubFolders(rootFolderId);
    }

    private List<Long> findSynchronizedSubFolders(Long folderId) {
        return this.dsl.select((SelectField)Tables.SPRINT.CLN_ID).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)folderId)).fetch((Field)Tables.SPRINT.CLN_ID);
    }

    private List<Long> findSynchronizedSprintReqVersionsInsideFolders(List<Long> sprintIds) {
        return this.dsl.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID).from((TableLike)Tables.SPRINT_REQ_VERSION).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).fetch((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID);
    }

    private boolean checkIfSprintsHaveOutOfPerimeterOrDeletedRemoteReq(List<Long> sprintReqVersionInFoldersAndSubFolders) {
        Integer count = (Integer)this.dsl.select((SelectField)DSL.count((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_PERIMETER_STATUS)).from((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).where(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID.in(sprintReqVersionInFoldersAndSubFolders)).and(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_PERIMETER_STATUS.in((Object[])new String[]{RemoteRequirementPerimeterStatus.OUT_OF_CURRENT_PERIMETER.name(), RemoteRequirementPerimeterStatus.NOT_FOUND.name()})).fetchOneInto(Integer.TYPE);
        return count > 0;
    }
}

