/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.project;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.actionword.ActionWordLibrary;
import org.squashtest.tm.domain.actionword.ActionWordLibraryNode;
import org.squashtest.tm.domain.actionword.ActionWordTreeDefinition;
import org.squashtest.tm.domain.actionword.ActionWordTreeEntity;
import org.squashtest.tm.domain.aiserver.AiServer;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.bdd.BddScriptLanguage;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.library.PluginReferencer;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.AdministrableProject;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.project.ProjectTemplate;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryPluginBinding;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestLibrary;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyProjectPermissionsBean;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerWasDeletedException;
import org.squashtest.tm.exception.project.LockedParameterException;
import org.squashtest.tm.exception.testautomation.DuplicateTMLabelException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.bugtracker.CustomBugTrackerModificationService;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.environmentvariable.EnvironmentVariableBindingService;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.infolist.InfoListFinderService;
import org.squashtest.tm.service.internal.display.dto.party.UnboundPartiesResponse;
import org.squashtest.tm.service.internal.display.dto.party.UnboundParty;
import org.squashtest.tm.service.internal.project.GenericToAdministrableProject;
import org.squashtest.tm.service.internal.project.ProjectDeletionHandler;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.internal.project.WrongLifetimeFormatException;
import org.squashtest.tm.service.internal.repository.ActionWordLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.AutomationRequestDao;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.InfoListDao;
import org.squashtest.tm.service.internal.repository.PartyDao;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectTemplateDao;
import org.squashtest.tm.service.internal.repository.RemoteAutomationRequestExtenderDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.SprintRequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateRequirementDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintGroupDao;
import org.squashtest.tm.service.internal.repository.loaders.testcase.TestCaseLoader;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.project.GenericProjectCopyParameter;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.security.ObjectIdentityService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginService;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.testcase.CustomTestCaseModificationService;

@Service(value="CustomGenericProjectManager")
@Transactional
public class CustomGenericProjectManagerImpl
implements CustomGenericProjectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomGenericProjectManagerImpl.class);
    @Inject
    private GenericProjectDao genericProjectDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private ProjectTemplateDao templateDao;
    @Inject
    private BugTrackerDao bugTrackerDao;
    @PersistenceContext
    private EntityManager em;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private PartyDao partyDao;
    @Inject
    private ExecutionDao executionDao;
    @Inject
    private ObjectIdentityService objectIdentityService;
    @Inject
    private Provider<GenericToAdministrableProject> genericToAdministrableConvertor;
    @Inject
    private ProjectsPermissionManagementService permissionsManager;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private ProjectDeletionHandler projectDeletionHandler;
    @Inject
    private ExecutionProcessingService execProcessing;
    @Inject
    private TestAutomationServerManagerService taServerService;
    @Inject
    private TestAutomationProjectManagerService taProjectService;
    @Inject
    private InfoListFinderService infoListService;
    @Inject
    private CustomFieldBindingModificationService customFieldBindingModificationService;
    @Inject
    private CustomReportLibraryNodeDao customReportLibraryNodeDao;
    @Inject
    private ActionWordLibraryNodeDao actionWordLibraryNodeDao;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private CustomTestCaseModificationService customTestCaseModificationService;
    @Inject
    private RequirementFolderSyncExtenderDao requirementFolderSyncExtenderDao;
    @Inject
    private RequirementSyncExtenderDao requirementSyncExtenderDao;
    @Inject
    private SprintRequirementSyncExtenderDao sprintReqSyncExtenderDao;
    @Inject
    private SprintDao sprintDao;
    @Inject
    private HibernateRequirementDao hibernateRequirementDao;
    @Inject
    private HibernateSprintGroupDao hibernateSprintGroupDao;
    @Inject
    private SprintReqVersionDao sprintReqVersionDao;
    @Inject
    private AutomationRequestDao automationRequestDao;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private RemoteAutomationRequestExtenderDao remoteAutomationRequestExtenderDao;
    @Inject
    private TemplateConfigurablePluginService templateConfigurablePluginService;
    @Inject
    private TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService;
    @Inject
    private InfoListDao infoListDao;
    @Inject
    private TestCaseLoader testCaseLoader;
    @Inject
    private CustomBugTrackerModificationService customBugTrackerModificationService;
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private EnvironmentVariableBindingService environmentVariableBindingService;
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    @Inject
    private ProfileDao profileDao;
    @Inject
    private UserDao userDao;
    @Autowired(required=false)
    Collection<WorkspaceWizard> plugins = Collections.emptyList();

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GenericProject persist(GenericProject project) {
        this.assignDefaultInfolistToProject(project);
        if (this.genericProjectDao.countByName(project.getName()) > 0L) {
            throw new NameAlreadyInUseException(project.getClass().getSimpleName(), project.getName());
        }
        CampaignLibrary cl = new CampaignLibrary();
        project.setCampaignLibrary(cl);
        this.em.persist((Object)cl);
        RequirementLibrary rl = new RequirementLibrary();
        project.setRequirementLibrary(rl);
        this.em.persist((Object)rl);
        TestCaseLibrary tcl = new TestCaseLibrary();
        project.setTestCaseLibrary(tcl);
        this.em.persist((Object)tcl);
        CustomReportLibrary crl = new CustomReportLibrary();
        project.setCustomReportLibrary(crl);
        this.em.persist((Object)crl);
        CustomReportLibraryNode crlNode = new CustomReportLibraryNode(CustomReportTreeDefinition.LIBRARY, crl.getId(), project.getName(), crl);
        crlNode.setEntity((CustomReportTreeEntity)crl);
        this.em.persist((Object)crlNode);
        AutomationRequestLibrary arl = new AutomationRequestLibrary();
        project.setAutomationRequestLibrary(arl);
        this.em.persist((Object)arl);
        ActionWordLibrary awl = new ActionWordLibrary();
        project.setActionWordLibrary(awl);
        this.em.persist((Object)awl);
        ActionWordLibraryNode awlNode = new ActionWordLibraryNode(ActionWordTreeDefinition.LIBRARY, awl.getId(), project.getName(), awl);
        awlNode.setEntity((ActionWordTreeEntity)awl);
        this.em.persist((Object)awlNode);
        this.em.persist((Object)project);
        this.em.flush();
        this.objectIdentityService.addObjectIdentity(project.getId(), project.getClass());
        this.objectIdentityService.addObjectIdentity(tcl.getId(), tcl.getClass());
        this.objectIdentityService.addObjectIdentity(rl.getId(), rl.getClass());
        this.objectIdentityService.addObjectIdentity(cl.getId(), cl.getClass());
        this.objectIdentityService.addObjectIdentity(crl.getId(), crl.getClass());
        this.objectIdentityService.addObjectIdentity(arl.getId(), arl.getClass());
        this.objectIdentityService.addObjectIdentity(awl.getId(), awl.getClass());
        return project;
    }

    private void assignDefaultInfolistToProject(GenericProject project) {
        InfoList defaultCategories = this.infoListService.findByCode("DEF_REQ_CAT");
        project.setRequirementCategories(defaultCategories);
        InfoList defaultNatures = this.infoListService.findByCode("DEF_TC_NAT");
        project.setTestCaseNatures(defaultNatures);
        InfoList defaultTypes = this.infoListService.findByCode("DEF_TC_TYP");
        project.setTestCaseTypes(defaultTypes);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void coerceProjectIntoTemplate(long projectId) {
        this.projectDeletionHandler.checkProjectContainsOnlyFolders(projectId);
        this.projectDeletionHandler.deleteAllLibrariesContent(projectId);
        Project project = (Project)this.projectDao.getReferenceById(projectId);
        this.projectDeletionHandler.removeProjectFromFilters(project);
        this.templateConfigurablePluginBindingService.removeAllForGenericProject(project.getId());
        this.deleteAllSync(projectId);
        ProjectTemplate template = this.genericProjectDao.coerceProjectIntoTemplate(projectId);
        this.objectIdentityService.addObjectIdentity(projectId, ProjectTemplate.class);
        this.permissionsManager.copyAssignedUsersFromProjectToTemplate(template, projectId);
        this.permissionsManager.removeAllPermissionsFromProject(projectId);
        this.objectIdentityService.removeObjectIdentity(projectId, Project.class);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void associateToTemplate(long projectId, long templateId, List<String> boundTemplatePlugins) {
        Project project = (Project)this.projectDao.getReferenceById(projectId);
        ProjectTemplate template = (ProjectTemplate)this.templateDao.getReferenceById(templateId);
        project.setTemplate(template);
        this.synchronizeProjectFromTemplate(project, template, boundTemplatePlugins);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void disassociateFromTemplate(long projectId) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        genericProject.setTemplate(null);
        this.templateConfigurablePluginBindingService.removeAllForGenericProject(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public AdministrableProject findAdministrableProjectById(long projectId) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        return ((GenericToAdministrableProject)this.genericToAdministrableConvertor.get()).convertToAdministrableProject(genericProject);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT_CLEARANCE')  or hasRole('ROLE_ADMIN')")
    public void addNewPermissionToProject(List<Long> userIds, long projectId, String permission) {
        if (!this.ultimateLicenseAvailabilityService.isAvailable() && !AclGroup.isSystem((String)permission)) {
            throw new IllegalArgumentException(String.format("%s %s %s", "Profile", permission, "is not a system profile."));
        }
        userIds.forEach(partyId -> this.addNewPermissionToProject((long)partyId, projectId, permission));
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT_CLEARANCE')  or hasRole('ROLE_ADMIN')")
    public void addNewPermissionToProject(List<Long> userIds, long projectId, long profileId) {
        Optional optionalProfile;
        if (!this.ultimateLicenseAvailabilityService.isAvailable() && (optionalProfile = this.profileDao.findById(profileId)).isPresent() && !((AclGroup)optionalProfile.get()).isSystem()) {
            throw new IllegalArgumentException(String.format("%s %s %s", "Profile", ((AclGroup)optionalProfile.get()).getQualifiedName(), "is not a system profile."));
        }
        userIds.forEach(partyId -> this.addNewPermissionToProject((long)partyId, projectId, profileId));
    }

    private void addNewPermissionToProject(long userId, long projectId, String permission) {
        String groupQualifiedName = this.userDao.findUserGroupQualifiedName(userId);
        if ("squashtest.authz.group.tm.InfrastructureAdmin".equals(groupQualifiedName)) {
            throw new AccessDeniedException("Access denied.");
        }
        this.permissionsManager.addNewPermissionToProject(userId, projectId, permission);
    }

    private void addNewPermissionToProject(long userId, long projectId, long profileId) {
        String groupQualifiedName = this.userDao.findUserGroupQualifiedName(userId);
        if ("squashtest.authz.group.tm.InfrastructureAdmin".equals(groupQualifiedName)) {
            throw new AccessDeniedException("Access denied.");
        }
        this.permissionsManager.addNewPermissionToProject(userId, projectId, profileId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT_CLEARANCE')  or hasRole('ROLE_ADMIN')")
    public void removeProjectPermission(List<Long> userIds, long projectId) {
        userIds.forEach(userId -> this.removeProjectPermission((long)userId, projectId));
    }

    private void removeProjectPermission(long userId, long projectId) {
        this.permissionsManager.removeProjectPermission(userId, projectId);
    }

    @Override
    public List<PartyProjectPermissionsBean> findPartyPermissionsBeansByProject(long projectId) {
        return this.permissionsManager.findPartyPermissionsBeanByProject(projectId);
    }

    @Override
    public List<AclGroup> findAllPossiblePermission() {
        return this.permissionsManager.findAllPossiblePermission();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT_CLEARANCE')  or hasRole('ROLE_ADMIN')")
    public UnboundPartiesResponse findPartyWithoutPermissionByProject(long projectId) {
        List<Party> partyList = this.permissionsManager.findPartyWithoutPermissionByProject(projectId);
        ArrayList<UnboundParty> users = new ArrayList<UnboundParty>();
        ArrayList<UnboundParty> teams = new ArrayList<UnboundParty>();
        for (Party p : partyList) {
            boolean isUser = User.class.isAssignableFrom(p.getClass());
            Long id = p.getId();
            String label = HTMLCleanupUtils.cleanAndUnescapeHTML(p.getName());
            UnboundParty unboundParty = new UnboundParty(id, label);
            if (isUser) {
                users.add(unboundParty);
                continue;
            }
            teams.add(unboundParty);
        }
        return new UnboundPartiesResponse(users, teams);
    }

    @Override
    public Party findPartyById(long partyId) {
        return (Party)this.partyDao.getReferenceById(partyId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindTestAutomationServer(long projectId, Long serverId) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        this.taProjectService.deleteAllForTMProject(projectId);
        this.clearEnvironmentTagOverrides(projectId);
        TestAutomationServer taServer = null;
        if (serverId != null) {
            taServer = this.taServerService.findById(serverId);
            this.bindServerEnvironmentVariablesToProject(projectId, serverId);
        }
        genericProject.setTestAutomationServer(taServer);
    }

    private void bindServerEnvironmentVariablesToProject(Long projectId, Long taServerId) {
        this.environmentVariableBindingService.bindServerEnvironmentVariablesToProject(taServerId, projectId);
    }

    @Override
    public void bindTestAutomationProject(long projectId, TestAutomationProject taProject) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        this.bindTestAutomationProject(taProject, genericProject);
    }

    private void bindTestAutomationProject(TestAutomationProject taProject, GenericProject genericProject) {
        TestAutomationServer server = genericProject.getTestAutomationServer();
        taProject.setServer(server);
        taProject.setTmProject(genericProject);
        this.taProjectService.persist(taProject);
        genericProject.bindTestAutomationProject(taProject);
        if (taProject.isCanRunGherkin()) {
            this.taProjectService.setUniqueBddProject(taProject.getId());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindTestAutomationProjects(long projectId, Collection<TestAutomationProject> taProjects) {
        this.checkTAProjectNames(taProjects, projectId);
        for (TestAutomationProject p : taProjects) {
            this.bindTestAutomationProject(projectId, p);
        }
    }

    private void checkTAProjectNames(Collection<TestAutomationProject> taProjects, long projectId) {
        List<String> taProjectNames = this.genericProjectDao.findBoundTestAutomationProjectLabels(projectId);
        for (TestAutomationProject taProject : taProjects) {
            this.checkTAProjecTName(taProject, taProjectNames);
        }
    }

    private void checkTAProjecTName(TestAutomationProject taProject, List<String> projectNames) {
        if (projectNames.contains(taProject.getLabel())) {
            throw new DuplicateTMLabelException(taProject.getLabel());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Collection<TestAutomationProject> findAllAvailableTaProjects(long projectId) {
        TestAutomationServer server = this.genericProjectDao.findTestAutomationServer(projectId);
        if (server == null) {
            return Collections.emptyList();
        }
        Collection<TestAutomationProject> availableTaProjects = this.taProjectService.listProjectsOnServer(server);
        return this.filterAlreadyBoundProjects(projectId, availableTaProjects);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Collection<TestAutomationProject> findAllAvailableTaProjectsWithUserLevelCredentials(long projectId) {
        TestAutomationServer server = this.genericProjectDao.findTestAutomationServer(projectId);
        if (server == null) {
            return Collections.emptyList();
        }
        Collection<TestAutomationProject> availableTaProjects = this.taProjectService.listProjectsOnServerForCurrentUser(server);
        return this.filterAlreadyBoundProjects(projectId, availableTaProjects);
    }

    @Override
    public List<String> getProjectEnvironmentTags(long genericProjectId) {
        return this.genericProjectDao.getEnvironmentTags(genericProjectId);
    }

    @Override
    public boolean isInheritsEnvironmentTags(long genericProjectId) {
        return this.genericProjectDao.isInheritsEnvironmentTags(genericProjectId);
    }

    private Collection<TestAutomationProject> filterAlreadyBoundProjects(long projectId, Collection<TestAutomationProject> availableTaProjects) {
        List<String> alreadyBoundProjectsJobNames = this.genericProjectDao.findBoundTestAutomationProjectJobNames(projectId);
        Iterator<TestAutomationProject> it = availableTaProjects.iterator();
        while (it.hasNext()) {
            TestAutomationProject taProject = it.next();
            if (!alreadyBoundProjectsJobNames.contains(taProject.getJobName())) continue;
            it.remove();
        }
        return availableTaProjects;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindScmRepository(long projectId, long scmRepositoryId) {
        this.genericProjectDao.bindScmRepository(projectId, scmRepositoryId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindScmRepository(long projectId) {
        this.genericProjectDao.unbindScmRepository(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeBugTracker(long projectId, Long newBugtrackerId) {
        GenericProject project = this.genericProjectDao.getProjectWithBugtrackerProjects(projectId);
        BugTracker newBugtracker = (BugTracker)this.bugTrackerDao.findById(newBugtrackerId).orElseThrow(() -> new UnknownEntityException(newBugtrackerId.longValue(), BugTracker.class));
        this.changeBugTracker(project, newBugtracker);
    }

    private void changeBugTracker(GenericProject project, BugTracker newBugtracker) {
        LOGGER.debug("Change bugTracker for project {} bugtracker id: {}", new Object[]{project.getId(), newBugtracker.getId()});
        if (!project.isBoundToBugtracker()) {
            project.bindBugtracker(newBugtracker);
        } else {
            Long oldBugtrackerId;
            Long newBugtrackerId = newBugtracker.getId();
            if (!newBugtrackerId.equals(oldBugtrackerId = project.getBugTracker().getId())) {
                project.bindBugtracker(newBugtracker);
            }
        }
        this.customBugTrackerModificationService.refreshCacheForProject(project.getId());
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeBugTracker(long projectId) {
        LOGGER.debug("Remove bugTracker projects for project id {}", new Object[]{projectId});
        GenericProject project = this.genericProjectDao.getProjectWithBugtrackerProjects(projectId);
        project.unbindBugtracker();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void enablePlugin(long projectId, @NotNull ConfigurablePlugin plugin) {
        ConfigurablePlugin configurablePlugin = plugin;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)configurablePlugin);
        plugin.getWorkspaces().forEach(workspace -> this.enablePluginForWorkspace(projectId, (WorkspaceType)workspace, plugin.getId(), plugin.getPluginType()));
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void enablePluginForWorkspace(long projectId, WorkspaceType workspace, String pluginId, PluginType pluginType) {
        PluginReferencer<?> library = this.findLibrary(projectId, workspace);
        LibraryPluginBinding binding = library.getPluginBinding(pluginId);
        if (binding != null) {
            binding.setActive(Boolean.valueOf(true));
            this.enableAllRemoteSynchronisations(projectId, pluginId);
        } else {
            library.enablePlugin(pluginId);
            LibraryPluginBinding newBinding = library.getPluginBinding(pluginId);
            if (pluginType != null) {
                newBinding.setPluginType(pluginType);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void disablePluginAndRemoveConfiguration(long projectId, List<WorkspaceType> workspaces, String pluginId) {
        for (WorkspaceType workspace : workspaces) {
            PluginReferencer<?> library = this.findLibrary(projectId, workspace);
            library.disablePlugin(pluginId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeSynchronisations(long projectId, String pluginId) {
        List<RemoteSynchronisation> listRemoteSync = this.remoteSynchronisationDao.findByProjectIdAndKind(projectId, pluginId);
        List<Long> syncIds = listRemoteSync.stream().map(RemoteSynchronisation::getId).toList();
        if (!syncIds.isEmpty()) {
            this.removeSynchronisationsByIds(syncIds);
        }
        listRemoteSync.forEach(remoteSync -> this.remoteSynchronisationDao.delete(remoteSync));
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void removeSynchronisationsByIds(List<Long> syncIds) {
        this.checkPermissionOnSyncIds(syncIds);
        this.hibernateRequirementDao.setNativeManagementModeForSynchronizedRequirements(syncIds);
        this.requirementFolderSyncExtenderDao.deleteByRemoteSynchronisationId(syncIds);
        this.requirementSyncExtenderDao.deleteByRemoteSynchronisationId(syncIds);
        this.removeSprintSynchronisationBySyncIds(syncIds);
        this.remoteSynchronisationDao.deleteAllById(syncIds);
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void removeSprintSynchronisationBySyncIds(List<Long> syncIds) {
        this.checkPermissionOnSyncIds(syncIds);
        this.sprintReqVersionDao.setAllSprintReqVersionToNativeByRemoteSyncIds(syncIds);
        this.hibernateSprintGroupDao.setRemoteSyncIdsToNull(syncIds);
        this.sprintDao.deleteRemoteSynchronisationFromSprint(syncIds);
        this.sprintReqSyncExtenderDao.deleteByRemoteSynchronisationIds(syncIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void disablePluginAndKeepConfiguration(long projectId, List<WorkspaceType> workspaces, String pluginId) {
        for (WorkspaceType workspace : workspaces) {
            PluginReferencer<?> library = this.findLibrary(projectId, workspace);
            LibraryPluginBinding binding = library.getPluginBinding(pluginId);
            if (binding == null) continue;
            binding.setActive(Boolean.valueOf(false));
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void disableSynchronisations(long projectId, String pluginId) {
        List<RemoteSynchronisation> listRemoteSync = this.remoteSynchronisationDao.findByProjectIdAndKind(projectId, pluginId);
        listRemoteSync.forEach(remoteSync -> remoteSync.setSynchronisationEnable(false));
    }

    @Override
    public boolean hasProjectRemoteSynchronisation(long projectId) {
        return !this.remoteSynchronisationDao.findByProjectId(projectId).isEmpty();
    }

    @Override
    public void deleteAllSync(long projectId) {
        List<RemoteSynchronisation> rmList = this.remoteSynchronisationDao.findByProjectId(projectId);
        List<Long> ids = rmList.stream().map(RemoteSynchronisation::getId).toList();
        if (!ids.isEmpty()) {
            this.hibernateRequirementDao.setNativeManagementModeForSynchronizedRequirements(ids);
            this.requirementFolderSyncExtenderDao.deleteByRemoteSynchronisationId(ids);
            this.requirementSyncExtenderDao.deleteByRemoteSynchronisationId(ids);
            this.sprintReqSyncExtenderDao.deleteByRemoteSynchronisationIds(ids);
            this.sprintDao.deleteRemoteSynchronisationFromSprint(ids);
            this.remoteSynchronisationDao.deleteByProjectId(projectId);
        }
    }

    @Override
    public void deleteAllRemoteAutomationRequestExtenders(long projectId) {
        List<AutomationRequest> automationRequests = this.automationRequestDao.findByProjectId(projectId);
        List<Long> automationRequestIds = automationRequests.stream().map(AutomationRequest::getId).toList();
        if (!automationRequestIds.isEmpty()) {
            this.remoteAutomationRequestExtenderDao.deleteByAutomationRequestIds(automationRequestIds);
        }
    }

    @Override
    public Map<String, String> getPluginConfiguration(long projectId, WorkspaceType workspace, String pluginId) {
        return this.doGetPluginConfiguration(projectId, workspace, pluginId);
    }

    @Override
    public Map<String, String> getPluginConfigurationWithoutCheck(long projectId, WorkspaceType workspace, String pluginId) {
        return this.doGetPluginConfiguration(projectId, workspace, pluginId);
    }

    private Map<String, String> doGetPluginConfiguration(long projectId, WorkspaceType workspace, String pluginId) {
        PluginReferencer<?> library = this.findLibrary(projectId, workspace);
        LibraryPluginBinding binding = library.getPluginBinding(pluginId);
        if (binding != null) {
            return binding.getProperties();
        }
        return new HashMap<String, String>();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void setPluginConfiguration(long projectId, WorkspaceType workspace, String pluginId, Map<String, String> configuration) {
        PluginReferencer<?> library = this.findLibrary(projectId, workspace);
        if (!library.isPluginEnabled(pluginId)) {
            library.enablePlugin(pluginId);
        }
        LibraryPluginBinding binding = library.getPluginBinding(pluginId);
        binding.setProperties(configuration);
        if (this.genericProjectDao.isProjectTemplate(projectId)) {
            this.synchronizeBoundPluginConfigurations(projectId, pluginId);
        }
    }

    @Override
    public void synchronizeBoundPluginConfigurations(long templateId, String pluginId) {
        this.templateConfigurablePluginBindingService.findAllByTemplateIdAndPluginId(templateId, pluginId).forEach(binding -> {
            Long projectId = binding.getProjectId();
            this.templateConfigurablePluginService.findById(pluginId).ifPresent(plugin -> plugin.synchroniseTemplateConfiguration(Long.valueOf(templateId), projectId));
        });
    }

    @Override
    public void enableAllRemoteSynchronisations(long projectId, String pluginId) {
        List<RemoteSynchronisation> listRemoteSync = this.remoteSynchronisationDao.findByProjectIdAndKind(projectId, pluginId);
        listRemoteSync.forEach(remoteSync -> remoteSync.setSynchronisationEnable(true));
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void enableExecutionStatus(long projectId, ExecutionStatus executionStatus) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        if (genericProject.isBoundToTemplate()) {
            throw new LockedParameterException();
        }
        this.doEnableExecutionStatus(genericProject, executionStatus);
    }

    @Override
    public void doEnableExecutionStatus(GenericProject genericProject, ExecutionStatus executionStatus) {
        genericProject.getCampaignLibrary().enableStatus(executionStatus);
        if (this.genericProjectDao.isProjectTemplate(genericProject.getId())) {
            Collection<Project> boundProjects = this.projectDao.findAllBoundToTemplate(genericProject.getId());
            for (Project boundProject : boundProjects) {
                boundProject.getCampaignLibrary().enableStatus(executionStatus);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void disableExecutionStatus(long projectId, ExecutionStatus executionStatus) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        if (project.isBoundToTemplate()) {
            throw new LockedParameterException();
        }
        this.doDisableExecutionStatus(project, executionStatus);
    }

    @Override
    public void doDisableExecutionStatus(GenericProject genericProject, ExecutionStatus executionStatus) {
        genericProject.getCampaignLibrary().disableStatus(executionStatus);
        if (this.genericProjectDao.isProjectTemplate(genericProject.getId())) {
            Collection<Project> boundProjects = this.projectDao.findAllBoundToTemplate(genericProject.getId());
            for (Project boundProject : boundProjects) {
                boundProject.getCampaignLibrary().disableStatus(executionStatus);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Set<ExecutionStatus> enabledExecutionStatuses(long projectId) {
        return this.enabledExecutionStatusesUnsecured(projectId);
    }

    @Override
    public Set<ExecutionStatus> enabledExecutionStatusesUnsecured(long projectId) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        HashSet<ExecutionStatus> statuses = new HashSet<ExecutionStatus>();
        statuses.addAll(Arrays.asList(ExecutionStatus.values()));
        Set disabledStatuses = project.getCampaignLibrary().getDisabledStatuses();
        statuses.removeAll(disabledStatuses);
        statuses.removeAll(ExecutionStatus.TA_STATUSES_ONLY);
        return statuses;
    }

    @Override
    public Set<ExecutionStatus> disabledExecutionStatuses(long projectId) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        return project.getCampaignLibrary().getDisabledStatuses();
    }

    @Override
    public void replaceExecutionStepStatus(long projectId, ExecutionStatus source, ExecutionStatus target) {
        List<Long> modifiedExecutionIds = this.executionDao.findExecutionIdsHavingStepStatus(projectId, source);
        this.executionDao.replaceExecutionStepStatus(projectId, source, target);
        for (Long id : modifiedExecutionIds) {
            ExecutionStatusReport report = this.execProcessing.getExecutionStatusReport(id);
            this.execProcessing.setExecutionStatus(id, report);
        }
        this.executionDao.replaceTestPlanStatus(projectId, source, target);
    }

    @Override
    public boolean projectUsesExecutionStatus(long projectId, ExecutionStatus executionStatus) {
        return this.executionDao.projectUsesExecutionStatus(projectId, executionStatus);
    }

    private PluginReferencer<?> findLibrary(long projectId, WorkspaceType workspace) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        return switch (workspace) {
            case WorkspaceType.TEST_CASE_WORKSPACE -> project.getTestCaseLibrary();
            case WorkspaceType.REQUIREMENT_WORKSPACE -> project.getRequirementLibrary();
            case WorkspaceType.CAMPAIGN_WORKSPACE -> project.getCampaignLibrary();
            default -> throw new IllegalArgumentException("WorkspaceType " + String.valueOf(workspace) + " is unknown and is not covered");
        };
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeName(long projectId, String newName) {
        GenericProject project = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        if (StringUtils.equals((CharSequence)project.getName(), (CharSequence)newName)) {
            return;
        }
        boolean projectNameIsSameWithDifferentCase = StringUtils.equals((CharSequence)project.getName().toLowerCase(), (CharSequence)newName.toLowerCase());
        if (!projectNameIsSameWithDifferentCase && this.genericProjectDao.countByName(newName) > 0L) {
            throw new NameAlreadyInUseException(project.getClass().getSimpleName(), newName);
        }
        CustomReportLibrary crl = project.getCustomReportLibrary();
        CustomReportLibraryNode node = this.customReportLibraryNodeDao.findNodeFromEntity((CustomReportTreeEntity)crl);
        node.setName(newName);
        ActionWordLibrary awl = project.getActionWordLibrary();
        ActionWordLibraryNode actionWordLibraryNode = this.actionWordLibraryNodeDao.findNodeFromEntity((ActionWordTreeEntity)awl);
        actionWordLibraryNode.setName(newName);
        project.setName(newName);
    }

    private void copyMilestone(GenericProject target, GenericProject source) {
        List<Milestone> milestones = this.getOnlyBindableMilestones(source.getMilestones());
        target.bindMilestones(milestones);
        for (Milestone milestone : milestones) {
            milestone.addProjectToPerimeter(target);
        }
    }

    private List<Milestone> getOnlyBindableMilestones(List<Milestone> milestones) {
        ArrayList<Milestone> bindableMilestones = new ArrayList<Milestone>();
        for (Milestone m : milestones) {
            if (!m.getStatus().isBindableToProject()) continue;
            bindableMilestones.add(m);
        }
        return bindableMilestones;
    }

    private void copyTestAutomationSettings(GenericProject target, GenericProject source) {
        target.setTestAutomationServer(source.getTestAutomationServer());
        for (TestAutomationProject automationProject : source.getTestAutomationProjects()) {
            TestAutomationProject taCopy = automationProject.createCopy();
            this.bindTestAutomationProject(target.getId(), taCopy);
        }
    }

    private void copyImplementationTechnologyAndScriptLanguage(GenericProject target, GenericProject source) {
        target.setBddImplementationTechnology(source.getBddImplementationTechnology());
        target.setBddScriptLanguage(source.getBddScriptLanguage());
    }

    private void copyAutomationWorkflowSettings(GenericProject target, GenericProject source) {
        target.setAllowAutomationWorkflow(source.isAllowAutomationWorkflow());
        target.setAutomationWorkflowType(source.getAutomationWorkflowType());
    }

    private void copyBugtrackerSettings(GenericProject target, GenericProject source) {
        if (source.isBoundToBugtracker()) {
            this.changeBugTracker(target, source.getBugTracker());
        }
    }

    private void copyAiServerSettings(GenericProject target, GenericProject source) {
        target.setAiServer(source.getAiServer());
    }

    private void copyCustomFieldsSettings(GenericProject target, GenericProject source) {
        this.customFieldBindingModificationService.copyCustomFieldsSettingsFromTemplate(target, source);
    }

    private void copyAssignedUsers(GenericProject target, GenericProject source) {
        this.permissionsManager.copyAssignedUsers(target, source);
    }

    private void copyInfolists(GenericProject target, GenericProject source) {
        target.setRequirementCategories(source.getRequirementCategories());
        target.setTestCaseNatures(source.getTestCaseNatures());
        target.setTestCaseTypes(source.getTestCaseTypes());
    }

    private void copyExecutionStatuses(GenericProject target, GenericProject source) {
        Set<ExecutionStatus> enabledStatuses = this.enabledExecutionStatusesUnsecured(source.getId());
        Set<ExecutionStatus> disabledStatuses = this.disabledExecutionStatuses(source.getId());
        for (ExecutionStatus execStatusToEnable : enabledStatuses) {
            this.doEnableExecutionStatus(target, execStatusToEnable);
        }
        for (ExecutionStatus execStatusToDisable : disabledStatuses) {
            this.doDisableExecutionStatus(target, execStatusToDisable);
        }
    }

    private void copyPluginsActivation(GenericProject target, GenericProject source) {
        for (String pluginId : source.getRequirementLibrary().getEnabledPlugins()) {
            target.getRequirementLibrary().enablePlugin(pluginId);
        }
        for (String pluginId : source.getTestCaseLibrary().getEnabledPlugins()) {
            PluginType pluginType;
            target.getTestCaseLibrary().enablePlugin(pluginId);
            TestCaseLibraryPluginBinding lpb = source.getTestCaseLibrary().getPluginBinding(pluginId);
            if (lpb == null || (pluginType = lpb.getPluginType()) == null) continue;
            target.getTestCaseLibrary().getPluginBinding(pluginId).setPluginType(pluginType);
        }
        for (String pluginId : source.getCampaignLibrary().getEnabledPlugins()) {
            target.getCampaignLibrary().enablePlugin(pluginId);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GenericProject synchronizeGenericProject(GenericProject target, GenericProject source, GenericProjectCopyParameter params) {
        if (params.isCopyPermissions()) {
            this.copyAssignedUsers(target, source);
        }
        if (params.isCopyCUF()) {
            this.copyCustomFieldsSettings(target, source);
        }
        if (params.isCopyBugtrackerBinding()) {
            this.copyBugtrackerSettings(target, source);
        }
        if (params.isCopyAiServerBinding()) {
            this.copyAiServerSettings(target, source);
        }
        if (params.isCopyAutomatedProjects()) {
            this.copyImplementationTechnologyAndScriptLanguage(target, source);
            this.copyTestAutomationSettings(target, source);
            this.copyAutomationWorkflowSettings(target, source);
        }
        if (params.isCopyInfolists()) {
            this.copyInfolists(target, source);
        }
        if (params.isCopyMilestone()) {
            this.copyMilestone(target, source);
        }
        if (params.isCopyAllowTcModifFromExec()) {
            target.setAllowTcModifDuringExec(source.allowTcModifDuringExec());
        }
        if (params.isCopyOptionalExecStatuses()) {
            this.copyExecutionStatuses(target, source);
        }
        if (params.isCopyPluginsActivation()) {
            this.copyPluginsActivation(target, source);
        }
        if (params.isCopyPluginsConfiguration()) {
            this.copyPluginConfiguration(target, source);
        }
        return target;
    }

    private void copyPluginConfiguration(GenericProject target, GenericProject source) {
        GenericProject sourceProject = this.projectManager.findById(source.getId());
        List<String> enabledPluginIds = sourceProject.getRequirementLibrary().getEnabledPlugins().stream().toList();
        List<TemplateConfigurablePlugin> configurablePlugins = this.templateConfigurablePluginService.findByIds(enabledPluginIds);
        configurablePlugins.forEach(plugin -> plugin.synchroniseTemplateConfiguration(source.getId(), target.getId()));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GenericProject synchronizeProjectFromTemplate(Project target, ProjectTemplate source, List<String> boundTemplatePlugins) {
        this.copyCustomFieldsSettings((GenericProject)target, (GenericProject)source);
        this.copyInfolists((GenericProject)target, (GenericProject)source);
        this.infoListDao.setDefaultNatureForProject(target.getId(), source.getTestCaseNatures().getDefaultItem());
        this.infoListDao.setDefaultTypeForProject(target.getId(), source.getTestCaseTypes().getDefaultItem());
        this.infoListDao.setDefaultCategoryForProject(target.getId(), source.getRequirementCategories().getDefaultItem());
        target.setAllowTcModifDuringExec(source.allowTcModifDuringExec());
        this.copyExecutionStatuses((GenericProject)target, (GenericProject)source);
        this.copyPluginsActivation((GenericProject)target, (GenericProject)source);
        this.copyImplementationTechnologyAndScriptLanguage((GenericProject)target, (GenericProject)source);
        this.copyAutomationWorkflowSettings((GenericProject)target, (GenericProject)source);
        this.copyServersSettings(target, source);
        boundTemplatePlugins.stream().map(this.templateConfigurablePluginService::findById).filter(Optional::isPresent).map(Optional::get).forEach(plugin -> this.addTemplatePluginConfigurationBinding((TemplateConfigurablePlugin)plugin, target, source));
        return target;
    }

    private void copyServersSettings(Project target, ProjectTemplate source) {
        if (target.getTestAutomationServer() == null) {
            this.copyTestAutomationSettings((GenericProject)target, (GenericProject)source);
        }
        if (!target.isBoundToBugtracker()) {
            this.copyBugtrackerSettings((GenericProject)target, (GenericProject)source);
        }
        if (target.getAiServer() == null) {
            this.copyAiServerSettings((GenericProject)target, (GenericProject)source);
        }
    }

    private void addTemplatePluginConfigurationBinding(TemplateConfigurablePlugin plugin, Project target, ProjectTemplate source) {
        Long templateId = source.getId();
        Long projectId = target.getId();
        String pluginId = plugin.getId();
        if (!this.templateConfigurablePluginBindingService.hasBinding(templateId, projectId, pluginId)) {
            this.templateConfigurablePluginBindingService.createTemplateConfigurablePluginBinding(source, target, plugin);
            if (this.pluginHasConfiguration((ConfigurablePlugin)plugin, templateId)) {
                plugin.synchroniseTemplateConfiguration(templateId, projectId);
            }
        }
    }

    @Override
    public boolean pluginHasConfigurationOrSynchronisations(ConfigurablePlugin plugin, long projectId) {
        boolean hasRemoteSynchro = this.hasProjectRemoteSynchronisation(projectId);
        return this.pluginHasConfiguration(plugin, projectId) || hasRemoteSynchro;
    }

    @Override
    public boolean pluginHasConfiguration(ConfigurablePlugin plugin, long projectId) {
        WorkspaceType workspaceType = plugin.getConfiguringWorkspace();
        Map<String, String> pluginConfiguration = this.getPluginConfiguration(projectId, workspaceType, plugin.getId());
        return !pluginConfiguration.isEmpty();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeAllowTcModifDuringExec(long projectId, boolean active) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        if (!genericProject.isBoundToTemplate()) {
            genericProject.setAllowTcModifDuringExec(active);
            if (ProjectHelper.isTemplate(genericProject)) {
                this.templateDao.propagateAllowTcModifDuringExec(projectId, active);
            }
        } else {
            throw new LockedParameterException();
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public boolean checkIfTcGherkinHaveTaScript(Long projectId) {
        boolean check = false;
        Integer number = this.testCaseDao.countScriptedTestCaseAssociatedToTAScriptByProject(projectId);
        if (number > 0) {
            check = true;
        }
        return check;
    }

    private void changeAutomationWorkflow(long projectId, boolean active, boolean isChangingRemoteWorkflowToNativeSimplified) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        genericProject.setAllowAutomationWorkflow(active);
        if (active) {
            List tcIds = this.testCaseDao.findAllTestCaseAssociatedToTAScriptByProject(projectId);
            this.createAutomationRequestForTc(tcIds);
            if (isChangingRemoteWorkflowToNativeSimplified) {
                this.convertRemoteStatusToSquashAutomRequestStatus(genericProject);
            }
        }
        if (ProjectHelper.isTemplate(genericProject)) {
            this.templateDao.propagateAllowAutomationWorkflow(projectId, active);
        }
    }

    private void convertRemoteStatusToSquashAutomRequestStatus(GenericProject genericProject) {
        String finalRemoteStatus = this.getRemoteFinalStatus(genericProject.getId(), true);
        Map tcRemoteStatusMap = this.testCaseDao.findAllAutomatableTestCasesByProjectId(genericProject.getId());
        Object testCases = this.testCaseLoader.load(tcRemoteStatusMap.keySet(), EnumSet.of(TestCaseLoader.Options.FETCH_AUTOMATION_REQUEST));
        testCases.forEach(tc -> {
            boolean isFinalStatus;
            String tcRemoteStatus = (String)tcRemoteStatusMap.get(tc.getId());
            boolean bl = isFinalStatus = tcRemoteStatus != null && tcRemoteStatus.equalsIgnoreCase(finalRemoteStatus);
            if (!isFinalStatus) {
                tc.getAutomationRequest().setRequestStatus(AutomationRequestStatus.TRANSMITTED);
            } else {
                tc.getAutomationRequest().setRequestStatus(AutomationRequestStatus.AUTOMATED);
            }
        });
    }

    private String getRemoteFinalStatus(Long projectId, boolean wasRemoteWorkflow) {
        LibraryPluginBinding lpb = this.projectDao.findPluginForProject(projectId, PluginType.AUTOMATION);
        if (lpb != null && wasRemoteWorkflow) {
            Map<String, String> pluginConfiguration = this.projectManager.getPluginConfigurationWithoutCheck(projectId, WorkspaceType.TEST_CASE_WORKSPACE, lpb.getPluginId());
            return pluginConfiguration == null ? null : pluginConfiguration.get("finalState");
        }
        return null;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeAutomationWorkflow(long projectId, String automationWorkflow) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        boolean isChangingRemoteWorkflowToNativeSimplified = AutomationWorkflowType.REMOTE_WORKFLOW == genericProject.getAutomationWorkflowType() && AutomationWorkflowType.NATIVE_SIMPLIFIED.name().equalsIgnoreCase(automationWorkflow);
        genericProject.setAutomationWorkflowType(AutomationWorkflowType.valueOf((String)automationWorkflow));
        boolean active = !"NONE".equals(automationWorkflow);
        this.changeAutomationWorkflow(projectId, active, isChangingRemoteWorkflowToNativeSimplified);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeUseTreeStructureInScmRepo(long projectId, boolean activated) {
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        genericProject.setUseTreeStructureInScmRepo(activated);
    }

    private void createAutomationRequestForTc(List<Long> tcIds) {
        List testCases = this.testCaseLoader.load(tcIds);
        int x = 0;
        while (x < testCases.size()) {
            TestCase testCase = (TestCase)testCases.get(x);
            testCase.setAutomatable(TestCaseAutomatable.Y);
            this.customTestCaseModificationService.createRequestForTestCase(testCase, AutomationRequestStatus.AUTOMATED);
            if (x % 20 == 0) {
                this.em.flush();
                this.em.clear();
            }
            ++x;
        }
    }

    @Override
    public boolean isProjectUsingWorkflow(long projectId) {
        boolean isProjectUsingWorkflow = false;
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        String workflowType = genericProject.getAutomationWorkflowType().getI18nKey();
        if (workflowType.equals(AutomationWorkflowType.REMOTE_WORKFLOW.getI18nKey())) {
            for (WorkspaceWizard plugin : this.plugins) {
                if (!PluginType.AUTOMATION.equals((Object)plugin.getPluginType())) continue;
                isProjectUsingWorkflow = true;
                break;
            }
        }
        return isProjectUsingWorkflow;
    }

    @Override
    public boolean isProjectTemplate(long projectId) {
        return this.genericProjectDao.isProjectTemplate(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeBddImplTechnology(long projectId, String bddImplTechnology) {
        BddImplementationTechnology newBddImplTechnology = BddImplementationTechnology.valueOf((String)bddImplTechnology);
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        genericProject.setBddImplementationTechnology(newBddImplTechnology);
        if (BddImplementationTechnology.ROBOT.equals((Object)newBddImplTechnology)) {
            genericProject.setBddScriptLanguage(BddScriptLanguage.ENGLISH);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeBddScriptLanguage(long projectId, String bddScriptLanguage) {
        BddScriptLanguage newBddScriptLanguage = BddScriptLanguage.valueOf((String)bddScriptLanguage);
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        BddImplementationTechnology currentBddImplTechnology = genericProject.getBddImplementationTechnology();
        if (BddImplementationTechnology.ROBOT.equals((Object)currentBddImplTechnology) && !BddScriptLanguage.ENGLISH.equals((Object)newBddScriptLanguage)) {
            throw new IllegalArgumentException("No language other than English can be set for a Robot project.");
        }
        genericProject.setBddScriptLanguage(newBddScriptLanguage);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Integer changeAutomatedSuitesLifetime(long projectId, String rawLifetime) {
        Integer lifetime;
        try {
            if (StringUtils.isBlank((CharSequence)rawLifetime)) {
                lifetime = null;
            } else {
                lifetime = Integer.parseInt(rawLifetime);
                if (lifetime < 0) {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new WrongLifetimeFormatException(ex);
        }
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById(projectId);
        genericProject.setAutomatedSuitesLifetime(lifetime);
        return lifetime;
    }

    @Override
    public void clearEnvironmentTagOverrides(long projectId) {
        Optional maybeProject = this.genericProjectDao.findById(projectId);
        if (!maybeProject.isPresent()) {
            throw new IllegalArgumentException(String.format("Project with id %d was not found", projectId));
        }
        GenericProject project = (GenericProject)maybeProject.get();
        project.setEnvironmentTags(Collections.emptyList());
        project.setInheritsEnvironmentTags(true);
    }

    @Override
    public void createAttachmentFromDescription(GenericProject project) {
        String description = project.getDescription();
        if (description == null || description.isEmpty()) {
            return;
        }
        String newDescription = this.attachmentManagerService.handleRichTextAttachments(description, project.getAttachmentList());
        if (!description.equals(newDescription)) {
            project.setDescription(newDescription);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeAiServer(long projectId, long aiServerId) {
        GenericProject project = (GenericProject)this.em.find(GenericProject.class, (Object)projectId);
        AiServer aiServer = (AiServer)this.em.find(AiServer.class, (Object)aiServerId);
        if (aiServer == null) {
            throw new AiServerWasDeletedException();
        }
        project.setAiServer(aiServer);
    }

    @Override
    public void unbindAiServers(List<Long> aiServerIds) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        this.genericProjectDao.unbindAiServers(aiServerIds);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindAiServer(long projectId) {
        this.genericProjectDao.unbindAiServer(projectId);
    }

    @Override
    public void unbindBugTrackers(List<Long> bugTrackerIds) {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        this.genericProjectDao.unbindBugTrackers(bugTrackerIds);
    }

    private void checkPermissionOnSyncIds(List<Long> syncIds) {
        this.permissionEvaluationService.checkPermission(syncIds, Permissions.MANAGE_PROJECT.name(), RemoteSynchronisation.class.getName());
    }
}

