/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.FolderPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.FolderPivotDao;

@Service
public class FolderPivotExporterServiceImpl
implements FolderPivotExporterService {
    private final FolderPivotDao folderPivotDao;
    private final PivotFileManager pivotFileManager;

    public FolderPivotExporterServiceImpl(FolderPivotDao folderPivotDao, PivotFileManager pivotFileManager) {
        this.folderPivotDao = folderPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateRequirementFolderJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.folderPivotDao.hasRequirementFolders(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleFolders((JsonGenerator)jsonGenerator, projectId, "requirement_folders"), JsonImportFile.REQUIREMENT_FOLDERS.getFileName(), archive);
    }

    @Override
    public void generateTestCaseFolderJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.folderPivotDao.hasTestCaseFolders(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleFolders((JsonGenerator)jsonGenerator, projectId, "test_case_folders"), JsonImportFile.TEST_CASE_FOLDERS.getFileName(), archive);
    }

    @Override
    public void generateCampaignFolderWithSprintGroupJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.folderPivotDao.hasCampaignFolders(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleFolders((JsonGenerator)jsonGenerator, projectId, "campaign_folders_and_sprint_groups"), JsonImportFile.CAMPAIGN_FOLDERS_AND_SPRINT_GROUPS.getFileName(), archive);
    }

    private void handleFolders(JsonGenerator jsonGenerator, Long projectId, String folderType) throws IOException {
        jsonGenerator.writeFieldName(folderType);
        jsonGenerator.writeStartArray();
        switch (folderType) {
            case "requirement_folders": {
                this.folderPivotDao.getRequirementFoldersByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
                break;
            }
            case "test_case_folders": {
                this.folderPivotDao.getTestCaseFoldersByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
                break;
            }
            case "campaign_folders_and_sprint_groups": {
                this.folderPivotDao.getCampaignFoldersAndSprintGroupsByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown folder type: " + folderType);
            }
        }
        jsonGenerator.writeEndArray();
    }
}

