/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.util.List;
import org.squashtest.tm.domain.campaign.export.CampaignExportCSVModel;

class RowImpl
implements CampaignExportCSVModel.Row {
    private final char separator;
    private final List<? extends CampaignExportCSVModel.Cell> cells;

    public RowImpl(List<? extends CampaignExportCSVModel.Cell> cells, char separator) {
        this.cells = cells;
        this.separator = separator;
    }

    public List<CampaignExportCSVModel.Cell> getCells() {
        return this.cells;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String strSeparator = String.valueOf(this.separator);
        for (CampaignExportCSVModel.Cell cell : this.cells) {
            String value = cell.getValue();
            if (value == null) continue;
            String escaped = value.replaceAll(strSeparator, ";");
            builder.append("\"").append(escaped).append("\"").append(this.separator);
        }
        return builder.toString().replaceAll(this.separator + "$", "");
    }
}

