/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.internal.repository.CustomIssueDao;

public interface IssueDao
extends JpaRepository<Issue, Long>,
CustomIssueDao {
    @Query
    public Integer countIssuesfromExecutionAndExecutionSteps(@Param(value="executionsIds") List<Long> var1, @Param(value="executionStepsIds") List<Long> var2);

    @Query
    public Integer countIssuesfromEmptyExecutions(@Param(value="executionsIds") List<Long> var1);

    @Query
    public long countByCampaign(@Param(value="campaign") Campaign var1);

    @Query
    public List<Issue> findAllForIteration(@Param(value="id") Long var1);

    @Query
    public List<Issue> findAllForTestSuite(@Param(value="id") Long var1);

    @Query
    public List<Issue> findAllForSprint(@Param(value="id") Long var1);

    @Query
    public Integer countIssuesfromExecutionSteps(@Param(value="executionStepsIds") List<Long> var1);

    @Query
    public long countByExecutionAndSteps(@Param(value="execution") Execution var1);

    @Query
    public long countByIteration(@Param(value="iteration") Iteration var1);

    @Query
    public long countByTestSuite(@Param(value="testSuite") TestSuite var1);

    @Query
    public long countByCampaignFolder(@Param(value="folder") CampaignFolder var1);

    @Query
    public long countByTestCase(@Param(value="testCase") TestCase var1);

    @Query
    public long countByRequirementVersion(@Param(value="requirementVersion") RequirementVersion var1);

    @Query
    public long countByTestCaseId(@Param(value="testCaseId") long var1);

    @Query(value="delete from Issue issue where issue.bugtracker.id in :bugTrackerIds")
    @Modifying
    public void deleteAllByBugTrackerIds(@Param(value="bugTrackerIds") List<Long> var1);
}

