/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanOperation;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.QCampaign;
import org.squashtest.tm.domain.campaign.QCampaignPathEdge;
import org.squashtest.tm.domain.campaign.QIteration;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.QueryModel;
import org.squashtest.tm.domain.query.QueryProjectionColumn;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementPathEdge;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.domain.testcase.QTestCasePathEdge;
import org.squashtest.tm.service.internal.query.InternalEntityType;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.QueryPlanner;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
@Scope(value="prototype")
class ScopePlanner {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private PermissionEvaluationService permissionService;
    private InternalQueryModel queryModel;
    private List<EntityReference> scope;
    private ExtendedHibernateQuery<?> hibQuery;
    private ScopeUtils utils;
    private Set<JoinableColumns> extraJoins;

    ScopePlanner() {
    }

    void setHibernateQuery(ExtendedHibernateQuery<?> hibQuery) {
        this.hibQuery = hibQuery;
    }

    void setQueryModel(InternalQueryModel chartQuery) {
        this.queryModel = chartQuery;
    }

    void setScope(List<EntityReference> scope) {
        this.scope = scope;
    }

    @PostConstruct
    void afterPropertiesSet() {
        this.utils = new ScopeUtils(this.em, this.permissionService);
    }

    protected void appendScope() {
        if (this.scope != null && !this.scope.isEmpty()) {
            this.filterByACLs();
            this.prepareExtraJoins();
            if (this.extraJoins.isEmpty()) {
                return;
            }
            this.addExtraJoins();
            this.addWhereClauses();
        }
    }

    private void filterByACLs() {
        ArrayList<EntityReference> filtered = new ArrayList<EntityReference>();
        for (EntityReference ref : this.scope) {
            if (!this.utils.checkPermissions(ref)) continue;
            filtered.add(ref);
        }
        this.scope = filtered;
    }

    private void prepareExtraJoins() {
        ScopedEntitiesImpl scopedEntities = new ScopedEntitiesImpl(this.scope);
        QueriedEntitiesImpl queriedEntities = new QueriedEntitiesImpl(this.queryModel);
        this.deduceExtraJoins(scopedEntities, queriedEntities);
    }

    private void deduceExtraJoins(ScopedEntities scopedEntities, QueriedEntities queriedEntities) {
        this.extraJoins = new HashSet<JoinableColumns>();
        Set<JoinableColumns> requiredColumns = scopedEntities.getRequiredJoinColumns();
        for (JoinableColumns scopeColumn : requiredColumns) {
            if (scopeColumn == JoinableColumns.POSSIBLE_COLUMNS_ONLY) {
                Set<JoinableColumns> queriedColumns = queriedEntities.getPossibleJoinColumns();
                for (JoinableColumns queryColumn : queriedColumns) {
                    this.extraJoins.add(queryColumn);
                }
                continue;
            }
            this.extraJoins.add(scopeColumn);
        }
    }

    private void addExtraJoins() {
        QueryModel dummy = this.createDummyQuery(this.extraJoins);
        InternalQueryModel detailDummy = InternalQueryModel.createFor(dummy);
        this.appendScopeToQuery(detailDummy);
    }

    private QueryModel createDummyQuery(Set<JoinableColumns> fakeMeasureColLabels) {
        QueryModel dummy = new QueryModel();
        dummy.setAggregationColumns(this.queryModel.getAggregationColumns());
        ArrayList<QueryProjectionColumn> fakeMeasures = new ArrayList<QueryProjectionColumn>();
        for (JoinableColumns fakeMeasure : fakeMeasureColLabels) {
            QueryColumnPrototype mProto = this.utils.findColumnPrototype(fakeMeasure.toString());
            QueryProjectionColumn meas = new QueryProjectionColumn();
            meas.setColumnPrototype(mProto);
            fakeMeasures.add(meas);
        }
        dummy.setProjectionColumns(fakeMeasures);
        return dummy;
    }

    private void appendScopeToQuery(InternalQueryModel extraQuery) {
        QueryPlanner planner = new QueryPlanner(extraQuery);
        planner.appendToQuery(this.hibQuery);
        planner.modifyQuery();
    }

    private void addWhereClauses() {
        BooleanBuilder generalCondition = new BooleanBuilder();
        ScopedEntitiesImpl scopedEntities = new ScopedEntitiesImpl(this.scope);
        if (this.extraJoins.contains((Object)JoinableColumns.TEST_CASE_ID)) {
            BooleanBuilder testcaseClause = this.whereClauseForTestcases(scopedEntities);
            generalCondition.and((Predicate)testcaseClause);
        }
        if (this.extraJoins.contains((Object)JoinableColumns.REQUIREMENT_ID)) {
            BooleanBuilder requirementClause = this.whereClauseForRequirements(scopedEntities);
            generalCondition.and((Predicate)requirementClause);
        }
        if (this.extraJoins.contains((Object)JoinableColumns.CAMPAIGN_ID) || this.extraJoins.contains((Object)JoinableColumns.ITERATION_ID)) {
            BooleanBuilder campaignClause = this.whereClauseForCampaigns(scopedEntities);
            generalCondition.and((Predicate)campaignClause);
        }
        this.hibQuery.where((Predicate)generalCondition);
    }

    private BooleanBuilder whereClauseForTestcases(ScopedEntities refmap) {
        BooleanBuilder builder = new BooleanBuilder();
        QTestCase testCase = QTestCase.testCase;
        Collection<Long> ids = refmap.getIds(EntityType.PROJECT);
        if (this.notEmpty(ids)) {
            builder.or((Predicate)testCase.project.id.in(ids));
        }
        if (this.notEmpty(ids = refmap.getIds(EntityType.TEST_CASE_LIBRARY))) {
            builder.or((Predicate)testCase.project.testCaseLibrary.id.in(ids));
        }
        if (this.notEmpty(ids = refmap.getIds(EntityType.TEST_CASE, EntityType.TEST_CASE_FOLDER))) {
            QTestCasePathEdge edge = QTestCasePathEdge.testCasePathEdge;
            ExtendedHibernateQuery subq = new ExtendedHibernateQuery();
            ((HibernateQuery)((HibernateQuery)subq.select(Expressions.constant((Object)1)).from((EntityPath)edge)).where((Predicate)edge.ancestorId.in(ids))).where((Predicate)testCase.id.eq((Expression)edge.descendantId));
            BooleanOperation predicate = Expressions.predicate((Operator)Ops.EXISTS, (Expression[])new Expression[]{subq});
            builder.or((Predicate)predicate);
        }
        return builder;
    }

    private BooleanBuilder whereClauseForRequirements(ScopedEntities refmap) {
        BooleanBuilder builder = new BooleanBuilder();
        QRequirement requirement = QRequirement.requirement;
        Collection<Long> ids = refmap.getIds(EntityType.PROJECT);
        if (this.notEmpty(ids)) {
            builder.or((Predicate)requirement.project.id.in(ids));
        }
        if (this.notEmpty(ids = refmap.getIds(EntityType.REQUIREMENT_LIBRARY))) {
            builder.or((Predicate)requirement.project.requirementLibrary.id.in(ids));
        }
        if (this.notEmpty(ids = refmap.getIds(EntityType.REQUIREMENT, EntityType.HIGH_LEVEL_REQUIREMENT, EntityType.REQUIREMENT_FOLDER))) {
            QRequirementPathEdge edge = QRequirementPathEdge.requirementPathEdge;
            ExtendedHibernateQuery subq = new ExtendedHibernateQuery();
            ((HibernateQuery)((HibernateQuery)subq.select(Expressions.constant((Object)1)).from((EntityPath)edge)).where((Predicate)edge.ancestorId.in(ids))).where((Predicate)requirement.id.eq((Expression)edge.descendantId));
            BooleanOperation predicate = Expressions.predicate((Operator)Ops.EXISTS, (Expression[])new Expression[]{subq});
            builder.or((Predicate)predicate);
        }
        return builder;
    }

    private BooleanBuilder whereClauseForCampaigns(ScopedEntities refmap) {
        BooleanBuilder builder = new BooleanBuilder();
        QCampaign campaign = QCampaign.campaign;
        QIteration iteration = QIteration.iteration;
        Collection<Long> ids = refmap.getIds(EntityType.PROJECT);
        if (this.notEmpty(ids)) {
            builder.or((Predicate)campaign.project.id.in(ids));
        }
        if (this.notEmpty(ids = refmap.getIds(EntityType.CAMPAIGN_LIBRARY))) {
            builder.or((Predicate)campaign.project.campaignLibrary.id.in(ids));
        }
        if (this.notEmpty(ids = refmap.getIds(EntityType.CAMPAIGN, EntityType.CAMPAIGN_FOLDER, EntityType.SPRINT, EntityType.SPRINT_GROUP))) {
            QCampaignPathEdge edge = QCampaignPathEdge.campaignPathEdge;
            ExtendedHibernateQuery subq = new ExtendedHibernateQuery();
            ((HibernateQuery)((HibernateQuery)subq.select(Expressions.constant((Object)1)).from((EntityPath)edge)).where((Predicate)edge.ancestorId.in(ids))).where((Predicate)campaign.id.eq((Expression)edge.descendantId));
            BooleanOperation predicate = Expressions.predicate((Operator)Ops.EXISTS, (Expression[])new Expression[]{subq});
            builder.or((Predicate)predicate);
        }
        if (this.notEmpty(ids = refmap.getIds(EntityType.ITERATION))) {
            builder.or((Predicate)iteration.id.in(ids));
        }
        return builder;
    }

    private boolean notEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    private static enum JoinableColumns {
        TEST_CASE_ID,
        REQUIREMENT_ID,
        CAMPAIGN_ID,
        ITERATION_ID,
        POSSIBLE_COLUMNS_ONLY;


        static JoinableColumns forScopedType(EntityType type) {
            return switch (type) {
                case EntityType.HIGH_LEVEL_REQUIREMENT, EntityType.REQUIREMENT, EntityType.REQUIREMENT_FOLDER, EntityType.REQUIREMENT_LIBRARY -> REQUIREMENT_ID;
                case EntityType.TEST_CASE, EntityType.TEST_CASE_FOLDER, EntityType.TEST_CASE_LIBRARY -> TEST_CASE_ID;
                case EntityType.CAMPAIGN, EntityType.CAMPAIGN_FOLDER, EntityType.CAMPAIGN_LIBRARY, EntityType.SPRINT, EntityType.SPRINT_GROUP -> CAMPAIGN_ID;
                case EntityType.ITERATION -> ITERATION_ID;
                case EntityType.PROJECT -> POSSIBLE_COLUMNS_ONLY;
                default -> throw new IllegalArgumentException(type.toString() + " is not legal as a chart perimeter.");
            };
        }

        static JoinableColumns forQueriedType(InternalEntityType type) {
            return switch (type) {
                case InternalEntityType.REQUIREMENT, InternalEntityType.REQUIREMENT_VERSION -> REQUIREMENT_ID;
                case InternalEntityType.TEST_CASE -> TEST_CASE_ID;
                case InternalEntityType.CAMPAIGN, InternalEntityType.ITERATION, InternalEntityType.ITEM_TEST_PLAN, InternalEntityType.EXECUTION, InternalEntityType.ISSUE -> CAMPAIGN_ID;
                default -> null;
            };
        }
    }

    private static interface QueriedEntities {
        public Set<JoinableColumns> getPossibleJoinColumns();
    }

    private static final class QueriedEntitiesImpl
    implements QueriedEntities {
        private InternalQueryModel internalQuery;

        QueriedEntitiesImpl(InternalQueryModel internalQuery) {
            this.internalQuery = internalQuery;
        }

        @Override
        public Set<JoinableColumns> getPossibleJoinColumns() {
            HashSet<JoinableColumns> possibles = new HashSet<JoinableColumns>();
            Set<InternalEntityType> types = this.internalQuery.getTargetEntities();
            for (InternalEntityType type : types) {
                JoinableColumns column = JoinableColumns.forQueriedType(type);
                if (column == null) continue;
                possibles.add(column);
            }
            return possibles;
        }
    }

    private static class ScopeUtils {
        private static final Map<EntityType, String> CLASS_NAME_BY_ENTITY = new EnumMap<EntityType, String>(EntityType.class);
        private static final String REQUIREMENT_LIBRARY_NODE_PATH = "org.squashtest.tm.domain.requirement.RequirementLibraryNode";
        private final PermissionEvaluationService permissionService;
        private final EntityManager em;

        static {
            CLASS_NAME_BY_ENTITY.put(EntityType.PROJECT, "org.squashtest.tm.domain.project.Project");
            CLASS_NAME_BY_ENTITY.put(EntityType.TEST_CASE_LIBRARY, "org.squashtest.tm.domain.testcase.TestCaseLibrary");
            CLASS_NAME_BY_ENTITY.put(EntityType.TEST_CASE_FOLDER, "org.squashtest.tm.domain.testcase.TestCaseLibraryNode");
            CLASS_NAME_BY_ENTITY.put(EntityType.TEST_CASE, "org.squashtest.tm.domain.testcase.TestCaseLibraryNode");
            CLASS_NAME_BY_ENTITY.put(EntityType.REQUIREMENT_LIBRARY, "org.squashtest.tm.domain.requirement.RequirementLibrary");
            CLASS_NAME_BY_ENTITY.put(EntityType.REQUIREMENT_FOLDER, REQUIREMENT_LIBRARY_NODE_PATH);
            CLASS_NAME_BY_ENTITY.put(EntityType.REQUIREMENT, REQUIREMENT_LIBRARY_NODE_PATH);
            CLASS_NAME_BY_ENTITY.put(EntityType.HIGH_LEVEL_REQUIREMENT, REQUIREMENT_LIBRARY_NODE_PATH);
            CLASS_NAME_BY_ENTITY.put(EntityType.CAMPAIGN_LIBRARY, "org.squashtest.tm.domain.campaign.CampaignLibrary");
            CLASS_NAME_BY_ENTITY.put(EntityType.CAMPAIGN_FOLDER, "org.squashtest.tm.domain.campaign.CampaignLibraryNode");
            CLASS_NAME_BY_ENTITY.put(EntityType.CAMPAIGN, "org.squashtest.tm.domain.campaign.CampaignLibraryNode");
            CLASS_NAME_BY_ENTITY.put(EntityType.ITERATION, "org.squashtest.tm.domain.campaign.Iteration");
            CLASS_NAME_BY_ENTITY.put(EntityType.SPRINT, "org.squashtest.tm.domain.campaign.Sprint");
            CLASS_NAME_BY_ENTITY.put(EntityType.SPRINT_GROUP, "org.squashtest.tm.domain.campaign.SprintGroup");
        }

        ScopeUtils(EntityManager entityManager, PermissionEvaluationService permService) {
            this.permissionService = permService;
            this.em = entityManager;
        }

        boolean checkPermissions(EntityReference ref) {
            String classname = this.classname(ref);
            Long id = ref.getId();
            return this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ.name(), id, classname);
        }

        QueryColumnPrototype findColumnPrototype(String colName) {
            TypedQuery q = this.em.createQuery("select p from QueryColumnPrototype p where p.label = :label", QueryColumnPrototype.class);
            q.setParameter("label", (Object)colName);
            return (QueryColumnPrototype)q.getSingleResult();
        }

        private String classname(EntityReference ref) {
            String className = CLASS_NAME_BY_ENTITY.get(ref.getType());
            if (className == null) {
                throw new IllegalArgumentException(String.valueOf(ref.getType()) + " is not a valid type for a chart perimeter. Please reconfigure the perimeter of your chart.");
            }
            return className;
        }
    }

    private static interface ScopedEntities {
        public Collection<Long> getIds(EntityType ... var1);

        public Set<JoinableColumns> getRequiredJoinColumns();
    }

    private static final class ScopedEntitiesImpl
    extends EnumMap<EntityType, Collection<Long>>
    implements ScopedEntities {
        private static final long serialVersionUID = -602464647296427399L;

        ScopedEntitiesImpl(List<EntityReference> scope) {
            super(EntityType.class);
            for (EntityReference ref : scope) {
                EntityType type = ref.getType();
                ArrayList<Long> list = (ArrayList<Long>)this.get(type);
                if (list == null) {
                    list = new ArrayList<Long>();
                    this.put(type, list);
                }
                list.add(ref.getId());
            }
        }

        @Override
        public Collection<Long> getIds(EntityType ... types) {
            ArrayList<Long> result = new ArrayList<Long>();
            EntityType[] entityTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                EntityType type = entityTypeArray[n2];
                Collection ids = (Collection)this.get(type);
                if (ids != null) {
                    result.addAll(ids);
                }
                ++n2;
            }
            return result;
        }

        @Override
        public Set<JoinableColumns> getRequiredJoinColumns() {
            HashSet<JoinableColumns> extraJohns = new HashSet<JoinableColumns>();
            for (EntityType type : this.keySet()) {
                extraJohns.add(JoinableColumns.forScopedType(type));
            }
            return extraJohns;
        }
    }
}

