/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.exception.pivotformatimport.CouldNotCreateRequirementDuringImportException;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.HighLevelRequirementExceptionSummary;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementVersionPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.requirement.CategoryChainFixer;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.RequirementPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.RequirementPivotImporterService;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;

@Service
public class RequirementPivotImporterServiceImpl
extends AbstractPivotImport
implements RequirementPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementPivotImporterServiceImpl.class);
    private final RequirementLibraryDao requirementLibraryDao;
    private final RequirementFolderDao requirementFolderDao;
    private final RequirementDao requirementDao;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final AttachmentPivotImportService attachmentPivotImportService;
    private final AdminPivotConverterService adminPivotConverterService;
    private final RequirementPivotConverterService requirementPivotConverterService;
    private final HighLevelRequirementService highLevelRequirementService;
    @PersistenceContext
    private EntityManager entityManager;

    public RequirementPivotImporterServiceImpl(RequirementLibraryDao requirementLibraryDao, RequirementFolderDao requirementFolderDao, RequirementDao requirementDao, PrivateCustomFieldValueService customFieldValueService, AttachmentPivotImportService attachmentPivotImportService, AdminPivotConverterService adminPivotConverterService, RequirementPivotConverterService requirementPivotConverterService, HighLevelRequirementService highLevelRequirementService) {
        super(LOGGER);
        this.requirementLibraryDao = requirementLibraryDao;
        this.requirementFolderDao = requirementFolderDao;
        this.requirementDao = requirementDao;
        this.customFieldValueService = customFieldValueService;
        this.attachmentPivotImportService = attachmentPivotImportService;
        this.adminPivotConverterService = adminPivotConverterService;
        this.requirementPivotConverterService = requirementPivotConverterService;
        this.highLevelRequirementService = highLevelRequirementService;
    }

    @Override
    public void importRequirementsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.REQUIREMENTS, pivotFormatImport, pivotImportMetadata, "requirements", "requirement", this.getRequirementPivotImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<RequirementPivot> getRequirementPivotImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<RequirementPivot>(){

            @Override
            public Class<RequirementPivot> getPivotClazz() {
                return RequirementPivot.class;
            }

            @Override
            public void create(List<RequirementPivot> entities) {
                RequirementPivotImporterServiceImpl.this.createRequirements(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }

            @Override
            public void postCreate() {
                RequirementPivotImporterServiceImpl.this.handleLinksToHighLevelRequirements(pivotImportMetadata);
            }
        };
    }

    private void handleLinksToHighLevelRequirements(PivotImportMetadata pivotImportMetadata) {
        pivotImportMetadata.getHighLevelRequirementLinks().forEach((squashHighLevelReqId, linkedReqPivotIds) -> {
            List<Long> squashLinkedReqIds = linkedReqPivotIds.stream().map(reqPivotId -> pivotImportMetadata.getRequirementIdsMap().get(reqPivotId)).toList();
            HighLevelRequirementExceptionSummary summary = new HighLevelRequirementExceptionSummary();
            this.highLevelRequirementService.bindRequirementsToHighLevelRequirement((Long)squashHighLevelReqId, squashLinkedReqIds, summary);
        });
    }

    private void createRequirements(List<RequirementPivot> requirementPivotList, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        HashMap<RequirementVersion, RequirementVersionPivot> createdRequirementVersions = new HashMap<RequirementVersion, RequirementVersionPivot>();
        this.batchCreateHibernateRequirements(requirementPivotList, projectIdsReferences, pivotImportMetadata, pivotFormatImport, createdRequirementVersions);
        requirementPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void batchCreateHibernateRequirements(List<RequirementPivot> requirementPivotList, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport, Map<RequirementVersion, RequirementVersionPivot> createdRequirementVersions) {
        ArrayList<RequirementPivot> requirementsToImportInLibrary = new ArrayList<RequirementPivot>();
        HashMap<String, List<RequirementPivot>> requirementToImportByFolderIdMap = new HashMap<String, List<RequirementPivot>>();
        HashMap<String, List<RequirementPivot>> requirementToImportByRequirementIdMap = new HashMap<String, List<RequirementPivot>>();
        HashMap<RequirementVersion, Map<Long, RawValue>> requirementCustomFields = new HashMap<RequirementVersion, Map<Long, RawValue>>();
        for (RequirementPivot requirementPivot : requirementPivotList) {
            if (requirementPivot.getParentId() == null) {
                requirementsToImportInLibrary.add(requirementPivot);
                continue;
            }
            if (EntityType.REQUIREMENT_FOLDER.equals((Object)requirementPivot.getParentType())) {
                requirementToImportByFolderIdMap.computeIfAbsent(requirementPivot.getParentId(), k -> new ArrayList()).add(requirementPivot);
                continue;
            }
            requirementToImportByRequirementIdMap.computeIfAbsent(requirementPivot.getParentId(), k -> new ArrayList()).add(requirementPivot);
        }
        this.addRequirementsToLibrary(pivotImportMetadata, projectIdsReferences, requirementsToImportInLibrary, createdRequirementVersions, requirementCustomFields, pivotFormatImport);
        this.addRequirementsToFolders(pivotImportMetadata, requirementToImportByFolderIdMap, createdRequirementVersions, requirementCustomFields, pivotFormatImport);
        this.addRequirementsToRequirements(pivotImportMetadata, requirementToImportByRequirementIdMap, createdRequirementVersions, requirementCustomFields, pivotFormatImport);
        this.handleCustomFieldValues(createdRequirementVersions, requirementCustomFields, pivotFormatImport);
        this.handleAttachmentsAndAddMetadata(createdRequirementVersions, pivotFormatImport, pivotImportMetadata);
    }

    private void addRequirementsToLibrary(PivotImportMetadata pivotImportMetadata, ProjectIdsReferences projectIdsReferences, List<RequirementPivot> requirementsToImportInLibrary, Map<RequirementVersion, RequirementVersionPivot> createdRequirementVersions, Map<RequirementVersion, Map<Long, RawValue>> requirementCustomFields, PivotFormatImport pivotFormatImport) {
        RequirementLibrary library = this.requirementLibraryDao.loadForNodeAddition(projectIdsReferences.getRequirementLibraryId());
        for (RequirementPivot requirementPivot : requirementsToImportInLibrary) {
            this.createAndAddRequirementToEntity(createdRequirementVersions, requirementCustomFields, pivotImportMetadata, pivotFormatImport, requirementPivot, library);
        }
    }

    private void addRequirementsToFolders(PivotImportMetadata pivotImportMetadata, Map<String, List<RequirementPivot>> requirementToImportByFolderIdMap, Map<RequirementVersion, RequirementVersionPivot> createdRequirementVersions, Map<RequirementVersion, Map<Long, RawValue>> requirementCustomFields, PivotFormatImport pivotFormatImport) {
        List<Long> squashFolderIds = requirementToImportByFolderIdMap.keySet().stream().map(parentId -> pivotImportMetadata.getRequirementFoldersIdsMap().get(parentId)).toList();
        Map requirementFolderById = this.requirementFolderDao.loadForNodeAddition(squashFolderIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        requirementToImportByFolderIdMap.forEach((parentId, requirementsToImportInFolder) -> {
            Long squashFolderId = pivotImportMetadata.getRequirementFoldersIdsMap().get(parentId);
            RequirementFolder folder = (RequirementFolder)requirementFolderById.get(squashFolderId);
            for (RequirementPivot requirementPivot : requirementsToImportInFolder) {
                this.createAndAddRequirementToEntity(createdRequirementVersions, requirementCustomFields, pivotImportMetadata, pivotFormatImport, requirementPivot, folder);
            }
        });
    }

    private void addRequirementsToRequirements(PivotImportMetadata pivotImportMetadata, Map<String, List<RequirementPivot>> requirementToImportByRequirementIdMap, Map<RequirementVersion, RequirementVersionPivot> createdRequirementVersions, Map<RequirementVersion, Map<Long, RawValue>> requirementCustomFields, PivotFormatImport pivotFormatImport) {
        List<Long> requirementIds = requirementToImportByRequirementIdMap.keySet().stream().map(parentId -> pivotImportMetadata.getRequirementIdsMap().get(parentId)).toList();
        Map requirementById = this.requirementDao.loadForNodeAddition(requirementIds).stream().collect(Collectors.toMap(RequirementLibraryNode::getId, Function.identity()));
        requirementToImportByRequirementIdMap.forEach((parentId, requirementsToImportInRequirement) -> {
            Long requirementId = pivotImportMetadata.getRequirementIdsMap().get(parentId);
            Requirement requirement = (Requirement)requirementById.get(requirementId);
            for (RequirementPivot requirementPivot : requirementsToImportInRequirement) {
                this.createAndAddRequirementToEntity(createdRequirementVersions, requirementCustomFields, pivotImportMetadata, pivotFormatImport, requirementPivot, requirement);
            }
        });
    }

    private void handleCustomFieldValues(Map<RequirementVersion, RequirementVersionPivot> createdRequirementVersions, Map<RequirementVersion, Map<Long, RawValue>> requirementCustomFields, PivotFormatImport pivotFormatImport) {
        this.customFieldValueService.createAllCustomFieldValues(createdRequirementVersions.keySet(), (GenericProject)pivotFormatImport.getProject());
        this.customFieldValueService.initBatchCustomFieldValues(requirementCustomFields);
    }

    private void handleAttachmentsAndAddMetadata(Map<RequirementVersion, RequirementVersionPivot> createdRequirementVersions, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        for (Map.Entry<RequirementVersion, RequirementVersionPivot> entry : createdRequirementVersions.entrySet()) {
            RequirementVersion requirementVersion = entry.getKey();
            RequirementVersionPivot requirementVersionPivot = entry.getValue();
            pivotImportMetadata.getRequirementVersionIdsMap().put(requirementVersionPivot.getPivotId(), requirementVersion.getId());
            if (requirementVersionPivot.getAttachments().isEmpty()) continue;
            try {
                this.attachmentPivotImportService.addAttachmentsToEntity(requirementVersionPivot.getAttachments(), new AttachmentHolderInfo(requirementVersion.getId(), requirementVersion.getAttachmentList().getId(), EntityType.REQUIREMENT_VERSION, requirementVersionPivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
            }
            catch (IOException e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "requirement", requirementVersionPivot.getName(), requirementVersionPivot.getPivotId(), pivotFormatImport, e);
            }
        }
    }

    private <T> void createAndAddRequirementToEntity(Map<RequirementVersion, RequirementVersionPivot> createdRequirementVersions, Map<RequirementVersion, Map<Long, RawValue>> requirementVersionCustomFields, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport, RequirementPivot requirementPivot, T entity) {
        try {
            if (requirementPivot.getRequirementVersions().isEmpty()) {
                throw new CouldNotCreateRequirementDuringImportException(String.format("No requirement version found for requirement with internal id %s", requirementPivot.getPivotId()));
            }
            Iterator<RequirementVersionPivot> requirementVersionPivotIterator = requirementPivot.getRequirementVersions().iterator();
            RequirementVersionPivot requirementVersionPivot = requirementVersionPivotIterator.next();
            Requirement squashRequirement = this.requirementPivotConverterService.pivotToRequirement(requirementPivot, requirementVersionPivot, pivotImportMetadata);
            this.addCustomFieldToMap(squashRequirement.getCurrentVersion(), requirementVersionPivot, requirementVersionCustomFields, pivotImportMetadata);
            createdRequirementVersions.put(squashRequirement.getCurrentVersion(), requirementVersionPivot);
            if (entity instanceof RequirementLibrary) {
                RequirementLibrary library = (RequirementLibrary)entity;
                library.addContent((LibraryNode)squashRequirement);
            } else if (entity instanceof RequirementFolder) {
                RequirementFolder folder = (RequirementFolder)entity;
                folder.addContent((RequirementLibraryNode)squashRequirement);
            } else if (entity instanceof Requirement) {
                Requirement requirement = (Requirement)entity;
                requirement.addContent(squashRequirement);
            }
            requirementVersionPivotIterator.forEachRemaining(currentVersionPivot -> {
                RequirementVersion requirementVersion = this.requirementPivotConverterService.pivotToRequirementVersion((RequirementVersionPivot)currentVersionPivot, pivotImportMetadata);
                squashRequirement.increaseVersion(requirementVersion);
                Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(currentVersionPivot.getCustomFields(), pivotImportMetadata);
                requirementVersionCustomFields.put(squashRequirement.getCurrentVersion(), customFields);
                this.addCustomFieldToMap(requirementVersion, (RequirementVersionPivot)currentVersionPivot, requirementVersionCustomFields, pivotImportMetadata);
                createdRequirementVersions.put(requirementVersion, (RequirementVersionPivot)currentVersionPivot);
            });
            this.replaceInfoListReferences(squashRequirement);
            this.entityManager.persist((Object)squashRequirement);
            pivotImportMetadata.getRequirementIdsMap().put(requirementPivot.getPivotId(), squashRequirement.getId());
            if (requirementPivot.getIsHighLevelRequirement() && !requirementPivot.getLinkedRequirementsToHighLevel().isEmpty()) {
                pivotImportMetadata.getHighLevelRequirementLinks().put(squashRequirement.getId(), requirementPivot.getLinkedRequirementsToHighLevel());
            }
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "requirement", requirementPivot.getPivotId(), pivotFormatImport, e);
        }
    }

    private void addCustomFieldToMap(RequirementVersion requirementVersion, RequirementVersionPivot requirementVersionPivot, Map<RequirementVersion, Map<Long, RawValue>> requirementVersionCustomFields, PivotImportMetadata pivotImportMetadata) {
        Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(requirementVersionPivot.getCustomFields(), pivotImportMetadata);
        requirementVersionCustomFields.put(requirementVersion, customFields);
    }

    private void replaceInfoListReferences(Requirement requirement) {
        CategoryChainFixer.fix(requirement);
    }
}

