/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipFile;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivotformatimport.CouldNotBindCustomFieldDuringImportException;
import org.squashtest.tm.service.customfield.CustomCustomFieldManagerService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.dto.projectimporter.SquashCustomFieldInfo;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.CustomFieldPivotImporterService;

@Service
public class CustomFieldPivotImporterServiceImpl
extends AbstractPivotImport
implements CustomFieldPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldPivotImporterService.class);
    private final CustomCustomFieldManagerService customFieldManagerService;
    private final CustomFieldBindingModificationService customFieldBindingModificationService;
    private final AdminPivotConverterService adminPivotConverterService;
    private final CustomFieldBindingFinderService customFieldBindingFinderService;
    @PersistenceContext
    private EntityManager entityManager;

    public CustomFieldPivotImporterServiceImpl(CustomCustomFieldManagerService customFieldManagerService, CustomFieldBindingModificationService customFieldBindingModificationService, AdminPivotConverterService adminPivotConverterService, CustomFieldBindingFinderService customFieldBindingFinderService) {
        super(LOGGER);
        this.customFieldManagerService = customFieldManagerService;
        this.customFieldBindingModificationService = customFieldBindingModificationService;
        this.adminPivotConverterService = adminPivotConverterService;
        this.customFieldBindingFinderService = customFieldBindingFinderService;
    }

    @Override
    public void importCustomFieldsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.CUSTOM_FIELDS, pivotFormatImport, pivotImportMetadata, "custom fields", "custom field", this.getCustomFieldImportStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<CustomFieldPivot> getCustomFieldImportStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<CustomFieldPivot>(){

            @Override
            public Class<CustomFieldPivot> getPivotClazz() {
                return CustomFieldPivot.class;
            }

            @Override
            public void create(List<CustomFieldPivot> entities) {
                List<CustomFieldPivot> newCustomFieldPivot = CustomFieldPivotImporterServiceImpl.this.getNewCustomFieldPivots(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                CustomFieldPivotImporterServiceImpl.this.createCustomFields(newCustomFieldPivot, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private List<CustomFieldPivot> getNewCustomFieldPivots(List<CustomFieldPivot> customFieldPivots, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        List<String> customFieldCodes = customFieldPivots.stream().map(CustomFieldPivot::getCode).toList();
        List<CustomField> existingCustomFields = this.customFieldManagerService.findByCodes(customFieldCodes);
        ArrayList<CustomFieldPivot> newCustomFieldPivots = new ArrayList<CustomFieldPivot>();
        for (CustomFieldPivot customFieldPivot : customFieldPivots) {
            CustomField existingCustomField = existingCustomFields.stream().filter(customField -> customField.getCode().equals(customFieldPivot.getCode()) && customField.getInputType().equals((Object)customFieldPivot.getInputType())).findFirst().orElse(null);
            if (Objects.nonNull(existingCustomField)) {
                this.handleExistingCustomField(pivotImportMetadata, projectIdsReferences, customFieldPivot, existingCustomField, pivotFormatImport);
                continue;
            }
            newCustomFieldPivots.add(customFieldPivot);
        }
        return newCustomFieldPivots;
    }

    private void handleExistingCustomField(PivotImportMetadata pivotImportMetadata, ProjectIdsReferences projectIdsReferences, CustomFieldPivot customFieldPivot, CustomField existingCustomField, PivotFormatImport pivotFormatImport) {
        CustomFieldPivotImporterServiceImpl.logCustomFieldAlreadyExistsInSquash(customFieldPivot, pivotFormatImport);
        pivotImportMetadata.getCustomFieldIdsMap().put(customFieldPivot.getPivotId(), new SquashCustomFieldInfo(existingCustomField.getId(), existingCustomField.getInputType()));
        this.addCustomFieldBindingsToProject(existingCustomField, projectIdsReferences, customFieldPivot.getBoundEntities(), pivotFormatImport);
    }

    private static void logCustomFieldAlreadyExistsInSquash(CustomFieldPivot customFieldPivot, PivotFormatImport pivotFormatImport) {
        LOGGER.info("CustomFieldPivotImporterService - Import id {} - Custom field \"{}\" with internal id {} already exists in Squash. Import will use the existing custom field for entity bindings", new Object[]{pivotFormatImport.getId(), customFieldPivot.getName(), customFieldPivot.getPivotId()});
    }

    private void createCustomFields(List<CustomFieldPivot> customFieldPivotList, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (CustomFieldPivot customFieldPivot : customFieldPivotList) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "custom field", customFieldPivot.getPivotId(), pivotFormatImport);
            try {
                CustomField convertedCustomField = this.adminPivotConverterService.pivotToCustomField(customFieldPivot);
                CustomField customField = this.customFieldManagerService.persistUnsecured(convertedCustomField);
                this.addCustomFieldBindingsToProject(customField, projectIdsReferences, customFieldPivot.getBoundEntities(), pivotFormatImport);
                pivotImportMetadata.getCustomFieldIdsMap().put(customFieldPivot.getPivotId(), new SquashCustomFieldInfo(customField.getId(), customField.getInputType()));
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "custom field", customFieldPivot.getName(), customFieldPivot.getPivotId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "custom field", customFieldPivot.getName(), customFieldPivot.getPivotId(), pivotFormatImport, e);
            }
        }
        customFieldPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addCustomFieldBindingsToProject(CustomField customField, ProjectIdsReferences projectIdsReferences, List<BindableEntity> boundEntities, PivotFormatImport pivotFormatImport) {
        CustomFieldPivotImporterServiceImpl.logAddCustomFieldBindings(customField, projectIdsReferences, pivotFormatImport);
        List<CustomFieldBinding> existingBindings = this.customFieldBindingFinderService.findCustomFieldsForGenericProject(projectIdsReferences.getId());
        boundEntities.forEach(boundEntity -> {
            try {
                boolean bindingAlreadyExists = this.checkIfBindingAlreadyExists(existingBindings, customField, (BindableEntity)boundEntity);
                if (bindingAlreadyExists) {
                    LOGGER.info("Import Id: {} - Project id: {} - Custom field binding already exists for entity {}", new Object[]{pivotFormatImport.getId(), projectIdsReferences.getId(), boundEntity});
                    return;
                }
                this.customFieldBindingModificationService.addNewCustomFieldBindingUnsecured(projectIdsReferences.getId(), (BindableEntity)boundEntity, customField.getId());
            }
            catch (Exception e) {
                String message = String.format("Import Id: %s - Project id: %s - Failed to add custom field binding to entity \"%s\" for the custom field \"%s\"", pivotFormatImport.getId(), projectIdsReferences.getId(), boundEntity, customField.getName());
                LOGGER.error(message, new Object[0]);
                throw new CouldNotBindCustomFieldDuringImportException(message, (Throwable)e);
            }
        });
    }

    private boolean checkIfBindingAlreadyExists(List<CustomFieldBinding> existingBindings, CustomField customField, BindableEntity boundEntity) {
        return existingBindings.stream().anyMatch(binding -> binding.getBoundEntity().equals((Object)boundEntity) && binding.getCustomField().equals(customField));
    }

    private static void logAddCustomFieldBindings(CustomField customField, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) {
        LOGGER.info("Import Id: {} - Adding custom field bindings to project (id: {}) for the custom field \"{}\"", new Object[]{pivotFormatImport.getId(), projectIdsReferences.getId(), customField.getName()});
    }
}

