/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.converters;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.requirementworkspace.RequirementVersionPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.pivot.converters.RequirementPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.RequirementPivotDao;
import org.squashtest.tm.service.plugin.PluginFinderService;

@Service
public class RequirementPivotConverterServiceImpl
implements RequirementPivotConverterService {
    private final PluginFinderService pluginFinderService;

    public RequirementPivotConverterServiceImpl(PluginFinderService pluginFinderService) {
        this.pluginFinderService = pluginFinderService;
    }

    @Override
    public Requirement pivotToRequirement(RequirementPivot requirementPivot, RequirementVersionPivot requirementVersionPivot, PivotImportMetadata pivotImportMetadata) {
        if (requirementPivot.getIsHighLevelRequirement()) {
            if (!this.pluginFinderService.isPremiumPluginInstalled()) {
                throw new UnsupportedOperationException("A dedicated plugin is required to create high level requirements");
            }
            return new HighLevelRequirement(this.pivotToRequirementVersion(requirementVersionPivot, pivotImportMetadata));
        }
        return new Requirement(this.pivotToRequirementVersion(requirementVersionPivot, pivotImportMetadata));
    }

    @Override
    public RequirementVersion pivotToRequirementVersion(RequirementVersionPivot requirementVersionPivot, PivotImportMetadata pivotImportMetadata) {
        this.updateDefaultRequirementVersionPivot(requirementVersionPivot);
        return this.pivotToRequirementVersion(requirementVersionPivot, new RequirementVersion(), pivotImportMetadata);
    }

    private void updateDefaultRequirementVersionPivot(RequirementVersionPivot requirementVersionPivot) {
        this.updateNullValueWithDefaultValues(requirementVersionPivot);
    }

    private RequirementVersion pivotToRequirementVersion(RequirementVersionPivot requirementVersionPivot, RequirementVersion requirementVersion, PivotImportMetadata pivotImportMetadata) {
        requirementVersion.setName(requirementVersionPivot.getName());
        requirementVersion.setDescription(requirementVersionPivot.getDescription());
        requirementVersion.setCriticality(requirementVersionPivot.getCriticality());
        if (Objects.nonNull(requirementVersionPivot.getCategoryCode()) && pivotImportMetadata.getPivotOptions().isImportInfoList()) {
            requirementVersion.setCategory((InfoListItem)new ListItemReference(requirementVersionPivot.getCategoryCode()));
        }
        requirementVersion.setReference(requirementVersionPivot.getReference());
        requirementVersion.updateStatusWithoutCheck(requirementVersionPivot.getStatus());
        return requirementVersion;
    }

    private void updateNullValueWithDefaultValues(RequirementVersionPivot requirementVersionPivot) {
        if (Objects.isNull(requirementVersionPivot.getReference())) {
            requirementVersionPivot.setReference("");
        }
        if (Objects.isNull(requirementVersionPivot.getCriticality())) {
            requirementVersionPivot.setCriticality(RequirementCriticality.UNDEFINED);
        }
        if (Objects.isNull(requirementVersionPivot.getStatus())) {
            requirementVersionPivot.setStatus(RequirementStatus.WORK_IN_PROGRESS);
        }
    }

    @Override
    public RequirementPivot requirementRecordToRequirementPivot(Record record) {
        Long parentId;
        RequirementPivot requirementPivot = new RequirementPivot();
        requirementPivot.setPivotId((Long)record.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID));
        requirementPivot.setIsHighLevelRequirement((Boolean)record.get(RequirementPivotDao.IS_HIGH_LEVEL));
        String linkedReqToHL = (String)record.get(RequirementPivotDao.RLN_ID_LINKED_HIGH_LEVEL);
        if (Objects.nonNull(linkedReqToHL)) {
            List<String> linkedReqToHLList = Arrays.stream(((String)record.get(RequirementPivotDao.RLN_ID_LINKED_HIGH_LEVEL)).split(",")).map(id -> String.format("%s%s", requirementPivot.getBasePivotId(), id)).toList();
            requirementPivot.getLinkedRequirementsToHighLevel().addAll(linkedReqToHLList);
        }
        if (Objects.isNull(parentId = (Long)record.get((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID))) {
            requirementPivot.setParentType(EntityType.REQUIREMENT_LIBRARY);
        } else {
            boolean isFolder = (Boolean)record.get(RequirementPivotDao.IS_FOLDER);
            requirementPivot.setParentId((Long)record.get((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID), isFolder);
            if (isFolder) {
                requirementPivot.setParentType(EntityType.REQUIREMENT_FOLDER);
            } else {
                requirementPivot.setParentType(EntityType.REQUIREMENT);
            }
        }
        return requirementPivot;
    }

    @Override
    public RequirementVersionPivot requirementVersionRecordToRequirementVersionPivot(Record record) {
        RequirementVersionPivot requirementVersionPivot = new RequirementVersionPivot();
        requirementVersionPivot.setPivotId((Long)record.get((Field)Tables.REQUIREMENT_VERSION.RES_ID));
        requirementVersionPivot.setName((String)record.get((Field)Tables.RESOURCE.NAME));
        requirementVersionPivot.setDescription((String)record.get((Field)Tables.RESOURCE.DESCRIPTION));
        requirementVersionPivot.setReference((String)record.get((Field)Tables.REQUIREMENT_VERSION.REFERENCE));
        requirementVersionPivot.setCategoryCode((String)record.get((Field)Tables.INFO_LIST_ITEM.CODE));
        requirementVersionPivot.setStatus(RequirementStatus.valueOf((String)((String)record.get((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS))));
        requirementVersionPivot.setCriticality(RequirementCriticality.valueOf((String)((String)record.get((Field)Tables.REQUIREMENT_VERSION.CRITICALITY))));
        return requirementVersionPivot;
    }
}

