/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.library.WhichNodeVisitor;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.library.CannotMoveInHimselfException;
import org.squashtest.tm.service.internal.library.PasteOperation;
import org.squashtest.tm.service.internal.library.TreeNodeUpdater;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.CampaignLibraryDao;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.LibraryDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.RequirementLibraryDao;
import org.squashtest.tm.service.internal.repository.SprintGroupDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.SecurityCheckableObject;

@Component
@Scope(value="prototype")
public class FirstLayerTreeNodeMover
implements PasteOperation,
InitializingBean {
    @Inject
    @Qualifier(value="squashtest.tm.repository.RequirementLibraryNodeDao")
    private LibraryNodeDao<RequirementLibraryNode<Resource>> requirementLibraryNodeDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao")
    private LibraryNodeDao<TestCaseLibraryNode> testCaseLibraryNodeDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.CampaignLibraryNodeDao")
    private LibraryNodeDao<CampaignLibraryNode> campaignLibraryNodeDao;
    @Inject
    private RequirementFolderDao requirementFolderDao;
    @Inject
    private TestCaseFolderDao testCaseFolderDao;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private CampaignFolderDao campaignFolderDao;
    @Inject
    private RequirementLibraryDao requirementLibraryDao;
    @Inject
    private TestCaseLibraryDao testCaseLibraryDao;
    @Inject
    private TreeNodeUpdater treeNodeUpdater;
    @Inject
    private CampaignLibraryDao campaignLibraryDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private SprintGroupDao sprintGroupDao;
    private TreeNode movedNode;
    private NodeContainer<? extends TreeNode> destination;
    private boolean projectChanged = false;
    private WhichNodeVisitor whichVisitor = new WhichNodeVisitor();
    private Map<EntityType, NodeCollaborators> collaboratorsByType = new EnumMap<EntityType, NodeCollaborators>(EntityType.class);
    private List<Long> movedTcIds = new ArrayList<Long>();
    private List<Long> movedReqVersionIds = new ArrayList<Long>();

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    public void init() {
        NodeCollaborators nc = new NodeCollaborators(this.campaignLibraryDao, this.campaignFolderDao, this.campaignLibraryNodeDao);
        this.collaboratorsByType.put(EntityType.CAMPAIGN_FOLDER, nc);
        this.collaboratorsByType.put(EntityType.CAMPAIGN, nc);
        this.collaboratorsByType.put(EntityType.SPRINT, nc);
        this.collaboratorsByType.put(EntityType.SPRINT_GROUP, nc);
        nc = new NodeCollaborators(this.requirementLibraryDao, this.requirementFolderDao, this.requirementLibraryNodeDao);
        this.collaboratorsByType.put(EntityType.REQUIREMENT_FOLDER, nc);
        this.collaboratorsByType.put(EntityType.REQUIREMENT, nc);
        nc = new NodeCollaborators(this.testCaseLibraryDao, this.testCaseFolderDao, this.testCaseLibraryNodeDao);
        this.collaboratorsByType.put(EntityType.TEST_CASE_FOLDER, nc);
        this.collaboratorsByType.put(EntityType.TEST_CASE, nc);
        this.collaboratorsByType = Collections.unmodifiableMap(this.collaboratorsByType);
    }

    @Override
    public TreeNode performOperation(TreeNode toMove, NodeContainer<TreeNode> destination, Integer position) {
        this.destination = destination;
        this.movedNode = null;
        this.checkNotMovedInHimself(toMove);
        Project sourceProject = toMove.getProject();
        GenericProject destinationProject = destination.getProject();
        this.projectChanged = this.changedProject(sourceProject, destinationProject);
        this.processNodes(toMove, position);
        if (this.projectChanged) {
            this.movedNode.accept((NodeVisitor)this.treeNodeUpdater);
        }
        return this.movedNode;
    }

    @Override
    public TreeNode performOperationFromReqToTc(TreeNode toMove, TreeNode transformed, NodeContainer<TreeNode> destination, Integer position) {
        this.destination = destination;
        this.movedNode = null;
        this.processNodesFRomReqToTc(transformed, position);
        this.movedNode = transformed;
        this.movedNode.accept((NodeVisitor)this.treeNodeUpdater);
        this.projectChanged = true;
        return this.movedNode;
    }

    @Override
    public boolean isOkToGoDeeper() {
        return this.projectChanged;
    }

    protected void processNodes(TreeNode toMove, Integer position) {
        EntityType visitedType = this.whichVisitor.getTypeOf(toMove);
        switch (visitedType) {
            case CAMPAIGN: 
            case CAMPAIGN_FOLDER: 
            case REQUIREMENT_FOLDER: 
            case SPRINT: 
            case SPRINT_GROUP: 
            case TEST_CASE: 
            case TEST_CASE_FOLDER: {
                NodeCollaborators nc = this.collaboratorsByType.get(visitedType);
                this.visitLibraryNode((LibraryNode)toMove, nc.libraryDao, nc.folderDao, position);
                this.movedTcIds.add(toMove.getId());
                break;
            }
            case HIGH_LEVEL_REQUIREMENT: 
            case REQUIREMENT: {
                this.visitWhenNodeIsRequirement((Requirement)toMove, position);
                List requirementVersions = ((Requirement)toMove).getRequirementVersions();
                this.fillingReqVersionIds(requirementVersions);
                this.updateHighLevelRequirementReference((Requirement)toMove);
                break;
            }
            case ITERATION: 
            case TEST_SUITE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Libraries cannot be copied nor moved !");
            }
        }
    }

    protected void processNodesFRomReqToTc(TreeNode toMove, Integer position) {
        this.movedTcIds.add(toMove.getId());
    }

    private void fillingReqVersionIds(List<RequirementVersion> requirementVersions) {
        ArrayList<Long> reqVersionIds = new ArrayList<Long>();
        for (RequirementVersion requirementVersion : requirementVersions) {
            reqVersionIds.add(requirementVersion.getId());
        }
        this.movedReqVersionIds.addAll(reqVersionIds);
    }

    private <LN extends LibraryNode> void visitLibraryNode(LN node, LibraryDao<?, ?> libraryDao, FolderDao<?, ?> folderDao, Integer position) {
        NodeContainer<LN> parent = this.findFolderOrSprintGroupOrLibraryParent(node, libraryDao, folderDao);
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(this.destination, Permissions.CREATE.name()), new SecurityCheckableObject(parent, Permissions.DELETE.name()), new SecurityCheckableObject(node, Permissions.READ.name()));
        node.notifyAssociatedWithProject((Project)this.destination.getProject());
        this.moveNode((TreeNode)node, (NodeContainer)this.destination, (NodeContainer)parent, position);
    }

    private <LN extends LibraryNode> void visitWhenNodeIsRequirement(Requirement node, Integer position) {
        Requirement parent = this.findFolderOrSprintGroupOrLibraryParent(node, this.requirementLibraryDao, this.requirementFolderDao);
        if (parent == null) {
            parent = this.requirementDao.findByContent(node);
        }
        this.permissionEvaluationService.checkPermission(new SecurityCheckableObject(this.destination, Permissions.CREATE.name()), new SecurityCheckableObject(parent, Permissions.DELETE.name()), new SecurityCheckableObject(node, Permissions.READ.name()));
        node.notifyAssociatedWithProject((Project)this.destination.getProject());
        this.moveNode((TreeNode)node, (NodeContainer)this.destination, (NodeContainer)parent, position);
    }

    private void updateHighLevelRequirementReference(Requirement requirement) {
        Long parentReqId = this.requirementDao.findRequirementAncestorId(requirement.getId());
        if (parentReqId != null && !requirement.isHighLevel()) {
            this.updateHighLvlReqReferenceWithExistingAncestor(requirement, parentReqId);
        }
    }

    private void updateHighLvlReqReferenceWithExistingAncestor(Requirement requirement, Long parentReqId) {
        Requirement parent = (Requirement)this.requirementDao.findById(parentReqId);
        if (parent != null) {
            this.updateHighLvlReqReferenceWithReqAncestor(parent, requirement);
        }
    }

    private void updateHighLvlReqReferenceWithReqAncestor(Requirement parent, Requirement requirement) {
        if (parent.isHighLevel()) {
            requirement.setHighLevelRequirement((HighLevelRequirement)parent);
        } else {
            requirement.setHighLevelRequirement(parent.getHighLevelRequirement());
        }
        requirement.getContent().forEach(child -> child.setHighLevelRequirement(requirement.getHighLevelRequirement()));
    }

    private <LN extends LibraryNode> NodeContainer<LN> findFolderOrSprintGroupOrLibraryParent(LN node, LibraryDao libraryDao, FolderDao folderDao) {
        Object parentLib = libraryDao.findByRootContent(node);
        if (parentLib != null) {
            return parentLib;
        }
        Object parentFolder = folderDao.findByContent(node);
        if (parentFolder != null) {
            return parentFolder;
        }
        EntityType visitedType = this.whichVisitor.getTypeOf(node);
        if (visitedType.equals((Object)EntityType.SPRINT_GROUP) || visitedType.equals((Object)EntityType.SPRINT) || visitedType.equals((Object)EntityType.CAMPAIGN_FOLDER)) {
            return this.sprintGroupDao.findByContent(node);
        }
        return null;
    }

    private <TN extends TreeNode> void moveNode(TN toMove, NodeContainer<TN> destination, NodeContainer<TN> toMoveParent, Integer position) {
        this.requirementDao.flush();
        toMoveParent.removeContent(toMove);
        this.requirementDao.flush();
        if (position != null) {
            destination.addContent(toMove, position.intValue());
        } else {
            destination.addContent(toMove);
        }
        this.movedNode = toMove;
    }

    private boolean changedProject(Project sourceProject, GenericProject destinationProject) {
        return sourceProject != null && destinationProject != null && !sourceProject.getId().equals(destinationProject.getId());
    }

    private void checkNotMovedInHimself(TreeNode toMove) {
        LibraryNodeDao<?> lnDao;
        Long toMoveId = ((LibraryNode)toMove).getId();
        Long destinationId = this.destination.getId();
        if (toMove.equals(this.destination)) {
            throw new CannotMoveInHimselfException();
        }
        EntityType destType = this.whichVisitor.getTypeOf(this.destination);
        switch (destType) {
            case CAMPAIGN: 
            case CAMPAIGN_FOLDER: 
            case REQUIREMENT: 
            case REQUIREMENT_FOLDER: 
            case TEST_CASE_FOLDER: {
                lnDao = this.collaboratorsByType.get((Object)destType).nodeDao;
                break;
            }
            default: {
                return;
            }
        }
        List<Long> hierarchyIds = lnDao.getParentsIds(destinationId);
        for (Long id : hierarchyIds) {
            if (!id.equals(toMoveId)) continue;
            throw new CannotMoveInHimselfException();
        }
    }

    private static final class NodeCollaborators {
        private final LibraryDao<?, ?> libraryDao;
        private final FolderDao<?, ?> folderDao;
        private final LibraryNodeDao<?> nodeDao;

        private NodeCollaborators(LibraryDao<?, ?> libraryDao, FolderDao<?, ?> folderDao, LibraryNodeDao<?> nodeDao) {
            this.libraryDao = libraryDao;
            this.folderDao = folderDao;
            this.nodeDao = nodeDao;
        }
    }
}

