/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableLike;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractExecutionDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;

public class JdbcTestPlanItemDeletionHandler
extends AbstractExecutionDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcTestPlanItemDeletionHandler.class);
    private final CustomTestSuiteModificationService testSuiteModificationService;
    private final Collection<Long> testPlanItemIds;

    public JdbcTestPlanItemDeletionHandler(Collection<Long> testPlanItemIds, DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, CustomTestSuiteModificationService testSuiteModificationService, String operationId) {
        super(dslContext, entityManager, attachmentRepository, reorderHelper, operationId);
        this.testPlanItemIds = testPlanItemIds;
        this.testSuiteModificationService = testSuiteModificationService;
    }

    private List<TestSuite> loadTestSuites(List<Long> testSuiteIds) {
        return this.entityManager.createQuery("select suite from TestSuite suite\nwhere suite.id in :ids\n", TestSuite.class).setParameter("ids", testSuiteIds).getResultList();
    }

    @Override
    protected Condition getPredicate() {
        return Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(this.testPlanItemIds);
    }

    @Override
    protected Table<Record> joinToExecution() {
        return Tables.TEST_PLAN_ITEM.innerJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID));
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public void deleteTestPlanItems() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.performDeletions();
        this.reorderTestPlans();
        this.reorderTestSuites();
        this.cleanWorkingTable();
        this.logEndProcess();
    }

    private void reorderTestSuites() {
        List<Long> testSuiteIds = this.workingTables.selectIds(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID);
        if (testSuiteIds.isEmpty()) {
            return;
        }
        this.reorderHelper.reorder((Collection<Long>)testSuiteIds, Tables.TEST_SUITE_TEST_PLAN_ITEM, (Field<Long>)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, (Field<Long>)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID, (Field<Integer>)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER);
        List<TestSuite> testSuites = this.loadTestSuites(testSuiteIds);
        this.testSuiteModificationService.updateExecutionStatus(testSuites);
    }

    private void reorderTestPlans() {
        List<Long> testPlanIds = this.workingTables.selectIds(Tables.TEST_PLAN.TEST_PLAN_ID);
        if (testPlanIds.isEmpty()) {
            return;
        }
        this.reorderHelper.reorder(testPlanIds, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (Field<Long>)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID, (Field<Integer>)Tables.TEST_PLAN_ITEM.ITEM_ORDER);
    }

    private void logEndProcess() {
        LOGGER.info(String.format("Deleted test plan items %s. Time elapsed %s", this.testPlanItemIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
    }

    private void performDeletions() {
        this.performExecutionDeletions();
        this.deleteFailureDetails();
        this.performTestPlanItemDeletion();
        this.deleteAttachmentLists();
        this.deleteCustomFieldValues();
    }

    private void deleteFailureDetails() {
        this.workingTables.delete(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.FAILURE_DETAIL.TEST_PLAN_ITEM_ID);
        this.logDelete((Table<?>)Tables.FAILURE_DETAIL);
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.storeExecutionsToDeleteIntoWorkingTable();
        this.addTestPlanItems();
        this.addSessionOverview();
        this.addTestPlans();
        this.addTestSuites();
        this.addCustomFieldValues();
        this.addAttachmentList();
    }

    private void addTestPlans() {
        this.workingTables.addEntity(Tables.TEST_PLAN.TEST_PLAN_ID, () -> this.makeSelectDistinctClause(Tables.TEST_PLAN.TEST_PLAN_ID).from((TableLike)Tables.TEST_PLAN_ITEM).join((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).where(this.getPredicate()));
    }

    private void addTestSuites() {
        this.workingTables.addEntity(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID, () -> this.makeSelectDistinctClause(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID).from((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.in(this.testPlanItemIds)));
    }

    private void addCustomFieldValues() {
        this.workingTables.addEntity(Tables.CUSTOM_FIELD_VALUE.CFV_ID, this::selectExecutionCustomFieldValues);
    }

    private void addAttachmentList() {
        this.workingTables.addEntity(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, () -> this.selectExecutionAttachmentLists().union(this.makeSelectAttachmentList(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID)));
    }

    private void performTestPlanItemDeletion() {
        this.workingTables.delete(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID);
        this.workingTables.delete(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID);
        this.workingTables.delete(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID);
        this.logDelete((Table<?>)Tables.TEST_PLAN_ITEM);
    }

    private void addSessionOverview() {
        this.workingTables.addEntity(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, () -> this.makeSelectJoin(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.OVERVIEW_ID).where(Tables.TEST_PLAN_ITEM.OVERVIEW_ID.isNotNull()));
    }

    private void addTestPlanItems() {
        this.workingTables.addEntity(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, () -> this.makeSelectClause(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.TEST_PLAN_ITEM).where(this.getPredicate()));
    }

    private void logStartProcess() {
        LOGGER.debug(String.format("Init deletion process of test plan items %s. Operation:  %s", this.testPlanItemIds, this.operationId), new Object[0]);
    }
}

