/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.service.internal.deletion.RequirementDeletionNode;

public final class LockedRequirementNodeInferenceTree {
    private final Map<Long, RequirementDeletionNode> nodes = new HashMap<Long, RequirementDeletionNode>();
    private final List<Long> folderSources = new ArrayList<Long>();
    private final List<Long> requirementSources = new ArrayList<Long>();

    public LockedRequirementNodeInferenceTree(List<RequirementDeletionNode> nodes) {
        for (RequirementDeletionNode node : nodes) {
            this.nodes.put(node.getId(), node);
            if (EntityType.REQUIREMENT_FOLDER.equals((Object)node.getType())) {
                this.folderSources.add(node.getId());
                continue;
            }
            this.requirementSources.add(node.getId());
        }
    }

    public void addFolderContents(Map<Long, List<EntityReference>> contents) {
        for (Long folderId : this.folderSources) {
            RequirementDeletionNode folder = this.nodes.get(folderId);
            this.processChildren(contents, folder);
        }
    }

    private void processChildren(Map<Long, List<EntityReference>> childrenByParentId, RequirementDeletionNode parent) {
        List children = childrenByParentId.getOrDefault(parent.getId(), Collections.emptyList());
        for (EntityReference child : children) {
            RequirementDeletionNode node = new RequirementDeletionNode(child.getId(), parent, child.getType());
            this.nodes.put(child.getId(), node);
            this.processChildren(childrenByParentId, node);
        }
    }

    public void markLockedNodes(List<Long> lockedNodeIds) {
        for (Long lockedNodeId : lockedNodeIds) {
            RequirementDeletionNode node = this.nodes.get(lockedNodeId);
            if (node == null) continue;
            node.notDeletable();
        }
    }

    public List<Long> collectKeys() {
        return this.nodes.keySet().stream().toList();
    }

    public List<Long> collectDeletableIds() {
        return this.nodes.values().stream().filter(RequirementDeletionNode::isDeletable).map(RequirementDeletionNode::getId).toList();
    }

    public List<Long> collectLockedRequirementIds() {
        return this.nodes.values().stream().filter(node -> !node.isDeletable() && EntityType.REQUIREMENT.equals((Object)node.getType())).map(RequirementDeletionNode::getId).toList();
    }

    public Map<RequirementDeletionNode, List<Long>> identifyNewParentForOrphans(Map<Long, List<Long>> targetRequirementContents) {
        HashMap<RequirementDeletionNode, List<Long>> childrenByNewParent = new HashMap<RequirementDeletionNode, List<Long>>();
        targetRequirementContents.forEach((parentId, childrenIds) -> {
            boolean bl = childrenByNewParent.computeIfAbsent(this.nodes.get(parentId).getParent(), k -> new ArrayList()).addAll(childrenIds);
        });
        this.nodes.values().stream().filter(RequirementDeletionNode::isOrphanRequirement).forEach(orphan -> {
            RequirementDeletionNode newParent = orphan.findFirstNonDeletableAncestor();
            childrenByNewParent.computeIfAbsent(newParent, k -> new ArrayList()).add(orphan.getId());
        });
        return childrenByNewParent;
    }

    public List<Long> getRequirementSources() {
        return this.requirementSources;
    }

    public List<Long> getFolderSources() {
        return this.folderSources;
    }
}

