/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.actionword;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bdd.ActionWord;
import org.squashtest.tm.domain.bdd.ActionWordParameter;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.service.actionword.ActionWordLibraryNodeService;
import org.squashtest.tm.service.internal.actionword.ActionWordArranger;
import org.squashtest.tm.service.internal.repository.ActionWordDao;
import org.squashtest.tm.service.internal.repository.KeywordTestStepDao;

@Component
public class ActionWordArrangerImpl
implements ActionWordArranger {
    @Inject
    private ActionWordDao actionWordDao;
    @Inject
    private KeywordTestStepDao keywordTestStepDao;
    @Inject
    private ActionWordLibraryNodeService actionWordLibraryNodeService;

    @Override
    public void arrangeActionWordsBeforeProjectDeleting(Long projectId) {
        Map actionsWordsWithSubstitute = this.actionWordDao.findAllWithDuplicateTokenByProjectId(projectId);
        this.replaceInEachBySubstitute(actionsWordsWithSubstitute);
        Map actionWordsToMove = this.actionWordDao.findAllWithoutDuplicateTokenByProjectId(projectId);
        if (!actionWordsToMove.isEmpty()) {
            this.actionWordLibraryNodeService.moveNodes(new ArrayList<Long>(actionWordsToMove.keySet()), (Long)Collections.min(actionWordsToMove.values()));
        }
    }

    private void replaceInEachBySubstitute(Map<Long, Long> actionsWordsWithSubstitute) {
        actionsWordsWithSubstitute.forEach((key, value) -> {
            Collection<KeywordTestStep> keywordTestSteps = this.keywordTestStepDao.findByActionWord((Long)key);
            ActionWord substitute = (ActionWord)this.actionWordDao.getReferenceById(value);
            keywordTestSteps.forEach(keywordTestStep -> {
                keywordTestStep.setActionWord(substitute);
                this.updateActionWordParams((KeywordTestStep)keywordTestStep, substitute);
            });
        });
    }

    private void updateActionWordParams(KeywordTestStep targetKeywordTestStep, ActionWord substitute) {
        List parameterValues = targetKeywordTestStep.getParamValues();
        List actionWordParameters = substitute.getActionWordParams();
        parameterValues.forEach(parameterValue -> {
            String parameterValueName = parameterValue.getActionWordParam().getName();
            ActionWordParameter actionWordParameter = actionWordParameters.stream().filter(parameter -> parameter.getName().equals(parameterValueName)).toList().get(0);
            parameterValue.setActionWordParam(actionWordParameter);
        });
    }
}

