/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.environmentvariable.EVBindableEntity;
import org.squashtest.tm.domain.environmentvariable.EVInputType;
import org.squashtest.tm.domain.environmentvariable.EnvironmentVariable;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.EnvironmentVariableBinding;
import org.squashtest.tm.service.internal.display.dto.BoundEnvironmentVariableDto;
import org.squashtest.tm.service.internal.repository.CustomEnvironmentVariableBindingDao;

@Repository
public class CustomEnvironmentVariableBindingDaoImpl
implements CustomEnvironmentVariableBindingDao {
    @Inject
    private DSLContext dsl;

    @Override
    public List<Long> findAllBindingIdsByEvIdsAndEntityIdType(List<Long> evIds, Long entityId, EVBindableEntity entityType) {
        return this.dsl.select((SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.EVB_ID).from((TableLike)Tables.ENVIRONMENT_VARIABLE_BINDING).where(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_ID.eq((Object)entityId).and(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_TYPE.eq((Object)entityType.name())).and(Tables.ENVIRONMENT_VARIABLE_BINDING.EV_ID.in(evIds))).fetchInto(Long.class);
    }

    @Override
    public List<BoundEnvironmentVariableDto> findAllBoundEnvironmentVariables(Long entityId, EVBindableEntity entityType) {
        Field isInterpretedField = DSL.field((Condition)Tables.ENVIRONMENT_VARIABLE.INPUT_TYPE.eq((Object)EVInputType.INTERPRETED_TEXT.name())).as("IS_INTERPRETED");
        return this.dsl.select((SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.EV_ID.as("ID"), (SelectField)Tables.ENVIRONMENT_VARIABLE.NAME, (SelectField)Tables.ENVIRONMENT_VARIABLE.INPUT_TYPE, (SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.EVB_ID.as("BINDING_ID"), (SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.VALUE, (SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_TYPE.as("EV_BINDABLE_ENTITY"), (SelectField)isInterpretedField).from((TableLike)Tables.ENVIRONMENT_VARIABLE_BINDING).innerJoin((TableLike)Tables.ENVIRONMENT_VARIABLE).on(Tables.ENVIRONMENT_VARIABLE.EV_ID.eq((Field)Tables.ENVIRONMENT_VARIABLE_BINDING.EV_ID)).where(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_ID.eq((Object)entityId).and(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_TYPE.eq((Object)entityType.name()))).fetchInto(BoundEnvironmentVariableDto.class);
    }

    @Override
    public List<Long> findProjectsLinkedToServerWhereVariableIsNotBound(Long serverId, EnvironmentVariable environmentVariable) {
        EnvironmentVariableBinding projectEnvironmentVariableBinding = Tables.ENVIRONMENT_VARIABLE_BINDING.as("PROJECT_ENVIRONMENT_VARIABLE_BINDING");
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).leftJoin((TableLike)Tables.ENVIRONMENT_VARIABLE_BINDING).on(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID).and(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_TYPE.eq((Object)EVBindableEntity.TEST_AUTOMATION_SERVER.name())).and(Tables.ENVIRONMENT_VARIABLE_BINDING.EV_ID.eq((Object)environmentVariable.getId()))).leftJoin((TableLike)projectEnvironmentVariableBinding).on(projectEnvironmentVariableBinding.EV_ID.eq((Field)Tables.ENVIRONMENT_VARIABLE_BINDING.EV_ID).and(projectEnvironmentVariableBinding.ENTITY_ID.eq((Field)Tables.PROJECT.PROJECT_ID))).and(projectEnvironmentVariableBinding.ENTITY_TYPE.eq((Object)EVBindableEntity.PROJECT.name())).where(Tables.PROJECT.TA_SERVER_ID.eq((Object)serverId).and(projectEnvironmentVariableBinding.EV_ID.isNull())).fetchInto(Long.class);
    }

    @Override
    public List<BoundEnvironmentVariableDto> getDefaultBoundEnvironmentVariablesByServerId(Long serverId) {
        return this.dsl.select((SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.EVB_ID.as("BINDING_ID"), (SelectField)Tables.ENVIRONMENT_VARIABLE.NAME, (SelectField)Tables.ENVIRONMENT_VARIABLE.EV_ID.as("ID"), (SelectField)Tables.ENVIRONMENT_VARIABLE.INPUT_TYPE, (SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.VALUE, (SelectField)Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_TYPE.as("EV_BINDABLE_ENTITY")).from((TableLike)Tables.ENVIRONMENT_VARIABLE_BINDING).innerJoin((TableLike)Tables.ENVIRONMENT_VARIABLE).on(Tables.ENVIRONMENT_VARIABLE.EV_ID.eq((Field)Tables.ENVIRONMENT_VARIABLE_BINDING.EV_ID)).where(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_ID.eq((Object)serverId).and(Tables.ENVIRONMENT_VARIABLE_BINDING.ENTITY_TYPE.eq((Object)EVBindableEntity.TEST_AUTOMATION_SERVER.name()))).fetch().into(BoundEnvironmentVariableDto.class);
    }
}

