/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.RequirementPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.RequirementPivotDao;

@Service
public class RequirementPivotExporterServiceImpl
implements RequirementPivotExporterService {
    private final RequirementPivotDao requirementPivotDao;
    private final PivotFileManager pivotFileManager;

    public RequirementPivotExporterServiceImpl(RequirementPivotDao requirementPivotDao, PivotFileManager pivotFileManager) {
        this.requirementPivotDao = requirementPivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateRequirementJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.requirementPivotDao.hasRequirementByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleRequirements((JsonGenerator)jsonGenerator, projectId), JsonImportFile.REQUIREMENTS.getFileName(), archive);
    }

    private void handleRequirements(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("requirements");
        jsonGenerator.writeStartArray();
        this.requirementPivotDao.getRequirementByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }
}

