/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.grid;

import jakarta.inject.Inject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.gridconfiguration.GridColumnDisplayConfiguration;
import org.squashtest.tm.domain.gridconfiguration.GridColumnDisplayReference;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.grid.ColumnIds;
import org.squashtest.tm.service.grid.GridConfigurationService;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.GridColumnDisplayConfigurationDao;
import org.squashtest.tm.service.internal.repository.GridColumnDisplayReferenceDao;
import org.squashtest.tm.service.user.UserAccountService;

@Service(value="squashtest.tm.service.GridConfigurationService")
@Transactional
public class GridConfigurationServiceImpl
implements GridConfigurationService {
    private static final List<String> MANDATORY_COLUMNS = Arrays.asList("#", "folder", "detail", "delete", "startExecution", "execution", "testCaseBoundToItem", "workflows", "attachmentPrune");
    private static final String REQUIREMENT_SEARCH = "requirement-search";
    private static final String TEST_CASE_SEARCH = "test-case-search";
    private static final String TC_BY_REQUIREMENT = "tc-by-requirement";
    private static final String ITPI_SEARCH = "itpi-search";
    private static final String ITERATION_TEST_PLAN = "iteration-test-plan";
    private static final String TEST_SUITE_TEST_PLAN = "test-suite-test-plan";
    private static final String CAMPAIGN_TEST_PLAN = "campaign-test-plan";
    private static final String ITERATION_AUTOMATED_SUITE = "iteration-automated-suite";
    private static final String TEST_SUITE_AUTOMATED_SUITE = "test-suite-automated-suite";
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private GridColumnDisplayReferenceDao gridColumnDisplayReferenceDao;
    @Inject
    private GridColumnDisplayConfigurationDao gridColumnDisplayConfigurationDao;
    @Inject
    CustomFieldDao customFieldDao;
    @Inject
    private DSLContext dsl;

    @Override
    public void addOrUpdatePreferenceForCurrentUser(String gridId, List<String> columnIds) {
        User user = this.userAccountService.findCurrentUser();
        gridId = this.setGridConfigId(gridId);
        this.addOrUpdateGridColumnConfig(user, gridId, columnIds);
    }

    @Override
    public void addOrUpdateGridColumnConfig(User user, String gridId, List<String> columnIds) {
        switch (gridId) {
            case "requirement-search": {
                columnIds.add(ColumnIds.NAME.getColumnId());
                columnIds.add(ColumnIds.REQ_VERSION_BOUND_TO_ITEM.getColumnId());
                break;
            }
            case "test-case-search": {
                columnIds.add(ColumnIds.NAME.getColumnId());
                break;
            }
            case "itpi-search": {
                columnIds.add(ColumnIds.LABEL.getColumnId());
                columnIds.add(ColumnIds.EXECUTION_STATUS.getColumnId());
                break;
            }
            default: {
                columnIds.add("");
            }
        }
        GridColumnDisplayReference reference = this.gridColumnDisplayReferenceDao.findByUserAndGridId(user, gridId);
        if (reference == null) {
            reference = new GridColumnDisplayReference();
            reference.setUser(user);
            reference.setGridId(gridId);
            reference = (GridColumnDisplayReference)this.gridColumnDisplayReferenceDao.save(reference);
            this.createNewConfigurations(reference, columnIds);
        } else {
            Long referenceId = reference.getId();
            this.gridColumnDisplayConfigurationDao.deleteByGridColumnDisplayReferenceId(referenceId);
            this.createNewConfigurations(reference, columnIds);
        }
    }

    @Override
    public void resetGridColumnConfig(String gridId) {
        User user = this.userAccountService.findCurrentUser();
        gridId = this.setGridConfigId(gridId);
        Long referenceId = this.gridColumnDisplayReferenceDao.findByUserAndGridId(user, gridId).getId();
        this.gridColumnDisplayConfigurationDao.deleteByGridColumnDisplayReferenceId(referenceId);
        this.deleteExistingReference(user.getId(), referenceId);
    }

    @Override
    public List<String> findActiveColumnIdsForUser(String gridId) {
        User user = this.userAccountService.findCurrentUser();
        GridColumnDisplayReference gridConfig = this.gridColumnDisplayReferenceDao.findByUserAndGridId(user, gridId = this.setGridConfigId(gridId));
        if (gridConfig != null) {
            List<String> activeColumnIds = this.findActiveColumnIdsByGridColumnDisplayReferenceId(gridConfig.getId());
            activeColumnIds.addAll(MANDATORY_COLUMNS);
            return activeColumnIds;
        }
        return new ArrayList<String>();
    }

    @Override
    public void addOrUpdatePreferenceForCurrentUserWithProjectId(String gridId, List<String> columnIds, Long projectId) {
        User user = this.userAccountService.findCurrentUser();
        this.addOrUpdateGridColumnConfigWithProjectId(user, gridId, columnIds, projectId);
    }

    @Override
    public List<String> findActiveColumnIdsForUserWithProjectId(String gridId, Long projectId) {
        User user = this.userAccountService.findCurrentUser();
        GridColumnDisplayReference gridConfig = this.gridColumnDisplayReferenceDao.findByUserAndGridIdAndProjectId(user, gridId, projectId);
        if (gridConfig != null) {
            List<String> activeColumnIds = this.findActiveColumnIdsByGridColumnDisplayReferenceId(gridConfig.getId());
            activeColumnIds.addAll(MANDATORY_COLUMNS);
            return activeColumnIds;
        }
        return new ArrayList<String>();
    }

    @Override
    public void deleteColumnConfigForProject(Long projectId) {
        this.gridColumnDisplayReferenceDao.deleteByProjectId(projectId);
    }

    @Override
    public void resetGridColumnConfigWithProjectId(String gridId, String projectId) {
        User user = this.userAccountService.findCurrentUser();
        Long referenceId = this.gridColumnDisplayReferenceDao.findByUserAndGridIdAndProjectId(user, gridId, Long.valueOf(projectId)).getId();
        this.gridColumnDisplayConfigurationDao.deleteByGridColumnDisplayReferenceId(referenceId);
        this.deleteExistingReference(user.getId(), referenceId);
    }

    private void addOrUpdateGridColumnConfigWithProjectId(User user, String gridId, List<String> columnIds, Long projectId) {
        switch (gridId) {
            case "iteration-test-plan": 
            case "test-suite-test-plan": {
                columnIds.add(ColumnIds.TEST_CASE_NAME.getColumnId());
                columnIds.add(ColumnIds.LAST_EXECUTED_ON.getColumnId());
                columnIds.add(ColumnIds.EXECUTION_STATUS.getColumnId());
                break;
            }
            case "campaign-test-plan": {
                columnIds.add(ColumnIds.TEST_CASE_NAME.getColumnId());
                break;
            }
            case "test-suite-automated-suite": 
            case "iteration-automated-suite": {
                columnIds.add(ColumnIds.CREATED_ON.getColumnId());
                columnIds.add(ColumnIds.EXECUTION_STATUS.getColumnId());
                columnIds.add(ColumnIds.EXECUTION_DETAILS.getColumnId());
                columnIds.add(ColumnIds.EXECUTION_REPORTS.getColumnId());
                break;
            }
        }
        GridColumnDisplayReference reference = this.gridColumnDisplayReferenceDao.findByUserAndGridIdAndProjectId(user, gridId, projectId);
        if (reference == null) {
            reference = new GridColumnDisplayReference();
            reference.setUser(user);
            reference.setGridId(gridId);
            reference.setProjectId(projectId);
            reference = (GridColumnDisplayReference)this.gridColumnDisplayReferenceDao.save(reference);
            this.createNewConfigurations(reference, columnIds);
        } else {
            Long referenceId = reference.getId();
            this.gridColumnDisplayConfigurationDao.deleteByGridColumnDisplayReferenceId(referenceId);
            this.createNewConfigurations(reference, columnIds);
        }
    }

    @Override
    public List<String> findActiveColumnIdsByGridColumnDisplayReferenceId(Long referenceId) {
        return this.dsl.select((SelectField)Tables.GRID_COLUMN_DISPLAY_CONFIGURATION.ACTIVE_COLUMN_ID).from((TableLike)Tables.GRID_COLUMN_DISPLAY_CONFIGURATION).where(Tables.GRID_COLUMN_DISPLAY_CONFIGURATION.GCDR_ID.eq((Object)referenceId)).fetch((Field)Tables.GRID_COLUMN_DISPLAY_CONFIGURATION.ACTIVE_COLUMN_ID, String.class);
    }

    private void deleteExistingReference(Long userId, Long id) {
        GridColumnDisplayReference gridColumnDisplayReference = this.gridColumnDisplayReferenceDao.findByUserIdAndId(userId, id);
        this.gridColumnDisplayReferenceDao.delete(gridColumnDisplayReference);
    }

    private void createNewConfigurations(GridColumnDisplayReference reference, List<String> columnIds) {
        for (String columnId : columnIds) {
            GridColumnDisplayConfiguration config = new GridColumnDisplayConfiguration();
            config.setGridColumnDisplayReference(reference);
            config.setActiveColumnId(columnId);
            this.gridColumnDisplayConfigurationDao.save(config);
        }
    }

    private String setGridConfigId(String gridId) {
        if (gridId.equals(TC_BY_REQUIREMENT)) {
            return TEST_CASE_SEARCH;
        }
        return gridId;
    }

    @Override
    public Long getCufIdFromCufColumnName(String columnName) {
        return Long.valueOf(columnName.replace("cuf|", ""));
    }

    @Override
    public String reformatSimpleDateForExport(Date date) {
        return date == null ? "" : DateUtils.formatIso8601Date((Date)date);
    }

    @Override
    public String reformatMultipleDateForExport(String concatenatedDates) {
        ArrayList<String> formattedDates = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)concatenatedDates)) {
            String[] dateStrings = concatenatedDates.split("\\|");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String[] stringArray = dateStrings;
            int n = dateStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String dateString = stringArray[n2];
                try {
                    Date date = dateFormat.parse(dateString);
                    formattedDates.add(this.reformatSimpleDateForExport(date));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Date has wrong format: " + dateString, e);
                }
                ++n2;
            }
        }
        return String.join((CharSequence)", ", formattedDates);
    }

    @Override
    public String reformatLabelForExport(String concatenatedLabel) {
        if (StringUtils.isNotBlank((CharSequence)concatenatedLabel)) {
            return concatenatedLabel.replace("|", ", ");
        }
        return "";
    }

    @Override
    public String nullSafeValue(ExportModel.CustomField customField) {
        String value = customField.getValue();
        return value == null ? "" : value;
    }

    @Override
    public ExportModel.CustomField findCufById(List<ExportModel.CustomField> cufs, Long cufId, Integer index) {
        Optional<ExportModel.CustomField> optionalCuf = cufs.stream().filter(cuf -> cuf.getCufId().equals(cufId)).findAny();
        return optionalCuf.orElse(null);
    }

    @Override
    public void registerCuf(Row headerRow, int cIdx, String cufColumnName, Map<Long, Integer> cufColumnsByCode) {
        Long cufId = this.getCufIdFromCufColumnName(cufColumnName);
        Optional cuf = this.customFieldDao.findById(cufId);
        if (cuf.isPresent()) {
            CustomField customField = (CustomField)cuf.get();
            headerRow.createCell(cIdx).setCellValue(customField.getLabel());
            cufColumnsByCode.put(customField.getId(), cIdx);
        }
    }
}

