/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters.collector;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingConditionStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.jooq.domain.tables.Resource;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterOperation;
import org.squashtest.tm.service.internal.display.grid.filters.collector.DefaultFilterCollector;
import org.squashtest.tm.service.internal.display.search.filter.CurrentVersionFilterHandler;

public class FilterRequirementSearchCollector
extends DefaultFilterCollector {
    private static final Pattern CUF_FILTER_PATTERN = Pattern.compile("CUF_FILTER_(\\d+)");
    private static final String HAS_DESCRIPTION_FALSE = "NO_DESCRIPTION";
    private static final String HAS_CHILDREN_FALSE = "NO_CHILDREN";
    private static final String HAS_PARENT_FALSE = "NO_PARENT";
    private static final String TYPE_LINK_AT_LEAST_ONE = "AT_LEAST_ONE";
    private static final String TYPE_LINK_NONE = "NONE";

    public FilterRequirementSearchCollector(Map<String, GridColumn> aliasToFieldDictionary, boolean searchingOnMultiColumns) {
        super(aliasToFieldDictionary, searchingOnMultiColumns);
    }

    @Override
    protected Condition convertFilterToCondition(GridFilterValue gridFilterValue) {
        ComplexeFilter complexeFilter = ComplexeFilter.getComplexeFilter(gridFilterValue.getId());
        if (complexeFilter != null) {
            return complexeFilter.getCondition().apply(gridFilterValue);
        }
        return super.convertFilterToCondition(gridFilterValue);
    }

    private static enum ComplexeFilter {
        REQUIREMENT_VERSION_CURRENT_VERSION("REQUIREMENT_VERSION_CURRENT_VERSION", ComplexeFilter::requirementVersionCurrentVersion),
        REQUIREMENT_KIND("REQUIREMENT_KIND", ComplexeFilter::natureRequirement),
        ATTACHMENT_COUNT("ATTACHMENT_COUNT", ComplexeFilter::attachmentCount),
        HAS_DESCRIPTION("HAS_DESCRIPTION", ComplexeFilter::hasDescription),
        COVERAGES_COUNT("COVERAGES_COUNT", ComplexeFilter::coveragesCount),
        HAS_CHILDREN("HAS_CHILDREN", ComplexeFilter::hasChildren),
        HAS_PARENT("HAS_PARENT", ComplexeFilter::hasParent),
        HAS_LINK_TYPE("HAS_LINK_TYPE", ComplexeFilter::hasLinkType),
        REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT("REQUIREMENT_BOUND_TO_HIGH_LEVEL_REQUIREMENT", ComplexeFilter::requirementBoundToHighLevelRequirement),
        LINKED_STANDARD_REQUIREMENT("LINKED_STANDARD_REQUIREMENT", ComplexeFilter::linkedStandardRequirement),
        CUF_FILTER("CUF_FILTER", ComplexeFilter::cufFilter);

        private final String alias;
        private final Function<GridFilterValue, Condition> getCondition;

        private ComplexeFilter(String alias, Function<GridFilterValue, Condition> getCondition) {
            this.alias = alias;
            this.getCondition = getCondition;
        }

        private static String getNormalizeFieldName(String camelCase) {
            Converter converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
            return (String)converter.convert((Object)camelCase);
        }

        private Function<GridFilterValue, Condition> getCondition() {
            return this.getCondition;
        }

        private static ComplexeFilter getComplexeFilter(String alias) {
            if (CUF_FILTER_PATTERN.matcher(alias).find()) {
                return CUF_FILTER;
            }
            String name = ComplexeFilter.getNormalizeFieldName(alias);
            return Arrays.stream(ComplexeFilter.values()).filter(filter -> filter.alias.equals(name)).findFirst().orElse(null);
        }

        private static Condition requirementVersionCurrentVersion(GridFilterValue gridFilterValue) {
            String value = gridFilterValue.getValues().get(0);
            if (value.equals(CurrentVersionFilterHandler.CurrentVersionFilterValue.LAST_NON_OBSOLETE.name())) {
                RequirementVersion rvSubQuery = Tables.REQUIREMENT_VERSION.as("rvSubQuery");
                return Tables.REQUIREMENT_VERSION.VERSION_NUMBER.eq((Select)DSL.select((SelectField)DSL.max((Field)rvSubQuery.VERSION_NUMBER)).from((TableLike)rvSubQuery).where(rvSubQuery.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).and(rvSubQuery.REQUIREMENT_STATUS.notEqual((Object)RequirementStatus.OBSOLETE.name())));
            }
            if (value.equals(CurrentVersionFilterHandler.CurrentVersionFilterValue.CURRENT.name())) {
                RequirementVersion rvSubQuery = Tables.REQUIREMENT_VERSION.as("rvSubQuery");
                return Tables.REQUIREMENT_VERSION.VERSION_NUMBER.eq((Select)DSL.select((SelectField)DSL.max((Field)rvSubQuery.VERSION_NUMBER)).from((TableLike)rvSubQuery).where(rvSubQuery.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)));
            }
            return DSL.noCondition();
        }

        private static Condition natureRequirement(GridFilterValue gridFilterValue) {
            String requirement = "org.squashtest.tm.domain.requirement.Requirement";
            String highLevelRequirement = HighLevelRequirement.class.getCanonicalName();
            List<String> values = gridFilterValue.getValues();
            if (values.size() == 1) {
                if (requirement.equals(values.get(0))) {
                    return DSL.field((SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID).isNull();
                }
                if (highLevelRequirement.equals(values.get(0))) {
                    return DSL.field((SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID).isNotNull();
                }
            }
            return DSL.noCondition();
        }

        private static Condition attachmentCount(GridFilterValue gridFilterValue) {
            Condition condition = GridFilterConditionBuilder.getConditionBuilder(DSL.count((Field)Tables.ATTACHMENT.ATTACHMENT_ID), gridFilterValue).build();
            RequirementVersion rvSQ = Tables.REQUIREMENT_VERSION.as("ReqVersionSubQuery");
            Resource rSQ = Tables.RESOURCE.as("ResourceSubQuery");
            return DSL.exists((Select)DSL.selectOne().from((TableLike)rvSQ).join((TableLike)rSQ).on(rvSQ.RES_ID.eq((Field)rSQ.RES_ID)).leftJoin((TableLike)Tables.ATTACHMENT).on(rSQ.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)rvSQ.RES_ID)).groupBy(new GroupField[]{rSQ.RES_ID}).having(condition));
        }

        private static Condition hasDescription(GridFilterValue gridFilterValue) {
            String value = gridFilterValue.getValues().get(0);
            Field descriptionField = DSL.field((SelectField)Tables.RESOURCE.DESCRIPTION);
            if (value.equals(HAS_DESCRIPTION.name())) {
                return DSL.length((Field)descriptionField).gt((Object)0);
            }
            if (value.equals(FilterRequirementSearchCollector.HAS_DESCRIPTION_FALSE)) {
                return DSL.length((Field)descriptionField).eq((Object)0);
            }
            throw new UnsupportedOperationException("Unknown value for has_description filter: " + value);
        }

        private static Condition coveragesCount(GridFilterValue gridFilterValue) {
            Condition condition = GridFilterConditionBuilder.getConditionBuilder(DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID), gridFilterValue).build();
            return DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).having(condition));
        }

        private static Condition hasChildren(GridFilterValue gridFilterValue) {
            SelectHavingConditionStep selectDescendantReq = DSL.selectOne().from((TableLike)Tables.RLN_RELATIONSHIP).where(Tables.RLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP.ANCESTOR_ID}).having(DSL.count((Field)Tables.RLN_RELATIONSHIP.DESCENDANT_ID).greaterThan((Object)0));
            String value = gridFilterValue.getValues().get(0);
            if (value.equals(HAS_CHILDREN.name())) {
                return DSL.exists((Select)selectDescendantReq);
            }
            if (value.equals(FilterRequirementSearchCollector.HAS_CHILDREN_FALSE)) {
                return DSL.notExists((Select)selectDescendantReq);
            }
            throw new UnsupportedOperationException("Unknown value for has_children filter: " + value);
        }

        private static Condition hasParent(GridFilterValue gridFilterValue) {
            SelectHavingConditionStep selectParentReq = DSL.selectOne().from((TableLike)Tables.REQUIREMENT).join((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID)).where(Tables.RLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT.RLN_ID}).having(DSL.count((Field)Tables.REQUIREMENT.RLN_ID).greaterThan((Object)0));
            String value = gridFilterValue.getValues().get(0);
            if (value.equals(HAS_PARENT.name())) {
                return DSL.exists((Select)selectParentReq);
            }
            if (value.equals(FilterRequirementSearchCollector.HAS_PARENT_FALSE)) {
                return DSL.notExists((Select)selectParentReq);
            }
            throw new UnsupportedOperationException("Unknown value for has_children filter: " + value);
        }

        private static Condition hasLinkType(GridFilterValue gridFilterValue) {
            List<String> values = gridFilterValue.getValues();
            String operation = gridFilterValue.getOperation();
            SelectConditionStep condition = DSL.selectOne().from((TableLike)Tables.REQUIREMENT_VERSION_LINK).join((TableLike)Tables.REQUIREMENT_VERSION_LINK_TYPE).on(Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.TYPE_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID)).and(Tables.REQUIREMENT_VERSION_LINK.LINK_DIRECTION.eq((Object)false).and(Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2_CODE.in(values)).or(Tables.REQUIREMENT_VERSION_LINK.LINK_DIRECTION.eq((Object)true).and(Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1_CODE.in(values))));
            if (operation.equals(FilterRequirementSearchCollector.TYPE_LINK_AT_LEAST_ONE)) {
                return DSL.exists((Select)condition);
            }
            if (operation.equals(FilterRequirementSearchCollector.TYPE_LINK_NONE)) {
                return DSL.notExists((Select)condition);
            }
            throw new UnsupportedOperationException("Unknown operation for has_link_type filter: " + operation);
        }

        private static Condition requirementBoundToHighLevelRequirement(GridFilterValue gridFilterValue) {
            SelectConditionStep selectBoundHLReq = DSL.selectOne().from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).where(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).and(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull());
            boolean bound = Boolean.parseBoolean(gridFilterValue.getValues().get(0));
            if (bound) {
                return DSL.exists((Select)selectBoundHLReq);
            }
            return DSL.notExists((Select)selectBoundHLReq);
        }

        private static Condition linkedStandardRequirement(GridFilterValue gridFilterValue) {
            Condition condition = GridFilterConditionBuilder.getConditionBuilder(DSL.count((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID), gridFilterValue).build();
            return DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).and(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNull()).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID}).having(condition));
        }

        private static Condition cufFilter(GridFilterValue gridFilterValue) {
            Long cufId = CUF_FILTER_PATTERN.matcher(gridFilterValue.getId()).results().map(matchResult -> Long.parseLong(matchResult.group(1))).findFirst().orElseThrow();
            if (gridFilterValue.getColumnPrototype().toUpperCase().contains("CUF_TAG")) {
                return ComplexeFilter.cufFilterMultipleValue(gridFilterValue, cufId);
            }
            if (gridFilterValue.getColumnPrototype().toUpperCase().contains("CUF_NUMERIC")) {
                Condition condition = ComplexeFilter.createCufNumericCondition(gridFilterValue);
                return ComplexeFilter.cufFilterSingleValue(cufId, condition);
            }
            Condition condition = GridFilterConditionBuilder.getConditionBuilder(Tables.CUSTOM_FIELD_VALUE.VALUE, gridFilterValue).build();
            return ComplexeFilter.cufFilterSingleValue(cufId, condition);
        }

        private static Condition createCufNumericCondition(GridFilterValue gridFilterValue) {
            GridFilterOperation gridFilterOperation = GridFilterOperation.valueOf(gridFilterValue.getOperation());
            if (GridFilterOperation.EQUALS.equals((Object)gridFilterOperation)) {
                return Tables.CUSTOM_FIELD_VALUE.NUMERIC_VALUE.eq((Object)((BigDecimal)GridFilterConditionBuilder.getGridFilterValueConvert(Tables.CUSTOM_FIELD_VALUE.NUMERIC_VALUE, gridFilterValue.getValues().get(0))));
            }
            return GridFilterConditionBuilder.getConditionBuilder(Tables.CUSTOM_FIELD_VALUE.NUMERIC_VALUE, gridFilterValue, gridFilterOperation).build();
        }

        private static Condition cufFilterSingleValue(Long cufId, Condition condition) {
            return DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.CUSTOM_FIELD_VALUE).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)BindableEntity.REQUIREMENT_VERSION.name())).and(Tables.CUSTOM_FIELD_VALUE.CF_ID.eq((Object)cufId)).and(condition));
        }

        private static Condition cufFilterMultipleValue(GridFilterValue gridFilterValue, Long cufId) {
            String gridFilterValueOperation = gridFilterValue.getOperation();
            SelectConditionStep commonQuery = DSL.selectOne().from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)BindableEntity.REQUIREMENT_VERSION.name())).and(Tables.CUSTOM_FIELD_VALUE.CF_ID.eq((Object)cufId));
            if ("AND".equalsIgnoreCase(gridFilterValueOperation)) {
                Condition condition = GridFilterConditionBuilder.getConditionBuilder(Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL, gridFilterValue, GridFilterOperation.IN).build();
                return DSL.exists((Select)commonQuery.and(condition).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID}).having(DSL.count((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).eq((Object)gridFilterValue.getValues().size())));
            }
            Condition condition = GridFilterConditionBuilder.getConditionBuilder(Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL, gridFilterValue).build();
            return DSL.exists((Select)commonQuery.and(condition));
        }
    }
}

