/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.custom.field;

import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.display.custom.field.CustomFieldDisplayService;
import org.squashtest.tm.service.internal.display.dto.BoundProjectToCufDto;
import org.squashtest.tm.service.internal.display.dto.CufBindingDto;
import org.squashtest.tm.service.internal.display.dto.CustomFieldDto;
import org.squashtest.tm.service.internal.display.dto.ProjectDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.CustomFieldGrid;
import org.squashtest.tm.service.internal.repository.display.CustomFieldDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
@Transactional
public class CustomFieldDisplayServiceImpl
implements CustomFieldDisplayService {
    @Inject
    private DSLContext dsl;
    @Inject
    private CustomFieldDao customFieldDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse findAll(GridRequest request) {
        CustomFieldGrid customFieldGrid = new CustomFieldGrid();
        return customFieldGrid.getRows(request, this.dsl);
    }

    @Override
    @CheckEntityExists(entityType=CustomField.class)
    public CustomFieldDto getCustomFieldView(@Id Long customFieldId) {
        return this.customFieldDao.findByIdWithPossibleValues(customFieldId);
    }

    @Override
    public List<CustomFieldDto> findAllWithPossibleValues() {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        return this.customFieldDao.findAllWithPossibleValues();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Map<BindableEntity, Set<CufBindingDto>> findAllCustomFieldBindings(Long projectId) {
        ProjectDto dto = new ProjectDto();
        dto.setId(projectId);
        this.customFieldDao.appendCustomFieldBindings(Collections.singletonList(dto));
        return dto.getCustomFieldBindings();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<BoundProjectToCufDto> findAllBoundProjectsByCufId(Long cufId) {
        return this.customFieldDao.findAllBoundProjectsByCufId(cufId);
    }
}

