/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.local;

import java.util.Collection;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record1;
import org.jooq.Record5;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.jooq.domain.tables.RequirementVersion;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.local.RequirementVersionLocalKnownIssue;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.BaseLocalKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.LocalKnownIssueFinderHelper;

@Repository
@Transactional(readOnly=true)
public class RequirementVersionKnownIssueFinder
extends BaseLocalKnownIssueFinder<Record5<Long, Long, String, String, String>> {
    public RequirementVersionKnownIssueFinder(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public int countKnownIssues(Long requirementVersionId) {
        return this.selectKnownIssues(requirementVersionId).fetch().size();
    }

    @Override
    protected LocalKnownIssue buildIssueFromRecord(Record5<Long, Long, String, String, String> record) {
        return new RequirementVersionLocalKnownIssue((Long)record.component1(), (Long)record.component2(), (String)record.component3(), LocalKnownIssueFinderHelper.parseLongsAndSortDesc((String)record.component4()), LocalKnownIssueFinderHelper.parseLongsAndSortDesc((String)record.component5()));
    }

    @Override
    protected SelectHavingStep<Record5<Long, Long, String, String, String>> selectKnownIssues(long requirementVersionId) {
        List requirementVersionIds = this.selectVerifiedDescendantsVersionIds(requirementVersionId).fetchInto(Long.class);
        requirementVersionIds.add(requirementVersionId);
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.ISSUE.BUGTRACKER_ID, (SelectField)Tables.ISSUE.REMOTE_ISSUE_ID, (SelectField)DSL.groupConcatDistinct((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)DSL.groupConcatDistinct((Field)RequirementVersion.REQUIREMENT_VERSION.RES_ID)).from((TableLike)BaseLocalKnownIssueFinder.getIssueToBugtrackerBindingJoin().innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.EXECUTION.TCLN_ID)).innerJoin((TableLike)RequirementVersion.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)RequirementVersion.REQUIREMENT_VERSION.RES_ID))).where(RequirementVersion.REQUIREMENT_VERSION.RES_ID.in((Collection)requirementVersionIds)).and(Tables.ISSUE.BUGTRACKER_ID.eq((Field)Tables.PROJECT.BUGTRACKER_ID)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.ISSUE.BUGTRACKER_ID, Tables.ISSUE.REMOTE_ISSUE_ID});
    }

    private Select<Record1<Long>> selectVerifiedDescendantsVersionIds(long requirementVersionId) {
        Requirement requirementChild = Tables.REQUIREMENT.as("r2");
        return this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID).from((TableLike)RequirementVersion.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.REQUIREMENT).on(RequirementVersion.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).innerJoin((TableLike)requirementChild).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)requirementChild.RLN_ID).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0))).or(Tables.REQUIREMENT.RLN_ID.equal((Field)requirementChild.HIGH_LEVEL_REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)requirementChild.CURRENT_VERSION_ID)).where(RequirementVersion.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId));
    }
}

