/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateCampaignDeletionDao
extends AbstractHibernateDeletionDao
implements CampaignDeletionDao {
    private static final String CAMPAIGN_IDS = "campaignIds";
    private static final String NODE_IDS = "nodeIds";
    private static final String FOLDER_IDS = "folderIds";

    @Override
    public void removeEntities(List<Long> entityIds) {
        if (!entityIds.isEmpty()) {
            for (Long entityId : entityIds) {
                CampaignLibraryNode node = (CampaignLibraryNode)this.em.getReference(CampaignLibraryNode.class, (Object)entityId);
                this.removeEntityFromParentLibraryIfExists(entityId, node);
                this.removeEntityFromParentFolderIfExists(entityId, node);
                if (node == null) continue;
                this.em.remove((Object)node);
                this.em.flush();
            }
        }
    }

    private void removeEntityFromParentLibraryIfExists(Long entityId, CampaignLibraryNode node) {
        CampaignLibrary library = (CampaignLibrary)this.em.createNamedQuery("campaignLibraryNode.findParentLibraryIfExists", CampaignLibrary.class).setParameter("libraryNodeId", (Object)entityId).getSingleResult();
        if (library != null) {
            for (CampaignLibraryNode tcln : library.getContent()) {
                if (!tcln.getId().equals(node.getId())) continue;
                library.removeContent(tcln);
                break;
            }
        }
    }

    private void removeEntityFromParentFolderIfExists(Long entityId, CampaignLibraryNode node) {
        TypedQuery query = this.em.createNamedQuery("campaignLibraryNode.findParentFolderIfExists", CampaignFolder.class);
        query.setParameter("libraryNodeId", (Object)entityId);
        CampaignFolder folder = (CampaignFolder)query.getSingleResult();
        if (folder != null) {
            for (CampaignLibraryNode tcln : folder.getContent()) {
                if (!tcln.getId().equals(node.getId())) continue;
                folder.removeContent(tcln);
                break;
            }
        }
    }

    @Override
    public Map<String, List<Long>> separateFolderFromCampaignIds(List<Long> originalIds) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        ArrayList<Long> campaignIds = new ArrayList<Long>();
        List filtredFolderIds = this.executeSelectSQLQuery("select folder.cln_id from CAMPAIGN_FOLDER folder where folder.cln_id in (:campaignIds)", CAMPAIGN_IDS, originalIds);
        for (Long oId : originalIds) {
            if (filtredFolderIds.contains(oId)) {
                folderIds.add(oId);
                continue;
            }
            campaignIds.add(oId);
        }
        return Map.of(FOLDER_IDS, folderIds, NODE_IDS, campaignIds);
    }

    @Override
    public void unbindFromMilestone(List<Long> campaignIds, Long milestoneId) {
        if (!campaignIds.isEmpty()) {
            this.em.createNativeQuery("delete from MILESTONE_CAMPAIGN where MILESTONE_ID = :milestoneId and CAMPAIGN_ID in (:campaignIds)").setParameter(CAMPAIGN_IDS, campaignIds).setParameter("milestoneId", (Object)milestoneId).executeUpdate();
        }
    }

    @Override
    public List<Long> findCampaignsWhichMilestonesForbidsDeletion(List<Long> originalId) {
        if (!originalId.isEmpty()) {
            MilestoneStatus[] blockingStatuses = new MilestoneStatus[MilestoneStatus.MILESTONE_BLOCKING_STATUSES.size()];
            MilestoneStatus.MILESTONE_BLOCKING_STATUSES.toArray(blockingStatuses);
            return this.em.createNamedQuery("campaign.findCampaignsWhichMilestonesForbidsDeletion", Long.class).setParameter(CAMPAIGN_IDS, originalId).setParameter("lockedStatuses", Arrays.asList(blockingStatuses)).getResultList();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> findRemainingCampaignIds(List<Long> originalIds) {
        List rawids = this.executeSelectSQLQuery("select CLN_ID from CAMPAIGN where CLN_ID in (:allCampaignIds)", "allCampaignIds", originalIds);
        ArrayList<Long> cIds = new ArrayList<Long>(rawids.size());
        cIds.addAll(rawids);
        return cIds;
    }
}

