/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.infolist.InfoListProjectBindingType;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.InfoListPivotDao;

@Repository
public class InfoListPivotDaoImpl
implements InfoListPivotDao {
    private static final int BATCH_SIZE = 50;
    private final DSLContext dsl;
    private final AdminPivotConverterService adminPivotConverterService;

    public InfoListPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        this.dsl = dsl;
        this.adminPivotConverterService = adminPivotConverterService;
    }

    @Override
    public boolean hasCustomInfoListBindingByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.checkCustomInfoListByProjectId(projectId, (Field<Long>)Tables.PROJECT.REQ_CATEGORIES_LIST).unionAll(this.checkCustomInfoListByProjectId(projectId, (Field<Long>)Tables.PROJECT.TC_NATURES_LIST)).unionAll(this.checkCustomInfoListByProjectId(projectId, (Field<Long>)Tables.PROJECT.TC_TYPES_LIST)));
    }

    private SelectConditionStep<Record1<Integer>> checkCustomInfoListByProjectId(Long projectId, Field<Long> projectJoinField) {
        List<String> systemCodes = Arrays.stream(SystemInfoListCode.values()).map(SystemInfoListCode::getCode).toList();
        return this.dsl.selectOne().from((TableLike)Tables.PROJECT).join((TableLike)Tables.INFO_LIST).on(projectJoinField.eq((Field)Tables.INFO_LIST.INFO_LIST_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.INFO_LIST.CODE.notIn(systemCodes));
    }

    private SelectConditionStep<Record> getCustomInfoListWithItemByProjectId(Long projectId, Field<Long> projectJoinField, InfoListProjectBindingType infoListProjectBindingType, List<Field<?>> fields) {
        List<String> systemCodes = Arrays.stream(SystemInfoListCode.values()).map(SystemInfoListCode::getCode).toList();
        ArrayList copyFields = new ArrayList(fields);
        copyFields.add(DSL.val((String)infoListProjectBindingType.name()).as(InfoListPivotDao.INFO_LIST_BINDING_TYPE));
        return this.dsl.select(copyFields).from((TableLike)Tables.PROJECT).join((TableLike)Tables.INFO_LIST).on(projectJoinField.eq((Field)Tables.INFO_LIST.INFO_LIST_ID)).join((TableLike)Tables.INFO_LIST_ITEM).on(Tables.INFO_LIST_ITEM.LIST_ID.eq((Field)Tables.INFO_LIST.INFO_LIST_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.INFO_LIST.CODE.notIn(systemCodes));
    }

    @Override
    public void getCustomInfoListByProjectId(Long projectId, Consumer<InfoListPivot> consumer) {
        List<Field<?>> selectFields = List.of(Tables.INFO_LIST.INFO_LIST_ID, Tables.INFO_LIST.LABEL, Tables.INFO_LIST.DESCRIPTION, Tables.INFO_LIST.CODE, Tables.INFO_LIST_ITEM.ITEM_ID, Tables.INFO_LIST_ITEM.LABEL, Tables.INFO_LIST_ITEM.CODE, Tables.INFO_LIST_ITEM.COLOUR, Tables.INFO_LIST_ITEM.ICON_NAME, Tables.INFO_LIST_ITEM.IS_DEFAULT, Tables.INFO_LIST_ITEM.ITEM_INDEX);
        ResultQuery resultQuery = this.getCustomInfoListWithItemByProjectId(projectId, (Field<Long>)Tables.PROJECT.REQ_CATEGORIES_LIST, InfoListProjectBindingType.REQUIREMENT_CATEGORY, selectFields).unionAll(this.getCustomInfoListWithItemByProjectId(projectId, (Field<Long>)Tables.PROJECT.TC_NATURES_LIST, InfoListProjectBindingType.TEST_CASE_NATURE, selectFields)).unionAll(this.getCustomInfoListWithItemByProjectId(projectId, (Field<Long>)Tables.PROJECT.TC_TYPES_LIST, InfoListProjectBindingType.TEST_CASE_TYPE, selectFields)).orderBy((OrderField)Tables.INFO_LIST.INFO_LIST_ID, InfoListPivotDao.INFO_LIST_BINDING_TYPE, (OrderField)Tables.INFO_LIST_ITEM.ITEM_INDEX).fetchSize(50);
        this.fetchIntoInfoList(resultQuery).stream().collect(Collectors.toMap(AbstractPivotObject::pivotIdToSquashId, infoListPivot -> infoListPivot, (infoListPivot1, infoListPivot2) -> {
            infoListPivot1.getBoundProjectInfoLists().addAll(infoListPivot2.getBoundProjectInfoLists());
            return infoListPivot1;
        }, LinkedHashMap::new)).values().forEach(consumer);
    }

    private <T extends Record> List<InfoListPivot> fetchIntoInfoList(ResultQuery<T> resultQuery) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream stream = resultQuery.fetchStream();){
            Iterator iterator = stream.iterator();
            ArrayList<InfoListPivot> infoListPivotList = new ArrayList<InfoListPivot>();
            InfoListPivot infoListPivot = null;
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                if (infoListPivot == null) {
                    infoListPivot = this.adminPivotConverterService.recordToInfoListPivot(record);
                    this.addInfoListItemToInfoListPivot(infoListPivot, record);
                    continue;
                }
                if (!infoListPivot.getBoundProjectInfoLists().contains(InfoListProjectBindingType.valueOf((String)((String)record.get(InfoListPivotDao.INFO_LIST_BINDING_TYPE))))) {
                    infoListPivotList.add(infoListPivot);
                    infoListPivot = this.adminPivotConverterService.recordToInfoListPivot(record);
                    this.addInfoListItemToInfoListPivot(infoListPivot, record);
                    continue;
                }
                this.addInfoListItemToInfoListPivot(infoListPivot, record);
            }
            if (infoListPivot != null) {
                infoListPivotList.add(infoListPivot);
            }
            return infoListPivotList;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addInfoListItemToInfoListPivot(InfoListPivot infoListPivot, Record record) {
        if (record.get((Field)Tables.INFO_LIST_ITEM.ITEM_ID) == null) {
            return;
        }
        infoListPivot.getInfoListItems().add(this.adminPivotConverterService.recordToInfoListItemPivot(record));
    }
}

