/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.ExecutionWsPivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.SprintPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.CampaignPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.IterationPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestSuitePivotDao;

@Service
public class ExecutionWsPivotExporterServiceImpl
implements ExecutionWsPivotExporterService {
    private final CampaignPivotDao campaignPivotDao;
    private final IterationPivotDao iterationPivotDao;
    private final PivotFileManager pivotFileManager;
    private final TestSuitePivotDao testSuitePivotDao;
    private final SprintPivotDao sprintPivotDao;

    public ExecutionWsPivotExporterServiceImpl(CampaignPivotDao campaignPivotDao, IterationPivotDao iterationPivotDao, PivotFileManager pivotFileManager, TestSuitePivotDao testSuitePivotDao, SprintPivotDao sprintPivotDao) {
        this.campaignPivotDao = campaignPivotDao;
        this.iterationPivotDao = iterationPivotDao;
        this.pivotFileManager = pivotFileManager;
        this.testSuitePivotDao = testSuitePivotDao;
        this.sprintPivotDao = sprintPivotDao;
    }

    @Override
    public void generateCampaignJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.campaignPivotDao.hasCampaignByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleCampaigns((JsonGenerator)jsonGenerator, projectId), JsonImportFile.CAMPAIGNS.getFileName(), archive);
    }

    private void handleCampaigns(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("campaigns");
        jsonGenerator.writeStartArray();
        this.campaignPivotDao.getCampaignByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }

    @Override
    public void generateIterationJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.iterationPivotDao.hasIterationByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleIteration((JsonGenerator)jsonGenerator, projectId), JsonImportFile.ITERATIONS.getFileName(), archive);
    }

    private void handleIteration(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("iterations");
        jsonGenerator.writeStartArray();
        this.iterationPivotDao.getIterationByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }

    @Override
    public void generateTestSuiteJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.testSuitePivotDao.hasTestSuiteByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleTestSuite((JsonGenerator)jsonGenerator, projectId), JsonImportFile.TEST_SUITES.getFileName(), archive);
    }

    private void handleTestSuite(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("test_suites");
        jsonGenerator.writeStartArray();
        this.testSuitePivotDao.getTestSuiteByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }

    @Override
    public void generateSprintJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, Long projectId) throws IOException {
        if (!this.sprintPivotDao.hasSprintByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writeJson(jsonFactory, jsonGenerator -> this.handleSprint((JsonGenerator)jsonGenerator, projectId), JsonImportFile.SPRINTS.getFileName(), archive);
    }

    private void handleSprint(JsonGenerator jsonGenerator, Long projectId) throws IOException {
        jsonGenerator.writeFieldName("sprints");
        jsonGenerator.writeStartArray();
        this.sprintPivotDao.getSprintByProjectId(projectId, this.pivotFileManager.consumerThrowingIOException(arg_0 -> ((JsonGenerator)jsonGenerator).writeObject(arg_0)));
        jsonGenerator.writeEndArray();
    }
}

