/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.QCustomFieldValue;
import org.squashtest.tm.domain.customfield.QCustomFieldValueOption;
import org.squashtest.tm.domain.customfield.QTagsValue;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.query.CufTagOperation;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class TestCaseTagFilterHandler
implements FilterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseTagFilterHandler.class);
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"TEST_CASE_CUF_TAG"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        LOGGER.debug("Begin create filter tags", new Object[0]);
        CufTagOperation cufTagOperation = CufTagOperation.valueOf((String)filter.getOperation());
        List<String> tags = filter.getValues();
        QCustomFieldValue cfv = new QCustomFieldValue("cfv");
        QCustomFieldValueOption cfvo = new QCustomFieldValueOption("cfvo");
        QTestCase outerTestCase = QTestCase.testCase;
        QTestCase initTestCase = new QTestCase("initTestCase");
        QTagsValue tagsValue = new QTagsValue("tagsValue");
        long size = tags.size();
        LOGGER.debug("Create sub query", new Object[0]);
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)initTestCase)).join((EntityPath)cfv)).on((Predicate)initTestCase.id.eq((Expression)cfv.boundEntityId))).join((EntityPath)tagsValue)).on((Predicate)cfv.id.eq((Expression)tagsValue._super.id))).join((CollectionExpression)tagsValue.selectedOptions, (Path)cfvo)).where((Predicate)cfv.boundEntityType.eq((Object)BindableEntity.TEST_CASE).and((Predicate)initTestCase.id.eq((Expression)outerTestCase.id)).and((Predicate)cfvo.label.in(tags)).and((Predicate)cfv.cufId.eq((Object)filter.getCufId())));
        if (cufTagOperation.equals((Object)CufTagOperation.AND)) {
            subquery = (HibernateQuery)((HibernateQuery)subquery.groupBy((Expression)initTestCase.id)).having((Predicate)cfvo.label.count().eq((Object)size));
        }
        query.where((Predicate)subquery.exists());
        LOGGER.debug("End create filter tags", new Object[0]);
    }
}

