/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.display.campaign.TestPlanItemDisplayService;
import org.squashtest.tm.service.internal.display.campaign.ExecutionSuccessRateCalculator;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanItemExecutionGrid;

@Service
public class TestPlanItemDisplayServiceImpl
implements TestPlanItemDisplayService {
    private final DSLContext dslContext;
    private final ExecutionSuccessRateCalculator executionSuccessRateCalculator;

    public TestPlanItemDisplayServiceImpl(DSLContext dslContext, ExecutionSuccessRateCalculator executionSuccessRateCalculator) {
        this.dslContext = dslContext;
        this.executionSuccessRateCalculator = executionSuccessRateCalculator;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem' ,'READ')  or hasRole('ROLE_ADMIN')")
    public GridResponse getTestPlanItemExecutions(long testPlanItemId, GridRequest gridRequest) {
        TestPlanItemExecutionGrid grid = new TestPlanItemExecutionGrid(testPlanItemId);
        GridResponse response = grid.getRows(gridRequest, this.dslContext);
        this.executionSuccessRateCalculator.appendSuccessRate(response);
        return response;
    }
}

