/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.instruction.targets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;

public class RequirementTarget
implements Target,
WithPath {
    private String path;
    private Integer order;
    private Long id;
    private String remoteKey;
    private Long remoteSynchronisationId;
    private String remoteSynchronisationKind;

    public RequirementTarget() {
    }

    public RequirementTarget(String path) {
        this.setPathPrivately(path);
    }

    public RequirementTarget(String path, Integer order) {
        this.setPathPrivately(path);
        this.order = order;
    }

    @Override
    public EntityType getType() {
        return EntityType.REQUIREMENT;
    }

    @Override
    public boolean isWellFormed() {
        return PathUtils.isPathWellFormed((String)this.path);
    }

    @Override
    public String getProject() {
        return PathUtils.extractUnescapedProjectName((String)this.path);
    }

    @Override
    public String getSourcePath() {
        return this.getPath();
    }

    public void setPath(String path) {
        this.setPathPrivately(path);
    }

    protected void setPathPrivately(String pathParam) {
        String sanitizedPath = pathParam.trim();
        this.path = PathUtils.cleanMultipleSlashes((String)sanitizedPath);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public Integer getOrder() {
        return this.order;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRemoteKey() {
        return this.remoteKey;
    }

    public void setRemoteKey(String remoteKey) {
        this.remoteKey = remoteKey;
    }

    public boolean isSynchronized() {
        return this.remoteKey != null;
    }

    public boolean isImportingSynchronizedReq() {
        return this.remoteSynchronisationKind != null;
    }

    public Long getRemoteSynchronisationId() {
        return this.remoteSynchronisationId;
    }

    public void setRemoteSynchronisationId(Long remoteSynchronisationId) {
        this.remoteSynchronisationId = remoteSynchronisationId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.remoteKey == null ? 0 : this.remoteKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementTarget other = (RequirementTarget)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.remoteKey == null) {
            return other.remoteKey == null;
        }
        return this.remoteKey.equals(other.remoteKey);
    }

    public boolean isRootRequirement() {
        String[] names = PathUtils.splitPath((String)this.path);
        return names.length == 2;
    }

    public boolean isHighLevel() {
        return false;
    }

    public String getName() {
        return PathUtils.unescapePathPartSlashes((String)PathUtils.extractEntityName((String)this.path));
    }

    public Set<String> collectParentNames() {
        return Arrays.stream(PathUtils.splitPath((String)this.path)).map(PathUtils::unescapePathPartSlashes).collect(Collectors.toSet());
    }

    public Set<String> collectParentPaths() {
        String[] pathParts = PathUtils.splitPath((String)this.path);
        HashSet<String> nodePaths = new HashSet<String>();
        StringBuilder currentPath = new StringBuilder();
        int i = 0;
        while (i < pathParts.length) {
            String pathPart = pathParts[i];
            if (i > 0) {
                currentPath.append("/");
            }
            currentPath.append(pathPart);
            nodePaths.add(currentPath.toString());
            ++i;
        }
        return nodePaths;
    }

    public String getRemoteSynchronisationKind() {
        return this.remoteSynchronisationKind;
    }

    public void setRemoteSynchronisationKind(String remoteSynchronisationKind) {
        this.remoteSynchronisationKind = remoteSynchronisationKind;
    }
}

