/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import java.text.ParseException;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.service.internal.batchimport.excel.AbstractTypeBasedCellValueCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.excel.CellValueCoercer;

public final class OptionalDateCellCoercer
extends AbstractTypeBasedCellValueCoercer<Date>
implements CellValueCoercer<Date> {
    public static final OptionalDateCellCoercer INSTANCE = new OptionalDateCellCoercer();

    private OptionalDateCellCoercer() {
    }

    @Override
    protected Date coerceBlankCell(Cell cell) {
        return null;
    }

    @Override
    protected Date coerceStringCell(Cell cell) {
        try {
            return DateUtils.parseIso8601Date((String)cell.getStringCellValue());
        }
        catch (ParseException e) {
            throw new CannotCoerceException(e, "message.import.log.error.field.wrongDateFormat", "message.import.log.impact.fieldNotChange", "message.import.log.impact.useCurrentDate");
        }
    }

    @Override
    protected Date coerceNumericCell(Cell cell) {
        try {
            return cell.getDateCellValue();
        }
        catch (IllegalArgumentException e) {
            throw new CannotCoerceException(e, "message.import.log.error.field.wrongDateFormat", "message.import.log.impact.fieldNotChange", "message.import.log.impact.useCurrentDate");
        }
    }
}

