/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import jakarta.inject.Inject;
import java.util.Map;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.batchexport.ExcelExporter;
import org.squashtest.tm.service.internal.batchexport.models.TestCaseModel;
import org.squashtest.tm.service.internal.batchimport.column.testcase.TestCaseSheetColumn;
import org.squashtest.tm.service.project.ProjectFinder;

@Component
@Scope(value="prototype")
public class SearchTestCaseExcelExporter
extends ExcelExporter {
    private static final TestCaseSheetColumn[] SEARCH_TC_COLUMNS = new TestCaseSheetColumn[]{TestCaseSheetColumn.TC_NB_STEPS, TestCaseSheetColumn.TC_NB_ITERATION};
    private static final TestCaseSheetColumn MILESTONE_SEARCH_TC_COLUMNS = TestCaseSheetColumn.TC_NB_MILESTONES;
    @Inject
    ProjectFinder projectFinder;
    @Inject
    IterationModificationService iterationFinder;

    @Inject
    public SearchTestCaseExcelExporter(FeatureManager featureManager, MessageSource messageSource) {
        super(featureManager, messageSource);
    }

    @Override
    protected void createOptionalTestCaseSheetHeaders() {
        Sheet testCaseSheet = this.workbook.getSheet(ExcelExporter.TC_SHEET);
        Row row = testCaseSheet.getRow(0);
        int cellIndex = row.getLastCellNum();
        if (this.projectFinder.countProjectsAllowAutomationWorkflow() > 0) {
            row.createCell(cellIndex++).setCellValue(TestCaseSheetColumn.TC_AUTOMATABLE.name());
        }
        if (this.isMilestoneModeEnabled) {
            row.createCell(cellIndex++).setCellValue(MILESTONE_SEARCH_TC_COLUMNS.getHeader());
        }
        TestCaseSheetColumn[] testCaseSheetColumnArray = SEARCH_TC_COLUMNS;
        int n = SEARCH_TC_COLUMNS.length;
        int n2 = 0;
        while (n2 < n) {
            TestCaseSheetColumn t = testCaseSheetColumnArray[n2];
            row.createCell(cellIndex++).setCellValue(t.getHeader());
            ++n2;
        }
    }

    @Override
    protected int doOptionalAppendTestCases(boolean shouldAddAutomationWorkflowColumn, Map<Long, Boolean> allowAutomationWorkflowByProjectId, Row row, int cellIndex, TestCaseModel testCaseModel) {
        cellIndex = super.doOptionalAppendTestCases(shouldAddAutomationWorkflowColumn, allowAutomationWorkflowByProjectId, row, cellIndex, testCaseModel);
        if (this.isMilestoneModeEnabled) {
            Long nbMilestone = testCaseModel.getMilestonesCount();
            row.createCell(cellIndex++).setCellValue((double)nbMilestone.longValue());
        }
        Long nbSteps = testCaseModel.getTestStepCount();
        row.createCell(cellIndex++).setCellValue((double)nbSteps.longValue());
        int nbIteration = this.iterationFinder.findIterationContainingTestCase(testCaseModel.getId()).size();
        row.createCell(cellIndex).setCellValue((double)nbIteration);
        return cellIndex;
    }
}

