/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.servers;

import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

public class ManageableTokenAuthCredentials
extends TokenAuthCredentials
implements ManageableCredentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageableTokenAuthCredentials.class);
    private static final long serialVersionUID = 5880712323854651595L;

    public ManageableTokenAuthCredentials() {
    }

    public ManageableTokenAuthCredentials(String token) {
        super(token);
    }

    @Override
    public boolean allowsUserLevelStorage() {
        return true;
    }

    @Override
    public boolean allowsAppLevelStorage() {
        return true;
    }

    @Override
    public boolean allowsProjectLevelStorage() {
        return true;
    }

    private boolean isValid() {
        return !StringUtils.isBlank((CharSequence)this.getToken());
    }

    @Override
    public Credentials build(StoredCredentialsManager storeManager, ThirdPartyServer server, String username) {
        if (this.isValid()) {
            return this;
        }
        LOGGER.debug("Cannot create the credentials because username and/or password is empty. Perhaps were they invalidated ?", new Object[0]);
        return null;
    }
}

