/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.CalledTestCasesPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.KeywordPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.library.LibraryUtils;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AttachmentHolderInfo;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.TestCasePivotImporterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseFolderDao;
import org.squashtest.tm.service.internal.repository.TestCaseLibraryDao;
import org.squashtest.tm.service.internal.testcase.NatureTypeChainFixer;
import org.squashtest.tm.service.internal.testcase.ParameterNamesFinder;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.TestCasePivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.TestCasePivotImporterService;
import org.squashtest.tm.service.requirement.VerifiedRequirementsManagerService;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.DatasetModificationService;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.ParameterModificationService;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Service
public class TestCasePivotImporterServiceImpl
extends AbstractPivotImport
implements TestCasePivotImporterService {
    private static final Logger LOGGER;
    private final TestCasePivotConverterService testCasePivotConverterService;
    private final AdminPivotConverterService adminPivotConverterService;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;
    private final TestCaseLibraryDao testCaseLibraryDao;
    private final TestCaseFolderDao testCaseFolderDao;
    private final TestCaseDao testCaseDao;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final TestCaseModificationService testCaseModificationService;
    private final VerifiedRequirementsManagerService verifiedRequirementsManagerService;
    private final ParameterModificationService parameterModificationService;
    private final DatasetModificationService datasetModificationService;
    private final CallStepManagerService callStepManager;
    private final ParameterFinder parameterFinder;
    private final AttachmentPivotImportService attachmentPivotImportService;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        TestCasePivotImporterServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TestCasePivotImporterService.class);
    }

    public TestCasePivotImporterServiceImpl(TestCasePivotConverterService testCasePivotConverterService, AdminPivotConverterService adminPivotConverterService, TestCaseLibraryNavigationService testCaseLibraryNavigationService, TestCaseLibraryDao testCaseLibraryDao, TestCaseFolderDao testCaseFolderDao, TestCaseDao testCaseDao, PrivateCustomFieldValueService customFieldValueService, TestCaseModificationService testCaseModificationService, VerifiedRequirementsManagerService verifiedRequirementsManagerService, ParameterModificationService parameterModificationService, DatasetModificationService datasetModificationService, CallStepManagerService callStepManager, ParameterFinder parameterFinder, AttachmentPivotImportService attachmentPivotImportService) {
        super(LOGGER);
        this.testCasePivotConverterService = testCasePivotConverterService;
        this.adminPivotConverterService = adminPivotConverterService;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
        this.testCaseLibraryDao = testCaseLibraryDao;
        this.testCaseFolderDao = testCaseFolderDao;
        this.testCaseDao = testCaseDao;
        this.customFieldValueService = customFieldValueService;
        this.testCaseModificationService = testCaseModificationService;
        this.verifiedRequirementsManagerService = verifiedRequirementsManagerService;
        this.parameterModificationService = parameterModificationService;
        this.datasetModificationService = datasetModificationService;
        this.callStepManager = callStepManager;
        this.parameterFinder = parameterFinder;
        this.attachmentPivotImportService = attachmentPivotImportService;
    }

    @Override
    public void importTestCasesFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.TEST_CASES, pivotFormatImport, pivotImportMetadata, "test cases", "test case", this.getTestCasePivotImporterStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<TestCasePivot> getTestCasePivotImporterStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<TestCasePivot>(){

            @Override
            public Class<TestCasePivot> getPivotClazz() {
                return TestCasePivot.class;
            }

            @Override
            public void create(List<TestCasePivot> entities) {
                TestCasePivotImporterServiceImpl.this.createTestCases(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createTestCases(List<TestCasePivot> testCasesToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        HashMap<TestCase, TestCasePivot> createdTestCases = new HashMap<TestCase, TestCasePivot>();
        this.batchCreateHibernateTestCases(testCasesToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport, createdTestCases);
        createdTestCases.forEach((squashTestCase, testCasePivot) -> {
            try {
                this.postProcessCreatedTestCase(pivotImportMetadata, pivotFormatImport, (TestCase)squashTestCase, (TestCasePivot)testCasePivot);
                this.createTestStepsForTestCase((TestCasePivot)testCasePivot, (TestCase)squashTestCase, pivotImportMetadata, pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "test case", testCasePivot.getName(), testCasePivot.getPivotId(), pivotFormatImport, e);
            }
            PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "test case", testCasePivot.getName(), testCasePivot.getPivotId(), pivotFormatImport);
        });
        testCasesToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void batchCreateHibernateTestCases(List<TestCasePivot> testCasesToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport, Map<TestCase, TestCasePivot> createdTestCases) {
        ArrayList<TestCasePivot> testCasesPivotInLibrary = new ArrayList<TestCasePivot>();
        HashMap<String, List<TestCasePivot>> testCasePivotByParentIdMap = new HashMap<String, List<TestCasePivot>>();
        HashMap<TestCase, Map<Long, RawValue>> testCaseCustomFields = new HashMap<TestCase, Map<Long, RawValue>>();
        for (TestCasePivot testCasePivot : testCasesToImport) {
            if (testCasePivot.getParentId() == null) {
                testCasesPivotInLibrary.add(testCasePivot);
                continue;
            }
            testCasePivotByParentIdMap.computeIfAbsent(testCasePivot.getParentId(), k -> new ArrayList()).add(testCasePivot);
        }
        this.addTestCasesToLibrary(projectIdsReferences, testCasesPivotInLibrary, createdTestCases, testCaseCustomFields, pivotFormatImport, pivotImportMetadata);
        this.addTestCasesToFolders(testCasePivotByParentIdMap, createdTestCases, testCaseCustomFields, pivotFormatImport, pivotImportMetadata);
        this.initializeCustomFieldValues(pivotFormatImport, createdTestCases, testCaseCustomFields);
    }

    private void postProcessCreatedTestCase(PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport, TestCase squashTestCase, TestCasePivot testCasePivot) throws IOException {
        pivotImportMetadata.getTestCaseIdsMap().put(testCasePivot.getPivotId(), squashTestCase.getId());
        this.addVerifiedRequirementsToTestCase(pivotImportMetadata.getRequirementVersionIdsMap(), testCasePivot.getVerifiedRequirementVersions(), squashTestCase);
        this.addDatasetParamsToTestCase(squashTestCase, testCasePivot, pivotImportMetadata.getDatasetParamIdsMap(), pivotFormatImport);
        this.addDatasetsToTestCase(squashTestCase, testCasePivot.getDatasets(), pivotImportMetadata);
        this.attachmentPivotImportService.addAttachmentsToEntity(testCasePivot.getAttachments(), new AttachmentHolderInfo(squashTestCase.getId(), squashTestCase.getAttachmentList().getId(), EntityType.TEST_CASE, testCasePivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
    }

    private void addTestCasesToLibrary(ProjectIdsReferences projectIdsReferences, List<TestCasePivot> testCasesToImportInLibrary, Map<TestCase, TestCasePivot> createdTestCases, Map<TestCase, Map<Long, RawValue>> testCaseCustomFields, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        TestCaseLibrary library = (TestCaseLibrary)this.testCaseLibraryDao.loadForNodeAddition(projectIdsReferences.getTestCaseLibraryId());
        List<String> contentNames = this.testCaseLibraryNavigationService.findContentNamesByLibraryId(projectIdsReferences.getTestCaseLibraryId());
        TestCasePivotImporterServiceImpl.fixConflictNames(new ArrayList<String>(), testCasesToImportInLibrary);
        TestCasePivotImporterServiceImpl.fixConflictNames(contentNames, testCasesToImportInLibrary);
        for (TestCasePivot testCasePivot : testCasesToImportInLibrary) {
            this.createAndAddTestCaseToEntity(createdTestCases, testCaseCustomFields, testCasePivot, library, pivotFormatImport, pivotImportMetadata);
        }
    }

    private void addTestCasesToFolders(Map<String, List<TestCasePivot>> testCasePivotByParentIdMap, Map<TestCase, TestCasePivot> createdTestCases, Map<TestCase, Map<Long, RawValue>> testCaseCustomFields, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        List<Long> squashFolderIds = testCasePivotByParentIdMap.keySet().stream().map(parentId -> pivotImportMetadata.getTestCaseFoldersIdsMap().get(parentId)).toList();
        Map<Long, List<String>> folderContentNames = this.testCaseLibraryNavigationService.findContentNamesByFolderIds(squashFolderIds);
        Map testCaseFolderById = this.testCaseFolderDao.loadForNodeAddition(squashFolderIds).stream().collect(Collectors.toMap(TestCaseLibraryNode::getId, Function.identity()));
        testCasePivotByParentIdMap.forEach((parentId, testCasesToImportInFolder) -> {
            Long squashFolderId = pivotImportMetadata.getTestCaseFoldersIdsMap().get(parentId);
            TestCaseFolder folder = (TestCaseFolder)testCaseFolderById.get(squashFolderId);
            TestCasePivotImporterServiceImpl.fixConflictNames(new ArrayList<String>(), testCasesToImportInFolder);
            if (folderContentNames.get(squashFolderId) != null) {
                TestCasePivotImporterServiceImpl.fixConflictNames((List)folderContentNames.get(squashFolderId), testCasesToImportInFolder);
            }
            for (TestCasePivot testCasePivot : testCasesToImportInFolder) {
                this.createAndAddTestCaseToEntity(createdTestCases, testCaseCustomFields, testCasePivot, folder, pivotFormatImport, pivotImportMetadata);
            }
        });
    }

    private <T extends NodeContainer<TestCaseLibraryNode>> void createAndAddTestCaseToEntity(Map<TestCase, TestCasePivot> createdTestCases, Map<TestCase, Map<Long, RawValue>> testCaseCustomFields, TestCasePivot testCasePivot, T container, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        try {
            Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(testCasePivot.getCustomFields(), pivotImportMetadata);
            TestCase testCase = this.testCasePivotConverterService.pivotToTestCase(testCasePivot, pivotImportMetadata);
            container.addContent((TreeNode)testCase);
            this.replaceInfoListReferences(testCase);
            this.testCaseDao.safePersist(testCase);
            createdTestCases.put(testCase, testCasePivot);
            testCaseCustomFields.put(testCase, customFields);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "test case", testCasePivot.getName(), testCasePivot.getPivotId(), pivotFormatImport, e);
        }
    }

    private void replaceInfoListReferences(TestCase testCase) {
        NatureTypeChainFixer.fix(testCase);
    }

    private static void fixConflictNames(List<String> contentNames, List<TestCasePivot> testCasePivots) {
        if (testCasePivots != null && !testCasePivots.isEmpty()) {
            testCasePivots.forEach(testCasePivot -> {
                String newName = LibraryUtils.generateNonClashingName(testCasePivot.getName(), contentNames, 255);
                if (!newName.equals(testCasePivot.getName())) {
                    testCasePivot.setName(newName);
                }
                contentNames.add(newName);
            });
        }
    }

    private void initializeCustomFieldValues(PivotFormatImport pivotFormatImport, Map<TestCase, TestCasePivot> createdTestCases, Map<TestCase, Map<Long, RawValue>> testCaseCustomFields) {
        this.customFieldValueService.createAllCustomFieldValues(createdTestCases.keySet(), (GenericProject)pivotFormatImport.getProject());
        this.customFieldValueService.initBatchCustomFieldValues(testCaseCustomFields);
    }

    private void addDatasetParamsToTestCase(TestCase squashTestCase, TestCasePivot testCasePivot, Map<String, Long> datasetParamIdsMap, PivotFormatImport pivotFormatImport) {
        this.logStartingDatasetParamsImportForTestCase(testCasePivot, pivotFormatImport);
        testCasePivot.getDatasetParams().forEach(datasetParam -> {
            try {
                Parameter parameter = this.parameterModificationService.addNewParameterToTestCaseUnsecured(this.testCasePivotConverterService.pivotToDatasetParameter((DatasetParamPivot)datasetParam), squashTestCase);
                datasetParamIdsMap.put(datasetParam.getPivotId(), parameter.getId());
                this.logDatasetParamImportedSuccessfully((DatasetParamPivot)datasetParam, squashTestCase, pivotFormatImport);
            }
            catch (Exception e) {
                TestCasePivotImporterServiceImpl.logDatasetParamImportFailed(datasetParam, squashTestCase, pivotFormatImport, e);
                throw e;
            }
        });
    }

    private void addDatasetsToTestCase(TestCase squashTestCase, List<DatasetPivot> dataSets, PivotImportMetadata pivotImportMetadata) {
        dataSets.forEach(datasetPivot -> {
            Dataset dataset = this.datasetModificationService.persistUnsecured(this.testCasePivotConverterService.pivotToDataset((DatasetPivot)datasetPivot, this.parameterFinder, pivotImportMetadata.getDatasetParamIdsMap()), squashTestCase);
            pivotImportMetadata.getDatasetIdsMap().put(datasetPivot.getPivotId(), dataset.getId());
        });
    }

    private void createTestStepsForTestCase(TestCasePivot testCasePivot, TestCase testCase, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.logStartingTestStepsImportForTestCase(testCasePivot, pivotFormatImport);
        if (TestCaseKind.STANDARD.equals((Object)testCasePivot.getTestCaseKind())) {
            this.createActionTestSteps(testCasePivot.getActionSteps(), testCase, pivotFormatImport, pivotImportMetadata);
        } else if (TestCaseKind.KEYWORD.equals((Object)testCasePivot.getTestCaseKind())) {
            this.createKeywordTestSteps(testCasePivot.getKeywordSteps(), testCase, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void createActionTestSteps(List<ActionStepPivot> actionTestSteps, TestCase testCase, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) throws IOException {
        HashMap<ActionTestStep, ActionStepPivot> createdActionTestSteps = new HashMap<ActionTestStep, ActionStepPivot>();
        this.batchCreateActionTestSteps(actionTestSteps, testCase, createdActionTestSteps, pivotFormatImport, pivotImportMetadata);
        for (Map.Entry entry : createdActionTestSteps.entrySet()) {
            ActionTestStep testStep = (ActionTestStep)entry.getKey();
            ActionStepPivot actionStepPivot = (ActionStepPivot)entry.getValue();
            try {
                this.addVerifiedRequirementsToTestStep(pivotImportMetadata.getRequirementVersionIdsMap(), actionStepPivot, testStep, testCase);
                pivotImportMetadata.getTestStepsIdsMap().put(actionStepPivot.getPivotId(), testStep.getId());
                this.attachmentPivotImportService.addAttachmentsToEntity(actionStepPivot.getAttachments(), new AttachmentHolderInfo(testCase.getId(), testStep.getAttachmentList().getId(), EntityType.ACTION_TEST_STEP, actionStepPivot.getPivotId()), pivotFormatImport, pivotImportMetadata);
                this.logActionTestStepImportedSuccessfully(actionStepPivot, testCase, pivotFormatImport);
            }
            catch (Exception e) {
                TestCasePivotImporterServiceImpl.logActionTestStepImportFailed(actionStepPivot, testCase, pivotFormatImport, e);
                throw e;
            }
        }
    }

    private void batchCreateActionTestSteps(List<ActionStepPivot> actionTestSteps, TestCase testCase, Map<ActionTestStep, ActionStepPivot> createdActionTestSteps, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetaData) {
        HashMap<ActionTestStep, Map<Long, RawValue>> testStepCustomFields = new HashMap<ActionTestStep, Map<Long, RawValue>>();
        ParameterNamesFinder parameterNamesFinder = new ParameterNamesFinder();
        HashSet<String> parameterNames = new HashSet<String>();
        for (ActionStepPivot actionStepPivot : actionTestSteps) {
            ActionTestStep step = this.testCasePivotConverterService.pivotToActionTestStep(actionStepPivot);
            Map<Long, RawValue> customFields = this.adminPivotConverterService.pivotToCustomFieldValues(actionStepPivot.getCustomFieldValues(), pivotImportMetaData);
            testCase.addStep((TestStep)step);
            this.entityManager.persist((Object)step);
            testStepCustomFields.put(step, customFields);
            parameterNames.addAll(parameterNamesFinder.findParametersNamesInActionAndExpectedResult((TestStep)step));
            createdActionTestSteps.put(step, actionStepPivot);
        }
        this.customFieldValueService.createAllCustomFieldValues(testStepCustomFields.keySet(), (GenericProject)pivotFormatImport.getProject());
        this.customFieldValueService.initBatchCustomFieldValues(testStepCustomFields);
        for (String name : parameterNames) {
            Parameter parameter = testCase.findParameterByName(name);
            if (parameter != null) continue;
            parameter = new Parameter(name);
            parameter.setTestCase(testCase);
        }
    }

    private void createKeywordTestSteps(List<KeywordPivot> keywordPivotList, TestCase testCase, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        keywordPivotList.forEach(keywordStep -> {
            try {
                KeywordTestStep testStep = this.testCaseModificationService.addKeywordTestStep((long)testCase.getId(), keywordStep.getKeyword().name(), keywordStep.getActionWord());
                testStep.setDocstring(keywordStep.getDocString());
                KeywordPivot keywordPivot = keywordStep;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)keywordPivot);
                Object[] objectArray = new Object[]{this, keywordPivot, joinPoint};
                TestCasePivotImporterServiceImpl$AjcClosure1 testCasePivotImporterServiceImpl$AjcClosure1 = new TestCasePivotImporterServiceImpl$AjcClosure1(objectArray);
                testStep.setComment((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotImporterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
                testStep.setDatatable(keywordStep.getDataTable());
                pivotImportMetadata.getTestStepsIdsMap().put(keywordStep.getPivotId(), testStep.getId());
                this.logKeywordTestStepImportedSuccessfully((KeywordPivot)keywordStep, testCase, pivotFormatImport);
            }
            catch (Exception e) {
                TestCasePivotImporterServiceImpl.logKeywordTestStepImportFailed(keywordStep, testCase, pivotFormatImport, e);
                throw e;
            }
        });
    }

    private void addVerifiedRequirementsToTestCase(Map<String, Long> requirementVersionIdsMap, List<String> internalVerifiedRequirementIds, TestCase testCase) {
        List<Long> verifiedRequirementVersionIds = internalVerifiedRequirementIds.stream().map(requirementVersionIdsMap::get).toList();
        this.verifiedRequirementsManagerService.addRequirementVersionsToTestCaseUnsecured(verifiedRequirementVersionIds, testCase);
    }

    private void addVerifiedRequirementsToTestStep(Map<String, Long> requirementVersionIdsMap, ActionStepPivot actionStepPivot, ActionTestStep testStep, TestCase testCase) {
        List<Long> verifiedRequirementVersionIds = actionStepPivot.getVerifiedRequirementVersions().stream().map(requirementVersionIdsMap::get).toList();
        this.verifiedRequirementsManagerService.addRequirementVersionsToTestStepUnsecured(verifiedRequirementVersionIds, testStep, testCase);
    }

    @Override
    public void importCalledTestCasesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.CALLED_TEST_CASES, pivotFormatImport, pivotImportMetadata, "called test cases", "called test case", this.getCalledTestCasePivotImporterStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<CalledTestCasesPivot> getCalledTestCasePivotImporterStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<CalledTestCasesPivot>(){

            @Override
            public Class<CalledTestCasesPivot> getPivotClazz() {
                return CalledTestCasesPivot.class;
            }

            @Override
            public void create(List<CalledTestCasesPivot> entities) {
                TestCasePivotImporterServiceImpl.this.createCalledTestCases(entities, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createCalledTestCases(List<CalledTestCasesPivot> calledTestCasesPivotList, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (CalledTestCasesPivot calledTestCasesPivot : calledTestCasesPivotList) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "called test case", calledTestCasesPivot.getPivotId(), pivotFormatImport);
            try {
                this.createCalledTestCase(calledTestCasesPivot, pivotImportMetadata);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "called test case", calledTestCasesPivot.getPivotId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "called test case", calledTestCasesPivot.getPivotId(), pivotFormatImport, e);
            }
        }
        calledTestCasesPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createCalledTestCase(CalledTestCasesPivot calledTestCasesPivot, PivotImportMetadata pivotImportMetadata) {
        Long squashCallerTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(calledTestCasesPivot.getCallerId());
        Long squashCalledTestCaseId = pivotImportMetadata.getTestCaseIdsMap().get(calledTestCasesPivot.getCalledId());
        CallTestStep callTestStep = Objects.nonNull(calledTestCasesPivot.getIndex()) ? this.callStepManager.addCallTestStepUnsecured(squashCallerTestCaseId, squashCalledTestCaseId, calledTestCasesPivot.getIndex()) : this.callStepManager.addCallTestStepUnsecured(squashCallerTestCaseId, squashCalledTestCaseId);
        this.handleCalledTestCaseDataset(callTestStep, squashCallerTestCaseId, calledTestCasesPivot, pivotImportMetadata.getDatasetIdsMap());
        pivotImportMetadata.getTestStepsIdsMap().put(calledTestCasesPivot.getPivotId(), callTestStep.getId());
    }

    private void handleCalledTestCaseDataset(CallTestStep callTestStep, Long squashCallerTestCaseId, CalledTestCasesPivot calledTestCaseStepToImport, Map<String, Long> datasetIdsMap) {
        if (ParameterAssignationMode.CALLED_DATASET.equals((Object)calledTestCaseStepToImport.getParameterAssignationMode()) && Objects.nonNull(calledTestCaseStepToImport.getDatasetId())) {
            Long squashDatasetId = datasetIdsMap.get(calledTestCaseStepToImport.getDatasetId());
            this.callStepManager.setParameterAssignationModeUnsecured(callTestStep, squashCallerTestCaseId, calledTestCaseStepToImport.getParameterAssignationMode(), squashDatasetId);
        } else {
            this.callStepManager.setParameterAssignationModeUnsecured(callTestStep, squashCallerTestCaseId, calledTestCaseStepToImport.getParameterAssignationMode(), null);
        }
    }

    private void logStartingDatasetParamsImportForTestCase(TestCasePivot testCasePivot, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Starting to dataset params for test case \"{}\". ", new Object[]{pivotFormatImport.getId(), testCasePivot.getName()});
    }

    private void logDatasetParamImportedSuccessfully(DatasetParamPivot datasetParamPivot, TestCase testCase, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Dataset param with name {} and with internal id {} imported successfully for test case \"{}\" successfully.", new Object[]{pivotFormatImport.getId(), datasetParamPivot.getName(), datasetParamPivot.getPivotId(), testCase.getName()});
    }

    private static void logDatasetParamImportFailed(DatasetParamPivot datasetParamPivot, TestCase testCase, PivotFormatImport pivotFormatImport, Exception e) {
        LOGGER.error("Import Id: {} - Error while importing dataset param with name {} internal id {} for test case \"{}\".", new Object[]{pivotFormatImport.getId(), datasetParamPivot.getName(), datasetParamPivot.getPivotId(), testCase.getName(), e});
    }

    private void logStartingTestStepsImportForTestCase(TestCasePivot testCasePivot, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Starting to import test steps for test case \"{}\". ", new Object[]{pivotFormatImport.getId(), testCasePivot.getName()});
    }

    private void logActionTestStepImportedSuccessfully(ActionStepPivot actionStepPivot, TestCase testCase, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Action test step with internal id {} imported successfully for test case \"{}\" successfully.", new Object[]{pivotFormatImport.getId(), actionStepPivot.getPivotId(), testCase.getName()});
    }

    private static void logActionTestStepImportFailed(ActionStepPivot actionStepPivot, TestCase testCase, PivotFormatImport pivotFormatImport, Exception e) {
        LOGGER.error("Import Id: {} - Error while importing action test step with internal id {} for test case \"{}\".", new Object[]{pivotFormatImport.getId(), actionStepPivot.getPivotId(), testCase.getName(), e});
    }

    private void logKeywordTestStepImportedSuccessfully(KeywordPivot keywordPivot, TestCase testCase, PivotFormatImport pivotFormatImport) {
        LOGGER.debug("Import Id: {} - Keyword test step with internal id {} imported successfully for test case \"{}\" successfully.", new Object[]{pivotFormatImport.getId(), keywordPivot.getPivotId(), testCase.getName()});
    }

    private static void logKeywordTestStepImportFailed(KeywordPivot keywordPivot, TestCase testCase, PivotFormatImport pivotFormatImport, Exception e) {
        LOGGER.error("Import Id: {} - Error while importing keyword test step with internal id {} for test case \"{}\"", new Object[]{pivotFormatImport.getId(), keywordPivot.getPivotId(), testCase.getName(), e});
    }

    static final /* synthetic */ String getComment_aroundBody0(TestCasePivotImporterServiceImpl testCasePivotImporterServiceImpl, KeywordPivot keywordPivot, JoinPoint joinPoint) {
        return keywordPivot.getComment();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCasePivotImporterServiceImpl.java", TestCasePivotImporterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getComment", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.KeywordPivot", "", "", "", "java.lang.String"), 564);
    }
}

