/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import jakarta.persistence.EntityManager;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Record3;
import org.jooq.SelectConditionStep;
import org.jooq.TableLike;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.AbstractSprintReqVersionDeletionHandler;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;

public class JdbcSprintReqVersionDeletionHandler
extends AbstractSprintReqVersionDeletionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSprintReqVersionDeletionHandler.class);
    private final Collection<Long> sprintReqVersionIds;

    protected JdbcSprintReqVersionDeletionHandler(DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId, Collection<Long> sprintReqVersionIds) {
        super(dslContext, entityManager, attachmentRepository, reorderHelper, operationId);
        this.sprintReqVersionIds = sprintReqVersionIds;
    }

    public void deleteSprintRequirementVersions() {
        this.logStartProcess();
        this.clearPersistenceContext();
        this.storeEntitiesToDeleteIntoWorkingTable();
        this.performDeletions();
        this.cleanWorkingTable();
        this.logEndProcess();
    }

    private void logStartProcess() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Init deletion process of sprint requirement versions %s. Operation:  %s", this.sprintReqVersionIds, this.operationId), new Object[0]);
        }
    }

    private void storeEntitiesToDeleteIntoWorkingTable() {
        this.storeExecutionsToDeleteIntoWorkingTable();
        this.addSprintReqVersions();
        this.addSprintReqVersionsTestPlans();
        this.addExploratorySessionOverviews();
        this.addSprintReqVersionsTestPlanItems();
        this.addSprintRequirementSyncExtenders();
        this.addCustomFieldValues();
        this.addAttachmentList();
        this.logReferenceEntitiesComplete();
    }

    private void performDeletions() {
        this.performExecutionDeletions();
        this.deleteSprintVersionSyncExtenders();
        this.deleteSprintReqVersionTestPlansItems();
        this.deleteSprintReqVersions();
        this.deleteSprintReqVersionTestPlans();
        this.deleteCustomFieldValues();
        this.deleteAttachmentLists();
        this.deleteAttachmentContents();
    }

    private void logEndProcess() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Deleted sprint requirement versions %s. Time elapsed %s", this.sprintReqVersionIds, this.startDate.until(LocalDateTime.now(), ChronoUnit.MILLIS)), new Object[0]);
        }
    }

    @Override
    protected SelectConditionStep<Record3<Long, String, String>> selectSprintRequirementSyncExtenders() {
        return this.makeSelectClause(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_SYNC_ID).from((TableLike)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).where(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_VERSION_ID.in(this.sprintReqVersionIds));
    }

    @Override
    protected Condition getSprintReqVersionPredicate() {
        return this.getPredicate();
    }

    @Override
    protected Condition getPredicate() {
        return Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID.in(this.sprintReqVersionIds);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

