/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.security.acls.jdbc;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.aspectj.runtime.internal.Conversions;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.jdbc.JdbcAclService;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.UnloadedSidException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.security.acls.CustomPermission;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.Sorting;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.acl.UnknownAclClassException;
import org.squashtest.tm.service.security.acls.jdbc.ManageableAclService;
import org.squashtest.tm.service.security.acls.jdbc.UnsupportedQualifiedNameListSizeException;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;

@Service(value="squashtest.core.security.AclService")
@Transactional
public class JdbcManageableAclService
extends JdbcAclService
implements ManageableAclService,
ObjectAclService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcManageableAclService.class);
    private static final String WITH_ARGS = "' with args [";
    private static final String WILL_ATTEMPT_TO_PERFORM = "Will attempt to perform '";
    private static final String INSERT_OBJECT_IDENTITY = "insert into ACL_OBJECT_IDENTITY (IDENTITY, CLASS_ID) values (?, ?)";
    private static final String SELECT_OBJECT_IDENTITY_PRIMARY_KEY = "select\n    oid.ID\nfrom\n    ACL_OBJECT_IDENTITY oid\n    inner join ACL_CLASS c on c.ID = oid.CLASS_ID\nwhere\n    c.CLASSNAME = ?\n    and oid.IDENTITY = ?";
    private static final String SELECT_CLASS_PRIMARY_KEY = "select ID from ACL_CLASS where CLASSNAME = ?";
    private static final String FIND_ALL_ACL_GROUPS_BY_NAMESPACE = "select ID, QUALIFIED_NAME from ACL_GROUP where QUALIFIED_NAME like ?";
    private static final String INSERT_PARTY_ACL_RESPONSABILITY_SCOPE = "insert into\n    ACL_RESPONSIBILITY_SCOPE_ENTRY (PARTY_ID, ACL_GROUP_ID, OBJECT_IDENTITY_ID)\nvalues (\n    ?,\n    (select ID from ACL_GROUP where ID = ?),\n    (select oid.ID\n    from ACL_OBJECT_IDENTITY oid\n        inner join ACL_CLASS c on c.ID = oid.CLASS_ID\n    where CLASSNAME = ?  and oid.IDENTITY = ? )\n)";
    private static final String FIND_ACL_FOR_CLASS_FROM_PARTY_FILTERED = "select\n    oid.IDENTITY,\n    ag.ID,\n    ag.QUALIFIED_NAME as sorting_key,\n    COALESCE(pro.NAME,'') as project_name\nfrom\n    ACL_GROUP ag\n    inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse on ag.ID = arse.ACL_GROUP_ID\n    inner join ACL_OBJECT_IDENTITY oid on oid.ID = arse.OBJECT_IDENTITY_ID\n    left outer join PROJECT pro on pro.PROJECT_ID = oid.IDENTITY\n    inner join ACL_CLASS ac on ac.ID = oid.CLASS_ID\nwhere\n    arse.PARTY_ID = ?\n    and ac.CLASSNAME in ( ? , ? )\n    and pro.NAME like ?";
    private static final String FIND_ACL_FOR_CLASS_FROM_USER = "select\n    oid.IDENTITY,\n    ag.ID,\n    ag.QUALIFIED_NAME\nfrom\n    ACL_GROUP ag\n    inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse on ag.ID = arse.ACL_GROUP_ID\n    inner join CORE_PARTY cu on arse.PARTY_ID = cu.PARTY_ID\n    inner join ACL_OBJECT_IDENTITY oid on oid.ID = arse.OBJECT_IDENTITY_ID\n    left join CORE_TEAM team on team.PARTY_ID = cu.PARTY_ID\n    left join CORE_TEAM_MEMBER tmemb on tmemb.TEAM_ID = team.PARTY_ID\n    inner join ACL_CLASS ac on ac.ID = oid.CLASS_ID,\n    CORE_USER u\nwhere\n    ((u.PARTY_ID = tmemb.USER_ID) or (u.PARTY_ID = cu.PARTY_ID))\n    and (u.LOGIN = ? )\n    and (ac.CLASSNAME in ( ? , ? ) )";
    private static final String FIND_ACL_FOR_CLASS_FROM_PARTY = "select\n    oid.IDENTITY,\n    ag.ID,\n    ag.QUALIFIED_NAME as sorting_key,\n    COALESCE(pro.NAME,'') as project_name\nfrom\n    ACL_GROUP ag\n    inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse on ag.ID = arse.ACL_GROUP_ID\n    inner join ACL_OBJECT_IDENTITY oid on oid.ID = arse.OBJECT_IDENTITY_ID\n    left outer join PROJECT pro on pro.PROJECT_ID = oid.IDENTITY\n    inner join ACL_CLASS ac on ac.ID = oid.CLASS_ID\nwhere\n    arse.PARTY_ID = ?\n    and ac.CLASSNAME in ( ? , ? )";
    private static final String USER_AND_ACL_GROUP_NAME_FROM_IDENTITY_AND_CLASS = "select\n    arse.PARTY_ID,\n    ag.ID,\n    ag.QUALIFIED_NAME,\n    CONCAT(COALESCE(cu.LOGIN, ''), COALESCE(ct.NAME, '')) as sorting_key,\n    CONCAT(case when cu.LOGIN is NULL then 'TEAM' else 'USER' end, COALESCE(cu.LOGIN, ct.NAME)) as party_type\nfrom\n    ACL_GROUP ag\n    inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse on ag.ID = arse.ACL_GROUP_ID\n    inner join ACL_OBJECT_IDENTITY oid on oid.ID = arse.OBJECT_IDENTITY_ID\n    inner join ACL_CLASS ac on ac.ID = oid.CLASS_ID\n    left outer join CORE_USER cu on arse.PARTY_ID = cu.PARTY_ID\n    left outer join CORE_TEAM ct on arse.PARTY_ID = ct.PARTY_ID\nwhere\n    oid.IDENTITY = ?\n    and ac.CLASSNAME = ?";
    private static final String USER_NAME_FROM_IDENTITY_AND_CLASS = "select\n    cu.LOGIN\nfrom\n    ACL_GROUP ag\n    inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse on ag.ID = arse.ACL_GROUP_ID\n    inner join ACL_OBJECT_IDENTITY oid on oid.ID = arse.OBJECT_IDENTITY_ID\n    inner join ACL_CLASS ac on ac.ID = oid.CLASS_ID\n    left outer join CORE_USER cu on arse.PARTY_ID = cu.PARTY_ID\n    left outer join CORE_TEAM ct on arse.PARTY_ID = ct.PARTY_ID\nwhere\n    oid.IDENTITY = ?";
    private static final String USER_AND_ACL_GROUP_NAME_FROM_IDENTITY_AND_CLASS_FILTERED = "select\n    arse.PARTY_ID,\n    ag.ID,\n    ag.QUALIFIED_NAME,\n    CONCAT(COALESCE(cu.LOGIN, ''),\n    COALESCE(ct.NAME, '')) as sorting_key,\n    CONCAT(case when cu.LOGIN is NULL then 'TEAM' else 'USER' end, COALESCE(cu.LOGIN, ct.NAME)) as party_type\nfrom\n    ACL_GROUP ag\n    inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse on ag.ID = arse.ACL_GROUP_ID\n    inner join ACL_OBJECT_IDENTITY oid on oid.ID = arse.OBJECT_IDENTITY_ID\n    inner join ACL_CLASS ac on ac.ID = oid.CLASS_ID\n    left outer join CORE_USER cu on arse.PARTY_ID = cu.PARTY_ID\n    left outer join CORE_TEAM ct on arse.PARTY_ID = ct.PARTY_ID\nwhere\n    oid.IDENTITY = ?\n    and ac.CLASSNAME = ?\n    and (cu.LOGIN like ? or ct.name like ?)";
    private static final String DELETE_PARTY_RESPONSABILITY_ENTRY = "delete\nfrom ACL_RESPONSIBILITY_SCOPE_ENTRY\nwhere\n    PARTY_ID = ?\n    and OBJECT_IDENTITY_ID = (\n        select\n            oid.ID\n        from\n            ACL_OBJECT_IDENTITY oid\n            inner join ACL_CLASS c on c.ID = oid.CLASS_ID\n        where\n            oid.IDENTITY = ?\n            and c.CLASSNAME = ?\n    )";
    private static final String FIND_OBJECT_WITHOUT_PERMISSION_BY_PARTY = "select\n    nro.IDENTITY\nfrom\n    ACL_OBJECT_IDENTITY nro\n    inner join ACL_CLASS nrc on nro.CLASS_ID = nrc.ID\nwhere\n    nrc.CLASSNAME in ( ? , ? )\n    and not exists (\n        select\n            1\n        from\n            ACL_OBJECT_IDENTITY ro\n            inner join ACL_CLASS rc on rc.ID = ro.CLASS_ID\n            inner join ACL_RESPONSIBILITY_SCOPE_ENTRY r on r.OBJECT_IDENTITY_ID = ro.ID\n        where\n            ro.ID = nro.ID\n            and rc.ID = nrc.ID\n            and r.PARTY_ID = ?\n    )";
    private static final String FIND_PARTIES_WITHOUT_PERMISSION_BY_OBJECT = "select distinct\n    p.PARTY_ID\nfrom\n    CORE_PARTY p\n    left outer join CORE_USER cu on p.PARTY_ID = cu.PARTY_ID\n    left outer join CORE_GROUP_MEMBER cgm ON cu.PARTY_ID = cgm.PARTY_ID\n    left outer join CORE_GROUP cg ON cgm.GROUP_ID = cg.ID\n    left outer join CORE_TEAM ct on p.PARTY_ID = ct.PARTY_ID\nwhere\n    not exists (\n        select\n            1\n        from\n            ACL_OBJECT_IDENTITY aoi\n            inner join ACL_CLASS ac on ac.ID = aoi.CLASS_ID\n            inner join ACL_RESPONSIBILITY_SCOPE_ENTRY arse on arse.OBJECT_IDENTITY_ID = aoi.ID\n        where\n            p.PARTY_ID = arse.PARTY_ID\n            and ac.CLASSNAME in ( ? , ? )\n            and aoi.IDENTITY = ?\n    )\nand (cg.QUALIFIED_NAME is null or cg.QUALIFIED_NAME != ?)";
    private static final String DELETE_OBJECT_IDENTITY = "delete from ACL_OBJECT_IDENTITY where IDENTITY = ? and CLASS_ID = ?";
    private static final String DELETE_ALL_RESPONSABILITY_ENTRIES = "delete\nfrom\n    ACL_RESPONSIBILITY_SCOPE_ENTRY\nwhere\n    OBJECT_IDENTITY_ID = (\n        select\n            oid.ID\n        from\n            ACL_OBJECT_IDENTITY oid\n            inner join ACL_CLASS c on c.ID = oid.CLASS_ID\n        where\n            oid.IDENTITY = ?\n            and c.CLASSNAME = ?\n    )";
    private static final String DELETE_ALL_RESPONSABILITY_ENTRIES_FOR_PARTY = "delete from ACL_RESPONSIBILITY_SCOPE_ENTRY where PARTY_ID = ?";
    private final AclCache aclCache;
    private final RowMapper<AclGroup> permissionGroupMapper = new RowMapper<AclGroup>(){

        public AclGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new AclGroup(rs.getLong(1), rs.getString(2));
        }
    };
    private final RowMapper<Object[]> aclgroupMapper = new RowMapper<Object[]>(){

        public Object[] mapRow(ResultSet rs, int rowNum) throws SQLException {
            Object[] objTab = new Object[]{rs.getLong(1), new AclGroup(rs.getLong(2), rs.getString(3))};
            return objTab;
        }
    };

    @Inject
    public JdbcManageableAclService(DataSource dataSource, LookupStrategy lookupStrategy, AclCache aclCache) {
        super(dataSource, lookupStrategy);
        this.aclCache = aclCache;
        this.setFindChildrenQuery("select null as obj_id, null as class from ACL_OBJECT_IDENTITY where 0 = 1");
    }

    @Override
    public void addNewResponsibility(@NotNull long partyId, @NotNull ObjectIdentity entityRef, @NotNull long profileId) {
        long l = profileId;
        ObjectIdentity objectIdentity = entityRef;
        long l2 = partyId;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(Conversions.longObject((long)l2));
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)objectIdentity);
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$3$e2ae1e40(Conversions.longObject((long)l));
        this.jdbcOperations.update(DELETE_PARTY_RESPONSABILITY_ENTRY, new Object[]{partyId, entityRef.getIdentifier(), entityRef.getType()});
        this.jdbcOperations.update(INSERT_PARTY_ACL_RESPONSABILITY_SCOPE, new Object[]{partyId, profileId, entityRef.getType(), entityRef.getIdentifier()});
        this.evictFromCache(entityRef);
    }

    @Override
    public void removeObjectIdentity(ObjectIdentity objectIdentity) {
        LOGGER.info("Attempting to delete the Object Identity {}", new Object[]{objectIdentity});
        long classId = this.retrieveClassPrimaryKey(objectIdentity.getType());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will attempt to perform 'delete from ACL_OBJECT_IDENTITY where IDENTITY = ? and CLASS_ID = ?' with args [" + String.valueOf(objectIdentity.getIdentifier()) + "," + classId + "]", new Object[0]);
        }
        this.jdbcOperations.update(DELETE_OBJECT_IDENTITY, new Object[]{objectIdentity.getIdentifier(), classId});
        this.evictFromCache(objectIdentity);
    }

    @Override
    public void removeAllResponsibilities(ObjectIdentity entityRef) {
        this.jdbcOperations.update(DELETE_ALL_RESPONSABILITY_ENTRIES, new Object[]{entityRef.getIdentifier(), entityRef.getType()});
        this.evictFromCache(entityRef);
    }

    @Override
    public void removeAllResponsibilities(long partyId) {
        this.jdbcOperations.update(DELETE_ALL_RESPONSABILITY_ENTRIES_FOR_PARTY, new Object[]{partyId});
    }

    @Override
    public void removeAllResponsibilities(@NotNull long partyId, @NotNull ObjectIdentity entityRef) {
        ObjectIdentity objectIdentity = entityRef;
        long l = partyId;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(Conversions.longObject((long)l));
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)objectIdentity);
        this.jdbcOperations.update(DELETE_PARTY_RESPONSABILITY_ENTRY, new Object[]{partyId, entityRef.getIdentifier(), entityRef.getType()});
        this.evictFromCache(entityRef);
    }

    @Override
    public void createObjectIdentity(@NotNull ObjectIdentity objectIdentity) throws AlreadyExistsException {
        ObjectIdentity objectIdentity2 = objectIdentity;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)objectIdentity2);
        LOGGER.info("Attempting to create the Object Identity {}", new Object[]{objectIdentity});
        this.checkObjectIdentityDoesNotExist(objectIdentity);
        long classId = this.retrieveClassPrimaryKey(objectIdentity.getType());
        this.createObjectIdentity(objectIdentity.getIdentifier(), classId);
    }

    private void createObjectIdentity(Serializable objectIdentifier, long classId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will attempt to perform 'insert into ACL_OBJECT_IDENTITY (IDENTITY, CLASS_ID) values (?, ?)' with args [" + String.valueOf(objectIdentifier) + "," + classId + "]", new Object[0]);
        }
        this.jdbcOperations.update(INSERT_OBJECT_IDENTITY, new Object[]{objectIdentifier, classId});
    }

    private void checkObjectIdentityDoesNotExist(ObjectIdentity objectIdentity) {
        if (this.retrieveObjectIdentityPrimaryKey(objectIdentity) != null) {
            throw new AlreadyExistsException("Object identity '" + String.valueOf(objectIdentity) + "' already exists");
        }
    }

    private Long retrieveClassPrimaryKey(String type) throws UnknownAclClassException {
        List classIds;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will attempt to perform 'select ID from ACL_CLASS where CLASSNAME = ?' with args [" + type + "]", new Object[0]);
        }
        if (!(classIds = this.jdbcOperations.queryForList(SELECT_CLASS_PRIMARY_KEY, Long.class, new Object[]{type})).isEmpty()) {
            LOGGER.debug("Found classId {}", new Object[]{classIds.get(0)});
            return (Long)classIds.get(0);
        }
        throw new UnknownAclClassException(type);
    }

    private Long retrieveObjectIdentityPrimaryKey(ObjectIdentity objectIdentity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will attempt to perform 'select\n    oid.ID\nfrom\n    ACL_OBJECT_IDENTITY oid\n    inner join ACL_CLASS c on c.ID = oid.CLASS_ID\nwhere\n    c.CLASSNAME = ?\n    and oid.IDENTITY = ?' with args [" + objectIdentity.getType() + "," + String.valueOf(objectIdentity.getIdentifier()) + "]", new Object[0]);
        }
        try {
            return (Long)this.jdbcOperations.queryForObject(SELECT_OBJECT_IDENTITY_PRIMARY_KEY, Long.class, new Object[]{objectIdentity.getType(), objectIdentity.getIdentifier()});
        }
        catch (DataAccessException notFound) {
            LOGGER.debug("Could not retrieve object identity primary key", (Throwable)notFound);
            return null;
        }
    }

    @Override
    public List<AclGroup> findAllPermissionGroupsByNamespace(@NotNull String namespace) {
        String string = namespace;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return this.jdbcOperations.query(FIND_ALL_ACL_GROUPS_BY_NAMESPACE, this.permissionGroupMapper, new Object[]{namespace + "%"});
    }

    @Override
    public List<Object[]> retrieveClassAclGroupFromPartyId(@NotNull long partyId, String qualifiedClassName) {
        long l = partyId;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(Conversions.longObject((long)l));
        ArrayList<String> qualifiedClassNames = new ArrayList<String>();
        qualifiedClassNames.add(qualifiedClassName);
        return this.retrieveClassAclGroupFromPartyId(partyId, qualifiedClassNames);
    }

    @Override
    public List<Object[]> retrieveClassAclGroupFromPartyId(long partyId, List<String> qualifiedClassNames) {
        List<String> adaptedQualifiedClassNames = this.adaptQualifiedClassNameList(qualifiedClassNames);
        return this.jdbcOperations.query(FIND_ACL_FOR_CLASS_FROM_PARTY, this.aclgroupMapper, new Object[]{partyId, adaptedQualifiedClassNames.get(0), adaptedQualifiedClassNames.get(1)});
    }

    @Override
    public List<Object[]> retrieveClassAclGroupFromUserLogin(String userLogin, String qualifiedClassName) {
        ArrayList<String> qualifiedClassNames = new ArrayList<String>();
        qualifiedClassNames.add(qualifiedClassName);
        return this.retrieveClassAclGroupFromUserLogin(userLogin, qualifiedClassNames);
    }

    @Override
    public List<Object[]> retrieveClassAclGroupFromUserLogin(String userLogin, List<String> qualifiedClassNames) {
        List<String> adaptedQualifiedClassNames = this.adaptQualifiedClassNameList(qualifiedClassNames);
        return this.jdbcOperations.query(FIND_ACL_FOR_CLASS_FROM_USER, this.aclgroupMapper, new Object[]{userLogin, adaptedQualifiedClassNames.get(0), adaptedQualifiedClassNames.get(1)});
    }

    @Override
    public List<Object[]> retrieveClassAclGroupFromPartyId(@NotNull long partyId, String qualifiedClassName, Sorting sorting, Filtering filtering) {
        long l = partyId;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(Conversions.longObject((long)l));
        ArrayList<String> qualifiedClassNames = new ArrayList<String>();
        qualifiedClassNames.add(qualifiedClassName);
        return this.retrieveClassAclGroupFromPartyId(partyId, qualifiedClassNames);
    }

    @Override
    public List<Object[]> retrieveClassAclGroupFromPartyId(long partyId, List<String> qualifiedClassNames, Sorting sorting, Filtering filtering) {
        Object[] arguments;
        String baseQuery;
        List<String> adaptedQualifiedClassNames = this.adaptQualifiedClassNameList(qualifiedClassNames);
        if (filtering.isDefined()) {
            baseQuery = FIND_ACL_FOR_CLASS_FROM_PARTY_FILTERED;
            String filter = "%" + filtering.getFilter() + "%";
            arguments = new Object[]{partyId, adaptedQualifiedClassNames.get(0), adaptedQualifiedClassNames.get(1), filter};
        } else {
            baseQuery = FIND_ACL_FOR_CLASS_FROM_PARTY;
            arguments = new Object[]{partyId, adaptedQualifiedClassNames.get(0), adaptedQualifiedClassNames.get(1)};
        }
        Object orderByClause = sorting.getSortedAttribute() != null && sorting.getSortedAttribute().contains("project.name") ? " order by project_name " : " order by sorting_key ";
        orderByClause = (String)orderByClause + sorting.getSortOrder().getCode();
        String finalQuery = baseQuery + (String)orderByClause;
        return this.jdbcOperations.query(finalQuery, this.aclgroupMapper, arguments);
    }

    @Override
    public List<Long> findObjectWithoutPermissionByPartyId(long partyId, String qualifiedClass) {
        ArrayList<String> qualifiedClassNames = new ArrayList<String>();
        qualifiedClassNames.add(qualifiedClass);
        return this.findObjectWithoutPermissionByPartyId(partyId, qualifiedClassNames);
    }

    @Override
    public List<Long> findObjectWithoutPermissionByPartyId(long partyId, List<String> qualifiedClasses) {
        List<String> adaptedQualifiedClasses = this.adaptQualifiedClassNameList(qualifiedClasses);
        return this.jdbcOperations.queryForList(FIND_OBJECT_WITHOUT_PERMISSION_BY_PARTY, Long.class, new Object[]{adaptedQualifiedClasses.get(0), adaptedQualifiedClasses.get(1), partyId});
    }

    @Override
    public List<String> findUsersWithExecutePermission(List<ObjectIdentity> entityRefs) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        permissions.add(CustomPermission.EXECUTE);
        return this.findUsersWithPermissions(entityRefs, permissions);
    }

    private List<String> findUsersWithPermissions(List<ObjectIdentity> entityRefs, List<Permission> permissionsList) {
        Collection<Acl> aclList = this.findAclList(entityRefs);
        ArrayList<String> resultSidList = new ArrayList<String>();
        for (Acl acl : aclList) {
            for (AccessControlEntry ctrlEntry : acl.getEntries()) {
                this.addPrincipalSid(resultSidList, acl, ctrlEntry, permissionsList);
            }
        }
        return resultSidList;
    }

    private Collection<Acl> findAclList(List<ObjectIdentity> entityRefs) {
        try {
            return this.readAclsById(entityRefs).values();
        }
        catch (NotFoundException nfe) {
            LOGGER.debug("Acl not found for entities.", (Throwable)nfe);
            return Collections.emptyList();
        }
    }

    private void addPrincipalSid(List<String> resultSidList, Acl acl, AccessControlEntry ctrlEntry, List<Permission> permissions) {
        try {
            PrincipalSid principalSid;
            if (acl.isGranted(permissions, Collections.singletonList(ctrlEntry.getSid()), false) && !resultSidList.contains((principalSid = (PrincipalSid)ctrlEntry.getSid()).getPrincipal())) {
                resultSidList.add(principalSid.getPrincipal());
            }
        }
        catch (NotFoundException ex) {
            LOGGER.debug("Error while processing acl list ", (Throwable)ex);
        }
        catch (ClassCastException | NullPointerException | UnloadedSidException ex) {
            LOGGER.warn("Error while processing acl list ", ex);
        }
    }

    @Override
    public List<String> findUsersWithWritePermission(@NotNull List<ObjectIdentity> entityRefs) {
        List<ObjectIdentity> list = entityRefs;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(list);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        permissions.add(BasePermission.WRITE);
        return this.findUsersWithPermissions(entityRefs, permissions);
    }

    protected void evictFromCache(ObjectIdentity oIdentity) {
        if (this.aclCache != null) {
            this.aclCache.evictFromCache(oIdentity);
        }
    }

    @Override
    public List<Object[]> retrievePartyAndAclGroupNameFromIdentityAndClass(long entityId, Class<?> entityClass) {
        return this.jdbcOperations.query(USER_AND_ACL_GROUP_NAME_FROM_IDENTITY_AND_CLASS, this.aclgroupMapper, new Object[]{entityId, entityClass.getCanonicalName()});
    }

    @Override
    public List<Object[]> retrieveUsersFromIdentityAndClass(long entityId) {
        return this.jdbcOperations.query(USER_NAME_FROM_IDENTITY_AND_CLASS, this.aclgroupMapper, new Object[]{entityId});
    }

    @Override
    public List<Object[]> retrievePartyAndAclGroupNameFromIdentityAndClass(long entityId, Class<?> entityClass, Sorting sorting, Filtering filtering) {
        Object[] arguments;
        String baseQuery;
        if (filtering.isDefined()) {
            baseQuery = USER_AND_ACL_GROUP_NAME_FROM_IDENTITY_AND_CLASS_FILTERED;
            String filter = "%" + filtering.getFilter() + "%";
            arguments = new Object[]{entityId, entityClass.getCanonicalName(), filter, filter};
        } else {
            baseQuery = USER_AND_ACL_GROUP_NAME_FROM_IDENTITY_AND_CLASS;
            arguments = new Object[]{entityId, entityClass.getCanonicalName()};
        }
        Object orderByClause = "name".equals(sorting.getSortedAttribute()) ? " order by sorting_key " : ("qualifiedName".equals(sorting.getSortedAttribute()) ? " order by ag.QUALIFIED_NAME " : " order by party_type ");
        orderByClause = (String)orderByClause + sorting.getSortOrder().getCode();
        String finalQuery = baseQuery + (String)orderByClause;
        return this.jdbcOperations.query(finalQuery, this.aclgroupMapper, arguments);
    }

    @Override
    public List<Long> findPartiesWithoutPermissionByObject(long objectId, String qualifiedClassName) {
        ArrayList<String> qualifiedClassNames = new ArrayList<String>();
        qualifiedClassNames.add(qualifiedClassName);
        qualifiedClassNames.add(qualifiedClassName);
        return this.findPartiesWithoutPermissionByObject(objectId, qualifiedClassNames);
    }

    @Override
    public List<Long> findPartiesWithoutPermissionByObject(long objectId, List<String> qualifiedClassNames) {
        this.adaptQualifiedClassNameList(qualifiedClassNames);
        return this.jdbcOperations.queryForList(FIND_PARTIES_WITHOUT_PERMISSION_BY_OBJECT, Long.class, new Object[]{qualifiedClassNames.get(0), qualifiedClassNames.get(1), objectId, "squashtest.authz.group.tm.InfrastructureAdmin"});
    }

    @Override
    public void refreshAcls() {
        this.aclCache.clearCache();
    }

    private List<String> adaptQualifiedClassNameList(List<String> qualifiedClassNameList) {
        if (qualifiedClassNameList == null || qualifiedClassNameList.isEmpty() || qualifiedClassNameList.size() > 2) {
            throw new UnsupportedQualifiedNameListSizeException();
        }
        if (qualifiedClassNameList.size() == 1) {
            qualifiedClassNameList.add(qualifiedClassNameList.get(0));
        }
        return qualifiedClassNameList;
    }
}

