/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.pivot.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;

public final class PivotJsonParsingHelper {
    private PivotJsonParsingHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> getArrayStringValues(JsonParser jsonParser) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            values.add(jsonParser.getValueAsString());
        }
        return values;
    }

    public static boolean isStartingToParseNewObject(JsonParser jsonParser) {
        return JsonToken.START_OBJECT.equals((Object)jsonParser.getCurrentToken());
    }

    public static boolean isNotTheEndOfParsedObject(JsonParser jsonParser) throws IOException {
        return jsonParser.nextToken() != JsonToken.END_OBJECT;
    }

    public static boolean isStartingToParseNewArray(JsonParser jsonParser) {
        return JsonToken.START_ARRAY.equals((Object)jsonParser.getCurrentToken());
    }

    public static boolean isNotTheEndOfParsedArray(JsonParser jsonParser) throws IOException {
        return jsonParser.nextToken() != JsonToken.END_ARRAY;
    }

    public static List<CustomFieldValuePivot> getCustomFieldValues(JsonParser jsonParser) throws IOException {
        ArrayList<CustomFieldValuePivot> customFieldValues = new ArrayList<CustomFieldValuePivot>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            customFieldValues.add(PivotJsonParsingHelper.parseCustomFieldValue(jsonParser));
        }
        return customFieldValues;
    }

    private static CustomFieldValuePivot parseCustomFieldValue(JsonParser jsonParser) throws IOException {
        CustomFieldValuePivot customFieldValue = new CustomFieldValuePivot();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.currentName();
            jsonParser.nextToken();
            if ("id".equals(fieldName)) {
                customFieldValue.setPivotId(jsonParser.getText());
                continue;
            }
            if (!"value".equals(fieldName)) continue;
            customFieldValue.setValue(jsonParser.getValueAsString());
        }
        return customFieldValue;
    }
}

