/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.annotation.EmptyCollectionGuard;
import org.squashtest.tm.service.internal.repository.CustomTestCaseDao;

public interface TestCaseDao
extends Repository<TestCase, Long>,
CustomTestCaseDao {
    @Query
    public List<Long> findAllDistinctTestCasesIdsCalledByTestCase(long var1);

    @Query
    public List<Long> findAllDistinctTestCasesIdsCallingTestCase(long var1);

    @Query
    @EmptyCollectionGuard
    public List<Long> findAllTestCaseIdsByLibraries(@Param(value="libraryIds") Collection<Long> var1);

    @Query
    @EmptyCollectionGuard
    public List<Long> findNodeIdsHavingMultipleMilestones(@Param(value="nodeIds") Collection<Long> var1);

    @Query
    @EmptyCollectionGuard
    public List<Long> findNonBoundTestCases(@Param(value="nodeIds") Collection<Long> var1, @Param(value="milestoneId") Long var2);

    @Query
    @EmptyCollectionGuard
    public List<Long> findAllTestCasesLibraryNodeForMilestone(@Param(value="milestoneIds") Collection<Long> var1);

    @Query
    @Modifying(clearAutomatically=true)
    public void bindScmRepository(@Param(value="testCaseId") long var1, @Param(value="scmRepositoryId") long var3);

    @Query
    @Modifying
    public void unbindScmRepository(@Param(value="testCaseId") long var1);

    @Query(value="select tc.project.automationWorkflowType from TestCase tc where tc.id = :id")
    public AutomationWorkflowType findProjectAutomationWorkflowByTestCaseId(@Param(value="id") Long var1);
}

