/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record7;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectSeekStep2;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.IterationPivot;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.PivotSubElementRecordProcessor;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.IterationPivotDao;

@Repository
public class IterationPivotDaoImpl
implements IterationPivotDao {
    private final DSLContext dsl;
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public IterationPivotDaoImpl(DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        this.dsl = dsl;
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasIterationByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValueIterationByProjectIdQuery(Long projectId) {
        Table<Record7<Long, Long, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.ITERATION);
        return this.dsl.select((SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join(customFieldValuesTable).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ID).fetchSize(50);
    }

    @Override
    public void getIterationByProjectId(Long projectId, Consumer<IterationPivot> objectConsumer) {
        ResultQuery<? extends Record> cufQuery = this.getCustomFieldValueIterationByProjectIdQuery(projectId);
        SelectSeekStep2 resultQuery = this.dsl.select((SelectField)Tables.ITERATION.ITERATION_ID, (SelectField)Tables.ITERATION.NAME, (SelectField)Tables.ITERATION.DESCRIPTION, (SelectField)Tables.ITERATION.REFERENCE, (SelectField)Tables.ITERATION.ITERATION_STATUS, (SelectField)Tables.ITERATION.ACTUAL_START_AUTO, (SelectField)Tables.ITERATION.ACTUAL_END_AUTO, (SelectField)Tables.ITERATION.ACTUAL_START_DATE, (SelectField)Tables.ITERATION.ACTUAL_END_DATE, (SelectField)Tables.ITERATION.SCHEDULED_START_DATE, (SelectField)Tables.ITERATION.SCHEDULED_END_DATE, (SelectField)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, (SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID, (SelectField)Tables.TEST_PLAN_ITEM.LABEL, (SelectField)Tables.TEST_PLAN_ITEM.DATASET_ID).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.ITERATION.ITERATION_ID, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER);
        this.consumeIterations((ResultQuery)resultQuery, (ResultQuery)cufQuery, objectConsumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <I extends Record, C extends Record> void consumeIterations(ResultQuery<I> resultQuery, ResultQuery<C> iterationCufQuery, Consumer<IterationPivot> writingToJsonConsumer) {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Stream stream = resultQuery.fetchStream();
            try {
                try (Stream cufStream = iterationCufQuery.fetchStream();){
                    Iterator iterator = stream.iterator();
                    AbstractPivotObject iterationPivot = null;
                    PivotSubElementRecordProcessor<CustomFieldValuePivot> cufHandler = this.getCufPivotContainer(cufStream.iterator());
                    while (iterator.hasNext()) {
                        Record record = (Record)iterator.next();
                        if (iterationPivot == null) {
                            iterationPivot = this.executionWorkspaceConverterService.iterationRecordToIterationPivot(record);
                            this.appendTestPlanItemToIterationPivot((IterationPivot)iterationPivot, record);
                            continue;
                        }
                        Long mainEntityId = iterationPivot.pivotIdToSquashId();
                        if (!mainEntityId.equals(record.get((Field)Tables.ITERATION.ITERATION_ID))) {
                            ((AbstractPivotEntity)iterationPivot).addAllCustomFields(cufHandler.getPivotSubElements(mainEntityId));
                            writingToJsonConsumer.accept((IterationPivot)iterationPivot);
                            iterationPivot = this.executionWorkspaceConverterService.iterationRecordToIterationPivot(record);
                            this.appendTestPlanItemToIterationPivot((IterationPivot)iterationPivot, record);
                            continue;
                        }
                        this.appendTestPlanItemToIterationPivot((IterationPivot)iterationPivot, record);
                    }
                    if (iterationPivot != null) {
                        ((AbstractPivotEntity)iterationPivot).addAllCustomFields(cufHandler.getPivotSubElements(iterationPivot.pivotIdToSquashId()));
                        writingToJsonConsumer.accept((IterationPivot)iterationPivot);
                    }
                }
                if (stream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stream == null) throw throwable;
                stream.close();
                throw throwable;
            }
            stream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void appendTestPlanItemToIterationPivot(IterationPivot iterationPivot, Record record) {
        if (record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID) != null) {
            iterationPivot.addTestPlanItem(this.executionWorkspaceConverterService.iterationTestPlanItemRecordToTestPlanItemPivot(record));
        }
    }

    private <R extends Record> PivotSubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Iterator<R> iterator) {
        return new PivotSubElementRecordProcessor<CustomFieldValuePivot>(iterator, (Field<Long>)Tables.ITERATION.ITERATION_ID, CustomFieldPivotDao.CFV_TABLE_CF_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot);
    }
}

