/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionModel;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.dto.RequirementVersionImportDto;

public final class ImportedRequirementNode {
    private final String name;
    private final RequirementTarget target;
    private NodeType type = NodeType.REQUIREMENT;
    private TargetStatus status;
    private final Map<String, Set<ImportedRequirementNode>> contents = new HashMap<String, Set<ImportedRequirementNode>>();
    private ImportedRequirementNode parent;
    private boolean importable = true;
    private SortedMap<Integer, RequirementVersionModel> requirementVersions;
    private Set<String> milestonesInVersion;

    private ImportedRequirementNode(String name, RequirementTarget target, TargetStatus status) {
        this.name = name;
        this.target = target;
        this.status = status;
        this.milestonesInVersion = new HashSet<String>();
        this.requirementVersions = new TreeMap<Integer, RequirementVersionModel>();
    }

    private ImportedRequirementNode(String name, RequirementTarget target, TargetStatus status, NodeType type) {
        this.name = name;
        this.target = target;
        this.status = status;
        this.type = type;
    }

    public static ImportedRequirementNode createRequirementNode(RequirementTarget target, TargetStatus status) {
        return new ImportedRequirementNode(target.getName(), target, status);
    }

    public static ImportedRequirementNode createRequirementFolderNode(RequirementTarget target, TargetStatus status) {
        return new ImportedRequirementNode(target.getName(), target, status, NodeType.FOLDER);
    }

    public static ImportedRequirementNode createRequirementLibraryNode(String projectName, Long id) {
        return new ImportedRequirementNode(projectName, new RequirementTarget(projectName), new TargetStatus(Existence.EXISTS, id), NodeType.LIBRARY);
    }

    public void setNotExists(Integer version) {
        this.requirementVersions.put(version, new RequirementVersionModel(TargetStatus.NOT_EXISTS));
    }

    public boolean isRequirement() {
        return NodeType.REQUIREMENT.equals((Object)this.type);
    }

    public boolean isRequirementFolder() {
        return NodeType.FOLDER.equals((Object)this.type);
    }

    public boolean isLibrary() {
        return NodeType.LIBRARY.equals((Object)this.type);
    }

    TargetStatus getStatus() {
        return this.status;
    }

    boolean versionAlreadyLoaded(Integer versionNo) {
        return this.requirementVersions.containsKey(versionNo);
    }

    TargetStatus getVersionStatus(Integer versionNo) {
        RequirementVersionModel versionModel = (RequirementVersionModel)this.requirementVersions.get(versionNo);
        if (versionModel != null) {
            return versionModel.getStatus();
        }
        return null;
    }

    void addVersion(Integer noVersion, TargetStatus status) {
        this.requirementVersions.put(noVersion, new RequirementVersionModel(status));
    }

    public void updateVersionStatus(Integer noVersion, TargetStatus status) {
        ((RequirementVersionModel)this.requirementVersions.get(noVersion)).setStatus(status);
    }

    boolean isMilestoneUsedByOneVersion(String milestone) {
        return this.milestonesInVersion.contains(milestone);
    }

    boolean isVersionMilestoneLocked(Integer noVersion) {
        return ((RequirementVersionModel)this.requirementVersions.get(noVersion)).isMilestoneLocked();
    }

    void bindMilestoneToVersion(Integer noVersion, String milestone) {
        if (!this.isMilestoneUsedByOneVersion(milestone)) {
            RequirementVersionModel rvModel = (RequirementVersionModel)this.requirementVersions.get(noVersion);
            rvModel.addMilestone(milestone);
            this.milestonesInVersion.add(milestone);
        }
    }

    public void setVersionMilestoneLocked(Integer noVersion) {
        RequirementVersionModel rvModel = (RequirementVersionModel)this.requirementVersions.get(noVersion);
        rvModel.setMilestoneLocked(true);
    }

    public RequirementTarget getTarget() {
        return this.target;
    }

    public void addContent(ImportedRequirementNode child) {
        if (child.parent != null) {
            return;
        }
        this.contents.computeIfAbsent(child.getName(), k -> new HashSet()).add(child);
        child.addParent(this);
    }

    private void addParent(ImportedRequirementNode parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynchronized() {
        return this.target.isSynchronized();
    }

    public boolean isImportingSynchronizedReq() {
        return this.target.isImportingSynchronizedReq();
    }

    public Long getId() {
        return this.status.getId();
    }

    public List<ImportedRequirementNode> getContents() {
        return this.contents.values().stream().flatMap(Collection::stream).toList();
    }

    public ImportedRequirementNode getParent() {
        return this.parent;
    }

    public void flagNonImportableRecursively() {
        this.importable = false;
        this.getContents().forEach(ImportedRequirementNode::flagNonImportableRecursively);
    }

    public boolean isImportable() {
        return this.importable;
    }

    public boolean exist() {
        return this.getId() != null;
    }

    public void updateStatus(TargetStatus status) {
        this.status = status;
        for (ImportedRequirementNode child : this.getContents()) {
            child.updateStatus(status);
        }
    }

    public boolean isCurrentVersion(Integer version) {
        if (this.requirementVersions.isEmpty()) {
            return true;
        }
        return this.requirementVersions.lastKey().equals(version);
    }

    public int fixVersion() {
        int previousKey = 0;
        for (int key : this.requirementVersions.keySet()) {
            if (key <= 0) continue;
            if (key > previousKey + 1) {
                return previousKey + 1;
            }
            previousKey = key;
        }
        return previousKey + 1;
    }

    public void deleteVersion(int deprecated) {
        this.requirementVersions.remove(deprecated);
    }

    public boolean existPriorVersion(Integer version) {
        return this.requirementVersions.containsKey(version - 1);
    }

    public RequirementVersionImportDto toRequirementVersionImportDto(Project project) {
        RequirementVersion requirementVersion = new RequirementVersion();
        requirementVersion.setName(this.name);
        requirementVersion.setDescription("");
        requirementVersion.setCategory(project.getRequirementCategories().getDefaultItem());
        return new RequirementVersionImportDto(requirementVersion, Collections.emptyMap(), Collections.emptyList(), false, false, requirementVersion.getStatus());
    }

    public boolean isHighLevelRequirement() {
        return this.target.isHighLevel();
    }

    public boolean isRequirementChild() {
        return this.parent.isRequirement();
    }

    public Long getRemoteSynchronisationId() {
        return this.target.getRemoteSynchronisationId();
    }

    public String getRemoteKey() {
        return this.target.getRemoteKey();
    }

    public Long getVersionId(int version) {
        RequirementVersionModel versionModel = (RequirementVersionModel)this.requirementVersions.get(version);
        if (versionModel == null) {
            return null;
        }
        if (versionModel.getStatus().getStatus() == Existence.EXISTS) {
            return versionModel.getStatus().getId();
        }
        return null;
    }

    public void fix() {
        if (this.isRequirementFolder()) {
            this.type = NodeType.REQUIREMENT;
            this.milestonesInVersion = new HashSet<String>();
            this.requirementVersions = new TreeMap<Integer, RequirementVersionModel>();
            for (ImportedRequirementNode child : this.getContents()) {
                child.fix();
            }
        }
    }

    private static enum NodeType {
        LIBRARY,
        FOLDER,
        REQUIREMENT;

    }
}

