/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.service.annotation.EmptyCollectionGuard;
import org.squashtest.tm.service.internal.repository.CustomCustomFieldValueDao;

public interface CustomFieldValueDao
extends JpaRepository<CustomFieldValue, Long>,
CustomCustomFieldValueDao {
    public static final String ENTITY_TYPE = "entityType";

    @Query
    @Modifying
    @Transactional
    @EmptyCollectionGuard
    public void deleteAll(@Param(value="ids") List<Long> var1);

    @Query
    @Modifying
    @Transactional
    public void deleteAllForBinding(@Param(value="bindingId") Long var1);

    @Query
    @Modifying
    @Transactional
    public void deleteAllForEntity(@Param(value="entityId") Long var1, @Param(value="entityType") BindableEntity var2);

    @Query
    @Modifying
    @Transactional
    @EmptyCollectionGuard
    public void deleteAllForEntities(@Param(value="entityType") BindableEntity var1, @Param(value="entityIds") List<Long> var2);

    @Query
    public List<CustomFieldValue> findAllCustomValues(@Param(value="entityId") long var1, @Param(value="entityType") BindableEntity var3);

    @Query
    @EmptyCollectionGuard
    public List<CustomFieldValue> batchedFindAllCustomValuesFor(@Param(value="entityIds") Collection<Long> var1, @Param(value="entityType") BindableEntity var2);

    @Query
    @EmptyCollectionGuard
    public List<CustomFieldValue> batchedInitializedFindAllCustomValuesFor(@Param(value="entityIds") List<Long> var1, @Param(value="entityType") BindableEntity var2);

    @Query
    @EmptyCollectionGuard
    public List<CustomFieldValue> batchedRestrictedFindAllCustomValuesFor(@Param(value="entityIds") List<Long> var1, @Param(value="entityType") BindableEntity var2, @Param(value="customFields") Collection<CustomField> var3);

    @Query
    public List<CustomFieldValue> findAllCustomValuesOfBinding(@Param(value="bindingId") long var1);

    @Query
    @EmptyCollectionGuard
    public List<CustomFieldValue> findAllCustomValuesOfBindings(@Param(value="bindingIds") List<Long> var1);

    @Query
    public List<CustomFieldValuesPair> findPairedCustomFieldValues(@Param(value="entityType") BindableEntity var1, @Param(value="origEntityId") Long var2, @Param(value="copyEntityId") Long var3);

    @Query
    public Long findBoundEntityId(@Param(value="customFieldValueId") Long var1);

    @Query
    public List<CustomFieldValue> findAllForEntityAndRenderingLocation(@Param(value="entityId") long var1, @Param(value="entityType") BindableEntity var3, @Param(value="location") RenderingLocation var4);

    @Query
    @EmptyCollectionGuard
    public List<String> findAllAvailableTagForEntityInProjects(@Param(value="boundEntityType") BindableEntity var1, @Param(value="projectsIds") List<Long> var2);

    @Query
    public List<CustomFieldValue> findAllCustomValuesOfCustomField(@Param(value="cufId") long var1);

    @Query(value="delete from CustomFieldValue cufValue where cufValue.binding.id in :customFieldBindingIds")
    @Modifying
    public void deleteAllFromBindings(@Param(value="customFieldBindingIds") List<Long> var1);

    public static final class CustomFieldValuesPair {
        private CustomFieldValue original;
        private CustomFieldValue recipient;

        public CustomFieldValuesPair() {
        }

        public CustomFieldValuesPair(CustomFieldValue original, CustomFieldValue recipient) {
            this.original = original;
            this.recipient = recipient;
        }

        public void setOriginal(CustomFieldValue original) {
            this.original = original;
        }

        public void setRecipient(CustomFieldValue recipient) {
            this.recipient = recipient;
        }

        public CustomFieldValue getOriginal() {
            return this.original;
        }

        public CustomFieldValue getRecipient() {
            return this.recipient;
        }

        public void copyContent() {
            RawValue rawValue = this.original.asRawValue();
            rawValue.setValueFor(this.recipient);
        }
    }
}

