/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.service.internal.display.dto.PathNodeDto;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;

@Service(value="squashtest.tm.service.PathHeaderService")
public class EntityPathHeaderServiceImpl
implements EntityPathHeaderService {
    private final EntityPathHeaderDao entityPathHeaderDao;

    public EntityPathHeaderServiceImpl(EntityPathHeaderDao entityPathHeaderDao) {
        this.entityPathHeaderDao = entityPathHeaderDao;
    }

    @Override
    @PreAuthorize(value="hasPermission(#tclnId, 'org.squashtest.tm.domain.testcase.TestCaseLibraryNode', 'READ') or hasRole('ROLE_ADMIN') or hasRole('ROLE_TA_API_CLIENT')")
    public List<PathNodeDto> getTestCaseLibraryNodeHeaderBreadcrumbs(Long tclnId) {
        return this.entityPathHeaderDao.getTestCaseBreadcrumbNodes(tclnId, true);
    }

    @Override
    @PreAuthorize(value="hasPermission(#tclnId, 'org.squashtest.tm.domain.testcase.TestCaseLibraryNode', 'READ') or hasRole('ROLE_ADMIN') or hasRole('ROLE_TA_API_CLIENT')")
    public String buildTestCaseLibraryNodePathStringFromBreadcrumbs(Long tclnId, boolean excludeCurrentNode) {
        List<PathNodeDto> crumbs = this.entityPathHeaderDao.getTestCaseBreadcrumbNodes(tclnId, excludeCurrentNode);
        return crumbs.stream().map(PathNodeDto::name).collect(Collectors.joining(" > "));
    }

    @Override
    @PreAuthorize(value="hasPermission(#rlnId, 'org.squashtest.tm.domain.requirement.RequirementLibraryNode', 'READ') or hasRole('ROLE_ADMIN')")
    public List<PathNodeDto> getRequirementLibraryNodeHeaderBreadcrumbs(Long rlnId) {
        return this.entityPathHeaderDao.getRequirementBreadcrumbNodes(rlnId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#clnId, 'org.squashtest.tm.domain.campaign.CampaignLibraryNode', 'READ') or hasRole('ROLE_ADMIN')")
    public List<PathNodeDto> getCampaignLibraryNodeHeaderBreadcrumbs(Long clnId, boolean excludeCurrentNode) {
        return this.entityPathHeaderDao.getCampaignBreadcrumbNodes(clnId, excludeCurrentNode);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration' , 'READ') or hasRole('ROLE_ADMIN') or hasRole('ROLE_TA_API_CLIENT')")
    public List<PathNodeDto> getIterationHeaderBreadcrumbs(Long iterationId) {
        return this.entityPathHeaderDao.getIterationBreadcrumbNodes(iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#executionId, 'org.squashtest.tm.domain.execution.Execution', 'READ') or hasRole('ROLE_ADMIN')")
    public List<PathNodeDto> getExecutionHeaderBreadcrumbs(Long executionId) {
        return this.entityPathHeaderDao.getExecutionBreadcrumbNodes(executionId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sessionOverviewId, 'org.squashtest.tm.domain.campaign.ExploratorySessionOverview', 'READ') or hasRole('ROLE_ADMIN')")
    public List<PathNodeDto> getExploratorySessionOverviewHeaderBreadcrumbs(Long sessionOverviewId) {
        return this.entityPathHeaderDao.getExploratorySessionOverviewBreadcrumbNodes(sessionOverviewId);
    }

    @Override
    @UsedInPlugin(value="Xsquash4GitLab")
    public Map<Long, String> buildRequirementPathsByIds(Collection<Long> requirementIds) {
        if (requirementIds == null || requirementIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.entityPathHeaderDao.buildRequirementPathByIds(requirementIds);
    }
}

